/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.configuration.fHTTPConfig;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.http.HttpHeaderDefinitions;
import com.pcbsys.foundation.drivers.http.fBaseCometDriver;
import com.pcbsys.foundation.drivers.http.fBaseHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTP11Driver;
import com.pcbsys.foundation.drivers.http.fHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fLongPollDriverFlusher;
import com.pcbsys.foundation.drivers.http.fLongPollTask;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fByteArrayOutputStream;
import com.pcbsys.foundation.io.javascript.fStreamWrapperInterface;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fAsciiEncoder;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class fLongPollDriver
extends fBaseCometDriver {
    private static final fLongPollDriverFlusher myIdleQueue = new fLongPollDriverFlusher();
    private static final fLongPollDriverFlusher myActiveQueue = new fLongPollDriverFlusher();
    private static final byte[] startPackingLP = "LPReadyStateCB([".getBytes();
    private static final byte[] sHTTP11HeaderClose = ("HTTP/1.1 200 OK\r\nDate: " + new Date() + "\r\n" + fBaseHTTPDriver.sMyServerString + "Cache-Control: no-store,no-cache\r\nConnection: close\r\n").getBytes();
    private static final byte[] sHTTP10Header = ("HTTP/1.0 200 OK\r\nDate: " + new Date() + "\r\n" + fBaseHTTPDriver.sMyServerString + "Cache-Control: no-store,no-cache\r\n").getBytes();
    private static final byte[] sGZipped = "Content-Encoding: gzip\r\n".getBytes();
    private static final byte[] sContentLength = "Content-Length: ".getBytes();
    private static final byte[] sContentType = "Content-Type: application/javascript\r\n".getBytes();
    private static final byte[] sEnd = "\r\n".getBytes();
    private static final byte[] sJSOrigin = "Access-Control-Allow-Origin: ".getBytes();
    private static final byte[] sJSOriginCredentials = "Access-Control-Allow-Credentials: true\r\n".getBytes();
    private static final String longPollType = "lp";
    private static final String longPollSType = "lps";
    private long myIdleWait = 60000L;
    private long myCompletionWait = 50L;
    private final fConnectionDetails ret;
    private final boolean isJsonPStream;
    private boolean isFirstFlush;
    private long myLastFlushPacket;
    private final LockedOutputStream lockedOutputStream;
    private boolean isClosing = true;

    public fLongPollDriver(fHTTPDriver fHTTPDriver2, fLoginContext fLoginContext2, fSubject fSubject2, fHTTPHeader fHTTPHeader2, fServerHTTPBaseDriver fServerHTTPBaseDriver2) throws IOException {
        super(fHTTPDriver2, fLoginContext2, fSubject2, fHTTPHeader2, fServerHTTPBaseDriver2);
        this.ret = fHTTPDriver2.getLowerDriver().getConnectionDetails();
        fHTTPDriver2.getLowerDriver().setTimeout((int)this.myIdleWait * 2);
        this.isJsonPStream = fHTTPHeader2.isLongPollJsonP();
        this.isFirstFlush = true;
        this.myType = this.isSSL ? longPollSType : longPollType;
        this.setProtocolId(this.myType);
        this.myLastFlushPacket = 0L;
        this.lockedOutputStream = new LockedOutputStream();
        this.myOutputStream = this.lockedOutputStream;
    }

    @Override
    public void open() throws IOException, fException {
        super.open();
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Protocol: " + this.myType + ": " + this.getId() + " connected.");
        }
    }

    @Override
    public void close() throws IOException, fException {
        if (!this.isClosed()) {
            this.myOutputStream.close();
            super.close();
        }
    }

    @Override
    public boolean supportAsyncReading() {
        return true;
    }

    @Override
    public boolean supportAsyncWriting() {
        return false;
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        return new fConnectionDetails(10, this.ret.getHost(), this.ret.getPort(), this.ret.getFile());
    }

    @Override
    public int getTimeout() {
        return 10;
    }

    @Override
    public void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        super.registerListener(fAsyncReadListener2);
        if (this.myPis.available() != 0) {
            this.myListener.dataReady();
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.myPis;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    @Override
    public boolean pushData(InputStream inputStream, fHTTPDriver fHTTPDriver2, fHTTPHeader fHTTPHeader2) throws IOException {
        boolean bl = fHTTPHeader2.isLongPollFlush();
        if (!bl) {
            if (fHTTPHeader2.cometRequestNumber() < this.myNextRequestNumber && this.myNextRequestNumber != 0) {
                throw new IOException("Received old javascript request, closing connection.");
            }
            this.myNextRequestNumber = fHTTPHeader2.cometRequestNumber() + 1;
        }
        if (!fHTTPHeader2.isGet()) {
            fHTTPHeader2.loadRemaining(inputStream);
        }
        if (fHTTPHeader2.ContentLength() > 0) {
            this.pushData(fHTTPHeader2.getBuffer(), fHTTPHeader2.getParametersStartIndex(), fHTTPHeader2.getParametersEndIndex() - fHTTPHeader2.getParametersStartIndex(), fHTTPHeader2.getEndoOfHeaderLocation(), fHTTPHeader2.ContentLength());
        } else {
            this.pushData(fHTTPHeader2.getBuffer(), fHTTPHeader2.getParametersStartIndex(), fHTTPHeader2.getParametersEndIndex() - fHTTPHeader2.getParametersStartIndex(), -1, 0);
        }
        if (bl) {
            this.lockedOutputStream.scheduleTask(fHTTPDriver2, fHTTPHeader2);
        } else if (this.isJsonPStream) {
            OutputStream outputStream = fHTTPDriver2.getOutputStream();
            this.generateHeader(outputStream, 0, false, fHTTPHeader2, false);
            outputStream.flush();
        } else {
            fHTTPHeader2.setCorsSupport(this.corsSupport);
            fHTTPDriver2.sendOKHeaders(fHTTPHeader2, fHTTPHeader2.isCometCloseRequest());
            fHTTPDriver2.deallocate();
        }
        return false;
    }

    @Override
    public void setLastWrite() {
    }

    public void setIdleWait(long l) {
        this.myIdleWait = l;
    }

    public void setCompletionWait(long l) {
        this.myCompletionWait = l;
    }

    public void flushIO(fHTTPDriver fHTTPDriver2, fHTTPHeader fHTTPHeader2) throws IOException {
        try {
            fHTTPDriver2.getLowerDriver().setTimeout((int)this.myIdleWait * 2);
            if (!this.lockedOutputStream.isFirstFlushInt || this.lockedOutputStream.myOs.size() > 0 && this.lockedOutputStream.isFirstFlushInt) {
                this.lockedOutputStream.sendBuffer(fHTTPDriver2, fHTTPHeader2);
                super.setLastWrite();
            } else {
                this.lockedOutputStream.myTask = null;
                this.lockedOutputStream.scheduleTask(fHTTPDriver2, fHTTPHeader2);
            }
        }
        catch (Exception exception) {
            try {
                this.close();
            }
            catch (fException fException2) {
                // empty catch block
            }
        }
    }

    private void generateHeader(OutputStream outputStream, int n, boolean bl, fHTTPHeader fHTTPHeader2, boolean bl2) throws IOException {
        String string;
        if (fHTTPHeader2.getVersion() == HttpHeaderDefinitions.HttpVersion.version_1_1) {
            if (this.isClosing || !fHTTPHeader2.isCometCloseRequest()) {
                this.isClosing = true;
                outputStream.write(sHTTP11HeaderClose);
            } else {
                outputStream.write(fHTTP11Driver.sOKHeaders);
            }
        } else {
            outputStream.write(sHTTP10Header);
        }
        if (n > 0 || fHTTPHeader2.getVersion() == HttpHeaderDefinitions.HttpVersion.version_1_1) {
            outputStream.write(sContentLength);
            outputStream.write(fAsciiEncoder.encodeInt(n));
            outputStream.write(sEnd);
            if (this.isJsonPStream && bl2) {
                outputStream.write(sContentType);
            }
        }
        if (this.corsSupport) {
            this.writeOrigin(outputStream, fHTTPHeader2);
        }
        if (bl) {
            outputStream.write(sGZipped);
        }
        if (this.myBase.getHeaderFactory().getSize() > 0 && (string = this.myBase.getHeaderFactory().getHeaders(fHTTPHeader2.UserAgent())) != null) {
            outputStream.write(string.getBytes());
        }
        outputStream.write(sEnd);
    }

    protected void writeOrigin(OutputStream outputStream, fHTTPHeader fHTTPHeader2) throws IOException {
        int n = fHTTPHeader2.getOriginStartIndex();
        if (n > -1) {
            String string = fStringByteConverter.convert(fHTTPHeader2.getBuffer(), n, fHTTPHeader2.getOriginEndIndex() - n);
            if (this.hasMatchingOrigin(string, outputStream)) {
                if (((fHTTPConfig)this.myBase.getConfig()).isAllowCrossOriginCredentials()) {
                    outputStream.write(sJSOriginCredentials);
                }
            } else if (fConnectionDetails.sEnableConnectionDebug) {
                fLongPollDriver.log("[CORS] CORS Connection " + string + " reject as did not match " + ((fHTTPConfig)this.myBase.getConfig()).getAllowedOrigins());
            }
        } else if (fConnectionDetails.sEnableConnectionDebug) {
            fLongPollDriver.log("[CORS] CORS Connection reject as did not match as there is no Origin present on header. ");
        }
    }

    protected boolean hasMatchingOrigin(String string, OutputStream outputStream) throws IOException {
        String[] stringArray = ((fHTTPConfig)this.myBase.getConfig()).getAllowedOriginsAsArray();
        if (((fHTTPConfig)this.myBase.getConfig()).isAllowedAllOrigins()) {
            if (outputStream != null) {
                outputStream.write(sJSOrigin);
                outputStream.write("*".getBytes());
                outputStream.write(sEnd);
            }
            return true;
        }
        if (stringArray == null) {
            return false;
        }
        boolean bl = this.matchOrigin(stringArray, string, outputStream);
        return bl;
    }

    private boolean matchOrigin(String[] stringArray, String string, OutputStream outputStream) throws IOException {
        for (String string2 : stringArray) {
            for (String string3 : string.split(" ")) {
                if (!string2.equals(string3)) continue;
                if (outputStream != null) {
                    outputStream.write(sJSOrigin);
                    outputStream.write(string3.getBytes());
                    outputStream.write(sEnd);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isJsonPStream() {
        return this.isJsonPStream;
    }

    public class LockedOutputStream
    extends fStreamWrapperInterface {
        private final fByteArrayOutputStream myOs;
        private boolean isIdle;
        private boolean responseQueued;
        private fLongPollTask myTask;
        private boolean isFirstFlushInt;

        public LockedOutputStream() {
            super(new fByteArrayOutputStream(fBaseCometDriver.sPipedBufferSize));
            this.isFirstFlushInt = true;
            this.myOs = (fByteArrayOutputStream)this.myOutputStream;
            this.isIdle = true;
            fLongPollDriver.this.isClosing = false;
            this.myTask = null;
            this.responseQueued = false;
        }

        @Override
        public synchronized void write(byte[] byArray) throws IOException {
            if (this.isClosed) {
                throw new IOException("Connection closed");
            }
            this.myOutputStream.write(byArray);
            this.bytesSent += (long)byArray.length;
        }

        @Override
        public synchronized void write(int n) throws IOException {
            if (this.isClosed) {
                throw new IOException("Connection closed");
            }
            this.myOutputStream.write(n);
            ++this.bytesSent;
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.isClosed) {
                throw new IOException("Connection closed");
            }
            this.myOutputStream.write(byArray, n, n2);
            this.bytesSent += (long)n2;
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.isClosed) {
                throw new IOException("Connection closed");
            }
            this.myOutputStream.flush();
            if (this.myOs.size() != 0) {
                if (this.myTask != null) {
                    if (this.isIdle) {
                        this.isIdle = false;
                        myIdleQueue.del(this.myTask);
                        if (!myActiveQueue.contains(this.myTask)) {
                            if (this.responseQueued) {
                                this.myTask.setTimeout(System.currentTimeMillis());
                                this.responseQueued = false;
                            } else {
                                this.myTask.setTimeout(System.currentTimeMillis() + fLongPollDriver.this.myCompletionWait);
                            }
                            myActiveQueue.add(this.myTask);
                        } else {
                            this.myTask.setTimeout(System.currentTimeMillis());
                            this.responseQueued = false;
                        }
                    } else if (this.responseQueued) {
                        this.myTask.setTimeout(System.currentTimeMillis());
                        this.responseQueued = false;
                    }
                }
                this.notify();
            }
            if (fLongPollDriver.this.getLastWrite() + 90000L < fTimer.getTicks()) {
                throw new IOException("Connection timed out");
            }
            fLongPollDriver.this.setLastWrite();
        }

        @Override
        public synchronized void markStartOfMessage() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream Closed, Unable to write");
            }
            if (this.isQueued) {
                this.writeArraySeparator();
            } else {
                this.isQueued = true;
                this.markStartPacket();
                this.writeArraySeparator();
            }
        }

        private void markStartPacket() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream Closed, Unable to write");
            }
            if (fLongPollDriver.this.isJsonPStream()) {
                this.myOutputStream.write(startPackingLP);
                this.bytesSent += (long)startPackingLP.length;
            } else {
                this.writeArrayStart();
            }
            this.myOutputStream.write(fStringByteConverter.convert("{\"d\":[7," + fLongPollDriver.this.myLastFlushPacket++ + "]}"));
        }

        @Override
        public synchronized void flushImmediately() {
            this.responseQueued = true;
        }

        @Override
        public synchronized void close() throws IOException {
            if (fLongPollDriver.this.isClosing) {
                return;
            }
            this.isIdle = true;
            fLongPollDriver.this.isClosing = true;
            if (this.myTask != null) {
                myIdleQueue.del(this.myTask);
                myActiveQueue.del(this.myTask);
                try {
                    this.myTask.run();
                }
                catch (Throwable throwable) {
                    fConstants.logger.debug(throwable);
                }
            }
            super.close();
            this.notify();
        }

        public synchronized void scheduleTask(fHTTPDriver fHTTPDriver2, fHTTPHeader fHTTPHeader2) {
            if (this.myTask != null) {
                myActiveQueue.del(this.myTask);
                myIdleQueue.del(this.myTask);
                this.myTask.run();
            }
            this.myTask = new fLongPollTask(fLongPollDriver.this, fHTTPDriver2, fHTTPHeader2);
            if (fLongPollDriver.this.isFirstFlush || this.myOs.size() != 0) {
                fLongPollDriver.this.isFirstFlush = false;
                this.myTask.setTimeout(System.currentTimeMillis() + fLongPollDriver.this.myCompletionWait);
                myActiveQueue.add(this.myTask);
            } else {
                this.myTask.setTimeout(System.currentTimeMillis() + fLongPollDriver.this.myIdleWait);
                myIdleQueue.add(this.myTask);
            }
            fHTTPDriver2.allocate();
        }

        public synchronized void sendBuffer(fHTTPDriver fHTTPDriver2, fHTTPHeader fHTTPHeader2) throws IOException {
            OutputStream outputStream;
            this.myTask = null;
            this.isIdle = true;
            if (!this.isQueued) {
                this.markStartPacket();
            }
            this.isQueued = false;
            if (fLongPollDriver.this.isJsonPStream) {
                this.myOutputStream.write("]);".getBytes());
                this.bytesSent += 3L;
            } else {
                this.myOutputStream.write("]".getBytes());
                ++this.bytesSent;
            }
            byte[] byArray = this.myOs.toByteArray();
            boolean bl = false;
            if (((fHTTPConfig)fLongPollDriver.this.myBase.getConfig()).getEnableGZIP() && byArray.length > ((fHTTPConfig)fLongPollDriver.this.myBase.getConfig()).getMinimumBytesBeforeGZIP()) {
                outputStream = new ByteArrayOutputStream();
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
                gZIPOutputStream.write(byArray);
                gZIPOutputStream.flush();
                gZIPOutputStream.finish();
                fMemoryManager.getInstance().release(byArray);
                byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                bl = true;
            }
            if (this.isFirstFlushInt) {
                this.isFirstFlushInt = false;
            }
            outputStream = fHTTPDriver2.getOutputStream();
            fLongPollDriver.this.generateHeader(outputStream, byArray.length, bl, fHTTPHeader2, true);
            outputStream.write(byArray);
            outputStream.flush();
            this.myOs.reset();
            fMemoryManager.getInstance().release(byArray);
        }
    }
}

