/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.configuration.fHTTPConfig;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fHTTPDSession;
import com.pcbsys.foundation.drivers.fHTTPInstanceDriver;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.fServerDriverFactory;
import com.pcbsys.foundation.drivers.fStatusHandler;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.http.HttpHeaderDefinitions;
import com.pcbsys.foundation.drivers.http.fClientDriverMap;
import com.pcbsys.foundation.drivers.http.fCookieGenerator;
import com.pcbsys.foundation.drivers.http.fHTTP10Driver;
import com.pcbsys.foundation.drivers.http.fHTTP11Driver;
import com.pcbsys.foundation.drivers.http.fHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fHTTPHeaderFactory;
import com.pcbsys.foundation.drivers.http.fWebSocketDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fDriverConnectionMonitor;
import com.pcbsys.foundation.security.fDriverMonitorEntry;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import com.pcbsys.foundation.utils.fDebugConfigManager;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.login.LoginException;

public abstract class fServerHTTPBaseDriver
extends fServerDriver
implements fAcceptHandler {
    static final fDebugConfigManager myDebugManager = fDebugConfigManager.getInstance();
    public static boolean sMasterEnable_1_1 = true;
    public static boolean sMasterWebSocketEnable = true;
    private static long myCheckInterval = 5000L;
    private static long myTimeOutValue = 120000L;
    private static int myReadTimeout = 20000;
    protected final fClientDriverMap mySessions = new fClientDriverMap();
    private final fClientDriverMap myMultiplexedSessions = new fClientDriverMap();
    protected final fClientDriverMap myUnauthorizedSessions = new fClientDriverMap();
    protected final fServerLoginContext myLoginCtx;
    final fDriverConnectionMonitor myConnectionMonitor;
    private final fHTTPHeaderFactory myHeaderFactory;
    private final fHTTPHeader[] myHeaderInfos;
    private static final byte[] sMyContentType = "binary/stream".getBytes();
    private static final byte[] sMyContentTypeJavascript = "text/html; charset=UTF-8".getBytes();
    private static final byte[] sMyContentTypeJavascriptSSE = "text/event-stream".getBytes();
    private fServerDriver myServerDriver;
    private fStatusHandler myStatusHandler;
    protected final String myCookieId;
    protected boolean isSSL;
    private final boolean enable11;
    private final boolean enableWebSocket;
    private final boolean enableComet;

    public static void setTimeoutValue(long l) {
        myTimeOutValue = l;
    }

    public static long getTimeoutValue() {
        return myTimeOutValue;
    }

    public static void setScanRate(long l) {
        myCheckInterval = l;
    }

    public static long getScanRate() {
        return myCheckInterval;
    }

    public static int getReadTimeOut() {
        return myReadTimeout;
    }

    public static void setReadTimeOut(int n) {
        myReadTimeout = n;
    }

    public fServerHTTPBaseDriver(fAcceptHandler fAcceptHandler2, fHTTPConfig fHTTPConfig2) {
        super(fAcceptHandler2, fHTTPConfig2.getName());
        this.config = fHTTPConfig2;
        this.myConnectionMonitor = new fDriverConnectionMonitor("HTTP Parser:" + fHTTPConfig2.getName(), fHTTPConfig2.getBacklog(), fHTTPConfig2.getAuthTimeOut(), 2);
        this.myStatusHandler = null;
        this.myLoginCtx = fServerLoginContext.getInstance(fHTTPConfig2.getProtocol());
        this.myLoginCtx.setConfig(this.config);
        this.myCookieId = "nirvana_" + fCookieGenerator.getInterfaceIdentifier() + "=";
        this.enableWebSocket = ((fHTTPConfig)this.config).isWebSocketEnabled() && sMasterWebSocketEnable;
        this.enableComet = ((fHTTPConfig)this.config).isNativeCometAllowed();
        this.enable11 = ((fHTTPConfig)this.config).isHTTP11Enabled() && sMasterEnable_1_1 && fHTTPConfig2.isAllowNIO();
        this.myHeaderFactory = new fHTTPHeaderFactory(((fHTTPConfig)this.config).getCustomHeaders());
        this.myHeaderInfos = new fHTTPHeader[fHTTPConfig2.getThreadCount()];
        for (int i = 0; i < this.myHeaderInfos.length; ++i) {
            this.myHeaderInfos[i] = new fHTTPHeader();
        }
        fThreadScheduler.getInstance().addTask(new SessionTrimmer(), myCheckInterval);
    }

    protected void commsInit() throws IOException {
        if (this.config.getProtocol().equals(fConnectionDetails.getProtocolString(3))) {
            this.myServerDriver = fServerDriverFactory.getServerDriver(this.config, this, fConnectionDetails.getProtocolString(5));
            this.myServerDriver.setName("HTTP-SSLSocketAccept");
            this.isSSL = true;
        } else if (this.config.getProtocol().equals(fConnectionDetails.getProtocolString(1))) {
            this.myServerDriver = fServerDriverFactory.getServerDriver(this.config, this, fConnectionDetails.getProtocolString(4));
            this.myServerDriver.setName("HTTP-SocketAccept");
            this.isSSL = false;
        }
        this.myUsage = this.myServerDriver.getUsage();
    }

    byte[] getContentEncoding() {
        return sMyContentType;
    }

    byte[] getContentEncodingJavascript() {
        return sMyContentTypeJavascript;
    }

    byte[] getContentEncodingJavascriptSSE() {
        return sMyContentTypeJavascriptSSE;
    }

    fHTTPHeaderFactory getHeaderFactory() {
        return this.myHeaderFactory;
    }

    public void closeDriver(fHTTPInstanceDriver fHTTPInstanceDriver2) {
        this.mySessions.remove(fHTTPInstanceDriver2.getKey());
    }

    @Override
    public void accept(fDriver fDriver2, fServerDriver fServerDriver2) {
        if (myDebugManager != null && myDebugManager.getConfig(fDriver2.getId()) != null) {
            fConstants.logger.error("Protocol: HTTPD: Connection from " + fDriver2.getId());
        }
        try {
            fHTTPHeader fHTTPHeader2 = this.allocate();
            if (fDriver2.supportAsyncReading()) {
                this.asyncAccept(fDriver2, fHTTPHeader2);
            } else {
                this.syncAccept(fDriver2, fHTTPHeader2);
            }
        }
        catch (Throwable throwable) {
            fConstants.logger.info("Accept-" + this.getClass().getName() + " failed on driver=" + this.getClass().getName() + " - " + throwable);
            try {
                fDriver2.close();
            }
            catch (Throwable throwable2) {
                fConstants.logger.info("Failed to close driver after Accept failure - " + fDriver2 + " - " + throwable2);
            }
        }
    }

    private void asyncAccept(fDriver fDriver2, fHTTPHeader fHTTPHeader2) {
        try {
            new AsyncAcceptHelper(fDriver2, fHTTPHeader2);
        }
        catch (Exception exception) {
            fConstants.logger.info("asyncAccept-" + this.getClass().getName() + " failed on driver=" + this.getClass().getName() + " - " + exception);
            try {
                fDriver2.abortAllIO();
                fDriver2.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private void syncAccept(fDriver fDriver2, fHTTPHeader fHTTPHeader2) {
        try {
            if (!fHTTPHeader2.readHeader(fDriver2.getInputStream())) {
                this.callRawAcceptHandler(fHTTPHeader2, fDriver2);
            } else if (fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connect || !this.enable11 || fHTTPHeader2.getVersion() == HttpHeaderDefinitions.HttpVersion.version_1_0) {
                fHTTPHeader2.setVersion(HttpHeaderDefinitions.HttpVersion.version_1_0);
                fDriver2 = new fHTTP10Driver(this, fHTTPHeader2, fDriver2);
                this.release(fHTTPHeader2);
            } else if (!fDriver2.isClosed()) {
                if (fHTTPHeader2.isWebSocket() && this.enableWebSocket) {
                    if ((fDriver2 = fWebSocketDriver.createInstance(this, fHTTPHeader2, fDriver2)) != null) {
                        this.myAcceptHandler.accept(fDriver2, this);
                    }
                } else {
                    fDriver2 = new fHTTP11Driver(this, fHTTPHeader2, fDriver2, this.getInterfaceThreadPool());
                }
            }
        }
        catch (Exception exception) {
            fConstants.logger.info("syncAccept-" + this.getClass().getName() + " failed on driver=" + this.getClass().getName() + " - " + exception);
            try {
                fDriver2.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    void processRequest(fHTTPHeader fHTTPHeader2, fHTTPDriver fHTTPDriver2, InputStream inputStream) throws Exception {
        if (myDebugManager != null && myDebugManager.getConfig(fHTTPDriver2.getId()) != null) {
            fConstants.logger.error("Protocol: HTTPD: Request being processed from  " + fHTTPDriver2.getId() + " Headers : " + fHTTPHeader2.toString());
        }
        if (fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.request || fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.requestJS) {
            this.handleRequestPacket(fHTTPHeader2, fHTTPDriver2, inputStream);
        } else if (fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connect || fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connectJS) {
            this.handleConnectPacket(fHTTPHeader2, fHTTPDriver2);
        } else if (!fHTTPHeader2.isNativeNirvana() || fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.unknown || !this.enableComet && fHTTPHeader2.isJavascript()) {
            this.handlePluginRequest(fHTTPHeader2, fHTTPDriver2);
        } else {
            if (fConstants.logger.isWarningEnabled()) {
                fConstants.logger.warn("Protocol: HTTPD: Invalid protocol handshake detected. Invalid request received. Warning " + fHTTPDriver2.getId());
            }
            fHTTPDriver2.sendNotOKHeaders();
            fHTTPDriver2.close();
        }
    }

    private void handlePluginRequest(fHTTPHeader fHTTPHeader2, fHTTPDriver fHTTPDriver2) throws Exception {
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Protocol: HTTPD: Passing request to application plug-ins for " + fHTTPDriver2.getId());
        }
        if (!this.sendStatus(fHTTPHeader2, fHTTPDriver2)) {
            fHTTPDriver2.close();
        }
    }

    protected abstract void handleRequestPacket(fHTTPHeader var1, fHTTPDriver var2, InputStream var3) throws Exception;

    protected abstract void handleConnectPacket(fHTTPHeader var1, fHTTPDriver var2) throws Exception;

    @Override
    public long getZeroThreadTime() {
        return this.myServerDriver.getZeroThreadTime();
    }

    @Override
    public int getZeroThreadCount() {
        return this.myServerDriver.getZeroThreadCount();
    }

    @Override
    public int getThreadIdleCount() {
        return this.myServerDriver.getThreadIdleCount();
    }

    @Override
    public int getCurrentThreadSize() {
        return this.myServerDriver.getCurrentThreadSize();
    }

    @Override
    public long getAuthTime() {
        return this.myServerDriver.getAuthTime();
    }

    @Override
    public long getTotalConnections() {
        return this.myServerDriver.getTotalConnections();
    }

    @Override
    public long getTotalFailedConnections() {
        return this.myServerDriver.getTotalFailedConnections();
    }

    @Override
    public void setCurrentThreadSize(int n) {
        this.myServerDriver.setCurrentThreadSize(n);
    }

    @Override
    public void setAuthenticationTimeout(long l) {
        this.myServerDriver.setAuthenticationTimeout(l);
    }

    public void setStatusHandler(fStatusHandler fStatusHandler2) {
        this.myStatusHandler = fStatusHandler2;
    }

    public fStatusHandler getStatusHandler() {
        return this.myStatusHandler;
    }

    @Override
    public String getName() throws IOException {
        return this.myServerDriver.getName();
    }

    @Override
    public boolean validate(fDriver fDriver2) throws IOException {
        return true;
    }

    private boolean sendStatus(fHTTPHeader fHTTPHeader2, fHTTPDriver fHTTPDriver2) {
        if (this.myStatusHandler == null) {
            return false;
        }
        try {
            if (fHTTPDriver2 instanceof fDriver) {
                this.myStatusHandler.processRequest(fHTTPHeader2.getHashTable(), (fDriver)((Object)fHTTPDriver2));
            }
            return true;
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        this.myServerDriver.close();
        super.stop();
        super.close();
        Iterator<fHTTPInstanceDriver> iterator = this.mySessions.getDrivers();
        LinkedList<fHTTPInstanceDriver> linkedList = new LinkedList<fHTTPInstanceDriver>();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        for (fHTTPInstanceDriver fHTTPInstanceDriver2 : linkedList) {
            this.mySessions.remove(fHTTPInstanceDriver2.getKey());
            try {
                fHTTPInstanceDriver2.close();
            }
            catch (Exception exception) {}
        }
        iterator = this.myMultiplexedSessions.getDrivers();
        while (iterator.hasNext()) {
            fDriver fDriver2 = iterator.next();
            iterator.remove();
            try {
                fDriver2.close();
            }
            catch (Exception exception) {}
        }
        this.myConnectionMonitor.close();
    }

    @Override
    public fDriver performAccept() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public fHTTPHeader allocate() {
        fHTTPHeader[] fHTTPHeaderArray = this.myHeaderInfos;
        synchronized (this.myHeaderInfos) {
            fHTTPHeader fHTTPHeader2;
            int n;
            for (n = 0; n < this.myHeaderInfos.length && this.myHeaderInfos[n] == null; ++n) {
            }
            if (n == this.myHeaderInfos.length) {
                fHTTPHeader2 = new fHTTPHeader();
            } else {
                fHTTPHeader2 = this.myHeaderInfos[n];
                this.myHeaderInfos[n] = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return fHTTPHeader2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(fHTTPHeader fHTTPHeader2) {
        fHTTPHeader2.clear();
        fHTTPHeader[] fHTTPHeaderArray = this.myHeaderInfos;
        synchronized (this.myHeaderInfos) {
            for (int i = 0; i < this.myHeaderInfos.length && fHTTPHeader2 != null; ++i) {
                if (this.myHeaderInfos[i] != null) continue;
                this.myHeaderInfos[i] = fHTTPHeader2;
                fHTTPHeader2 = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void callRawAcceptHandler(fHTTPHeader fHTTPHeader2, fDriver fDriver2) throws Exception {
        byte[] byArray = fMemoryManager.getInstance().allocateBuffer(fHTTPHeader2.getEndOfBuffer());
        System.arraycopy(fHTTPHeader2.getBuffer(), 0, byArray, 0, byArray.length);
        this.release(fHTTPHeader2);
        fEventInputStream fEventInputStream2 = fStreamFactory.createInputStream(fDriver2.getInputStream());
        fEventInputStream2.rollback(byArray);
        fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fDriver2.getOutputStream());
        if (fDriver2.supportAsyncReading()) {
            fDriver2.registerListener(null);
        }
        this.myLoginCtx.login(fDriver2, fEventInputStream2, fEventOutputStream2);
        this.myAcceptHandler.accept(fDriver2, this);
    }

    class SessionTrimmer
    extends fScheduledTask {
        private final LinkedList<fHTTPDSession> myCloseQueue = new LinkedList();

        SessionTrimmer() {
        }

        @Override
        public long reSchedule() {
            return myCheckInterval;
        }

        @Override
        public String getName() {
            return "I/O HTTP session timeout manager";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            long l = fTimer.getTicks();
            Object object = fServerHTTPBaseDriver.this.myUnauthorizedSessions;
            synchronized (object) {
                Iterator<fHTTPInstanceDriver> iterator = fServerHTTPBaseDriver.this.myUnauthorizedSessions.getDrivers();
                while (iterator.hasNext()) {
                    fHTTPDSession fHTTPDSession2 = (fHTTPDSession)iterator.next();
                    if (fHTTPDSession2.getCreationTime() + myTimeOutValue >= l) continue;
                    this.myCloseQueue.add(fHTTPDSession2);
                    iterator.remove();
                }
            }
            while (this.myCloseQueue.size() != 0) {
                object = this.myCloseQueue.removeFirst();
                try {
                    if (fConstants.logger.canLog(fLogLevel.LOG)) {
                        fConstants.logger.log("Closing unauthorised HTTP connection " + ((fHTTPDSession)object).getId() + " Cookie: " + fStringByteConverter.convert(((fHTTPDSession)object).getCookieAsBytes()));
                    }
                    ((fHTTPDSession)object).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    class AsyncAcceptHelper
    extends fDriverMonitorEntry
    implements fAsyncReadListener,
    fTask {
        private fHTTPHeader myHeader;
        private InputStream myInput;
        private boolean isRaw;
        private boolean completed;
        private boolean allDone;
        private boolean isQueued;
        private boolean isRegisted;

        AsyncAcceptHelper(fDriver fDriver2, fHTTPHeader fHTTPHeader2) throws Exception {
            super(fDriver2);
            this.completed = false;
            this.allDone = false;
            fServerHTTPBaseDriver.this.myConnectionMonitor.add(this);
            this.myHeader = fHTTPHeader2;
            this.myInput = this.myDriver.getInputStream();
            this.isQueued = false;
            this.isRegisted = false;
            this.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataReady() throws IOException {
            AsyncAcceptHelper asyncAcceptHelper = this;
            synchronized (asyncAcceptHelper) {
                if (this.completed) {
                    return;
                }
                if (this.isQueued) {
                    return;
                }
                this.isQueued = true;
                fServerHTTPBaseDriver.this.myServerDriver.getInterfaceThreadPool().addTask(this);
            }
        }

        public synchronized void update() {
            if (!this.completed) {
                this.myDriver.setTimeout(fServerHTTPBaseDriver.this.getConfig().getAuthTimeOut());
                try {
                    int n = this.myInput.available();
                    if (n > 0) {
                        int n2;
                        int n3 = this.myHeader.getBuffer().length - this.myHeader.getEndOfBuffer();
                        if (n3 == 0) {
                            this.myHeader.growBuffer();
                            n3 = this.myHeader.getBuffer().length - this.myHeader.getEndOfBuffer();
                        }
                        if (n3 > n) {
                            n3 = n;
                        }
                        if ((n2 = this.myInput.read(this.myHeader.getBuffer(), this.myHeader.getEndOfBuffer(), n3)) > 0) {
                            this.myHeader.setEndOfBuffer(n2 + this.myHeader.getEndOfBuffer());
                        }
                    }
                    if (this.scanBuffer()) {
                        this.completed = true;
                        if (this.isRegisted) {
                            this.myDriver.registerListener(null);
                        }
                    }
                }
                catch (Exception exception) {
                    this.close();
                }
            }
            if (!this.completed) {
                try {
                    if (!this.isRegisted) {
                        this.isRegisted = true;
                        this.myDriver.registerListener(this, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            AsyncAcceptHelper asyncAcceptHelper = this;
            synchronized (asyncAcceptHelper) {
                if (!this.completed) {
                    this.update();
                    this.isQueued = false;
                    this.myDriver.resumeReading();
                    if (!this.completed) {
                        return;
                    }
                }
                if (this.allDone) {
                    return;
                }
                this.allDone = true;
            }
            fServerHTTPBaseDriver.this.myConnectionMonitor.remove(this);
            try {
                if (this.isRaw) {
                    fServerHTTPBaseDriver.this.callRawAcceptHandler(this.myHeader, this.myDriver);
                } else {
                    this.processHTTPRequest();
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof IOException || throwable instanceof fAuthenticationException || throwable instanceof LoginException) {
                    fConstants.logger.info(this.getClass().getName() + " failed to do Accept for driver=" + fServerHTTPBaseDriver.this.getClass().getSimpleName() + " with context=" + fServerHTTPBaseDriver.this.myLoginCtx + " - " + throwable);
                } else if (throwable instanceof fException && (throwable.getCause() instanceof IOException || throwable.getCause() instanceof fAuthenticationException)) {
                    fConstants.logger.info(this.getClass().getName() + " failed to do Accept for driver=" + fServerHTTPBaseDriver.this.getClass().getSimpleName() + " with context=" + fServerHTTPBaseDriver.this.myLoginCtx + " - " + throwable);
                } else {
                    fConstants.logger.info(throwable);
                }
                this.close();
            }
        }

        @Override
        public boolean reQueue() {
            return false;
        }

        @Override
        public void close() {
            try {
                this.myDriver.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            fServerHTTPBaseDriver.this.myConnectionMonitor.remove(this);
            this.myDriver.abortAllIO();
        }

        private void processHTTPRequest() throws Exception {
            if (this.myHeader.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connect) {
                this.myHeader.setVersion(HttpHeaderDefinitions.HttpVersion.version_1_0);
            } else if (this.myHeader.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connectJS && !this.myHeader.isCometChunking() && !this.myHeader.isLongPoll()) {
                this.myHeader.setVersion(HttpHeaderDefinitions.HttpVersion.version_1_0);
            }
            if (!fServerHTTPBaseDriver.this.enable11) {
                this.myHeader.setVersion(HttpHeaderDefinitions.HttpVersion.version_1_0);
            }
            if (this.myHeader.getVersion() == HttpHeaderDefinitions.HttpVersion.version_1_1) {
                if (this.myHeader.isWebSocket() && fServerHTTPBaseDriver.this.enableWebSocket) {
                    this.myDriver = fWebSocketDriver.createInstance(fServerHTTPBaseDriver.this, this.myHeader, this.myDriver);
                    if (this.myDriver != null) {
                        fServerHTTPBaseDriver.this.myAcceptHandler.accept(this.myDriver, fServerHTTPBaseDriver.this);
                    }
                    return;
                }
                if (!this.myDriver.isClosed()) {
                    new fHTTP11Driver(fServerHTTPBaseDriver.this, this.myHeader, this.myDriver, fServerHTTPBaseDriver.this.myServerDriver.getInterfaceThreadPool());
                }
            } else {
                new fHTTP10Driver(fServerHTTPBaseDriver.this, this.myHeader, this.myDriver);
                fServerHTTPBaseDriver.this.release(this.myHeader);
            }
        }

        private boolean scanBuffer() throws Exception {
            if (this.myHeader.checkIfNativeProtocol()) {
                this.isRaw = true;
                return true;
            }
            this.isRaw = false;
            return this.myHeader.processBufferFull();
        }
    }
}

