/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.http.fBaseHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.drivers.http.fWebSocketInputStream;
import com.pcbsys.foundation.drivers.http.fWebSocketOutputStream;
import com.pcbsys.foundation.drivers.http.fWebSocketProtocol;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.javascript.fStreamWrapper;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.Base64;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class fWebSocketDriver
extends fBaseHTTPDriver
implements fAsyncReadListener,
fWebSocketProtocol {
    private static final int sWebSocketVersion = 13;
    private static final byte[] sWebSocketHandshakeHeader = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: ".getBytes();
    private static final byte[] sLFCR = "\r\n".getBytes();
    private static final byte[] sBadOrigin = ("HTTP/1.1 403 Forbidden\r\nDate: " + new Date() + "\r\nCache-Control: no-cache\r\nNrvResp: Invalid\r\nContent-Length: 0\r\n\r\n").getBytes();
    private static final byte[] sUpgradeRequired = ("HTTP/1.1 426 Upgrade Required\r\nDate: " + new Date() + "\r\nCache-Control: no-cache\r\nNrvResp: Invalid\r\nContent-Length: 0\r\n").getBytes();
    private static final byte[] sWebSocketMagicKey = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes();

    private static String calcAcceptResponse(byte[] byArray, int n, int n2) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(byArray, n, n2 - n);
        messageDigest.update(sWebSocketMagicKey);
        return Base64.encode(messageDigest.digest());
    }

    public static fWebSocketDriver createInstance(fServerHTTPBaseDriver fServerHTTPBaseDriver2, fHTTPHeader fHTTPHeader2, fDriver fDriver2) throws Exception {
        fWebSocketDriver fWebSocketDriver2 = null;
        if (fHTTPHeader2.getWSVersion() == 13) {
            fWebSocketDriver2 = new fWebSocketDriver(fServerHTTPBaseDriver2, fHTTPHeader2, fDriver2);
        } else {
            fWebSocketDriver.versionAdvertisement(fDriver2);
        }
        return fWebSocketDriver2;
    }

    @Override
    public void sendInitOKHeaders(fHTTPHeader fHTTPHeader2) {
        try {
            this.myBase.getOutputStream().write(sWebSocketHandshakeHeader);
            this.myBase.getOutputStream().write(fWebSocketDriver.calcAcceptResponse(fHTTPHeader2.getBuffer(), fHTTPHeader2.getWSSecKeyStart(), fHTTPHeader2.getWsSecKeyEnd()).getBytes());
            this.myBase.getOutputStream().write(sLFCR);
            this.myBase.getOutputStream().write(sLFCR);
            this.myBase.getOutputStream().flush();
            fConstants.logger.info("WebSocket: Initial WebSocket request received from " + this.myBase.getId() + ", upgrade accepted (Protocol Version " + this.getWebSocketVersion() + "), waiting final application handshake");
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
            if (this.myBase == null) {
                return;
            }
            this.myBase.close();
            this.setClosed(true);
            this.myOutputStream.close();
            this.myInputStream.close();
            if (this.myListener != null) {
                this.myListener.close();
            }
        }
        catch (fException fException2) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean sendTimeOutEvent() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public void allocate() {
    }

    @Override
    public void deallocate() {
    }

    @Override
    public boolean isAllocated() {
        return false;
    }

    @Override
    public boolean supportMultipleRequests() {
        return false;
    }

    @Override
    public String getVersion() {
        return "1.1";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.createInputStream(this.myInputStream);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.createOutputStream(this.myOutputStream);
    }

    @Override
    public void setTimeout(int n) {
        this.myBase.setTimeout(n);
    }

    @Override
    public int getTimeout() {
        return this.myBase.getTimeout();
    }

    @Override
    public fSubject getSubject() {
        return this.myBase.getSubject();
    }

    @Override
    public void setSubject(fSubject fSubject2) {
        this.myBase.setSubject(fSubject2);
    }

    @Override
    public String getId() {
        return this.myBase.getId();
    }

    @Override
    public String getLocalId() {
        return this.myBase.getLocalId();
    }

    @Override
    public int getLocalPort() {
        return this.myBase.getLocalPort();
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        return this.myBase.getConnectionDetails();
    }

    @Override
    public boolean isSecure() {
        return this.myBase.isSecure();
    }

    @Override
    public void sendOKHeaders(fHTTPHeader fHTTPHeader2, boolean bl) {
    }

    @Override
    public fDriver getLowerDriver() {
        return this.myBase;
    }

    @Override
    public void sendNotOKHeaders() {
        try {
            this.myBase.getOutputStream().write(sBadOrigin);
            this.myBase.getOutputStream().flush();
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }

    @Override
    public InputStream createInputStream(InputStream inputStream) {
        if (this.myInputStream == null) {
            this.myInputStream = new fWebSocketInputStream(super.createInputStream(inputStream), this);
        }
        return this.myInputStream;
    }

    @Override
    public OutputStream createOutputStream(OutputStream outputStream) {
        if (this.myOutputStream == null) {
            this.myOutputStream = new fWebSocketOutputStream(super.createOutputStream(outputStream));
        }
        return this.myOutputStream;
    }

    @Override
    public void dataReady() throws IOException {
        try {
            ((fWebSocketInputStream)this.myInputStream).readFromUnderlyingStream();
        }
        catch (IOException iOException) {
            this.close();
        }
        if (this.myListener != null) {
            this.myListener.dataReady();
        }
    }

    @Override
    public fAsyncReadListener getListener() {
        return this.myListener;
    }

    @Override
    public void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        super.registerListener(fAsyncReadListener2);
        if (this.myInputStream.available() > 0) {
            fAsyncReadListener2.dataReady();
        }
    }

    @Override
    public void resumeReading() {
        this.myBase.resumeReading();
    }

    @Override
    public boolean supportAsyncWriting() {
        return true;
    }

    @Override
    public boolean supportAsyncReading() {
        return true;
    }

    @Override
    public void closeReceived() {
    }

    @Override
    public void pingReceived() {
    }

    @Override
    public void pongReceived() {
    }

    private int getWebSocketVersion() {
        return 13;
    }

    private static void versionAdvertisement(fDriver fDriver2) {
        try {
            fDriver2.getOutputStream().write(sUpgradeRequired);
            String string = "Sec-WebSocket-Version: 13";
            fDriver2.getOutputStream().write(string.getBytes());
            fDriver2.getOutputStream().write(sLFCR);
            fDriver2.getOutputStream().write(sLFCR);
            fDriver2.getOutputStream().flush();
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }

    private fWebSocketDriver(fServerHTTPBaseDriver fServerHTTPBaseDriver2, fHTTPHeader fHTTPHeader2, fDriver fDriver2) throws Exception {
        super(fServerHTTPBaseDriver2, fHTTPHeader2, fDriver2);
        fServerHTTPBaseDriver2.release(new fHTTPHeader());
        this.myOutputStream = this.createOutputStream(this.myBase.getOutputStream());
        this.myInputStream = this.createInputStream(this.myBase.getInputStream());
        this.myType = fDriver2.isSecure() ? "wss" : "ws";
        int n = fHTTPHeader2.getOriginStartIndex();
        if (n > -1 && !this.hasMatchingOrigin(fStringByteConverter.convert(fHTTPHeader2.getBuffer(), n, fHTTPHeader2.getOriginEndIndex() - n), null)) {
            this.sendNotOKHeaders();
            this.close();
            return;
        }
        this.sendInitOKHeaders(fHTTPHeader2);
        this.myOutputStream = new fStreamWrapper(this.myOutputStream);
        this.myBase.registerListener(this);
    }
}

