/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.http.fWebSocketProtocol;
import com.pcbsys.foundation.fConstants;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class fWebSocketInputStream
extends InputStream {
    private static final byte OP_CODE_CLOSE_VALUE = 8;
    private static final byte OP_CODE_PING_VALUE = 9;
    private static final byte OP_CODE_PONG_VALUE = 10;
    private static final byte PAYLOAD_LENGTH_MASK = 127;
    private final InputStream myInputStream;
    private final fWebSocketProtocol myProtocolHandler;
    private final byte[] myMaskingKey;
    private int myMaskingKeyIdx;
    private long myAvailable;
    private boolean isClosed = false;
    private List<byte[]> frameBuffer = null;
    private int readFrameIndex = 0;
    private int readFramePos = 0;
    private int maxBufferSize;

    public fWebSocketInputStream(InputStream inputStream, fWebSocketProtocol fWebSocketProtocol2) {
        this.myInputStream = inputStream;
        this.myAvailable = 0L;
        this.myProtocolHandler = fWebSocketProtocol2;
        this.myMaskingKey = new byte[4];
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.myAvailable > 0L) {
            --this.myAvailable;
            if (this.frameBuffer != null) {
                return this.readFrameBuffer();
            }
            int n = this.myInputStream.read();
            if (n != -1) {
                n = n & 0xFF ^ this.myMaskingKey[this.myMaskingKeyIdx % 4];
                ++this.myMaskingKeyIdx;
            }
            return n;
        }
        return 0;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.myAvailable == 0L) {
            this.readFromUnderlyingStream();
            if (this.myAvailable == 0L) {
                return 0;
            }
        }
        int n3 = 0;
        n3 = this.frameBuffer != null ? this.readFrameBuffer(byArray, n, n2) : this.readInternalStream(byArray, n, n2);
        this.myAvailable -= (long)n3;
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        super.close();
    }

    protected void readWebSocketHeader() throws IOException {
        int n = this.myInputStream.read();
        if (n == -1) {
            throw new IOException("Stream has been closed");
        }
        boolean bl = (n & 0x80) == 128;
        int n2 = n & 0xF;
        switch (n2) {
            case 9: {
                this.myProtocolHandler.pingReceived();
                this.handleInterleavedControlFrame(n2);
                return;
            }
            case 10: {
                this.myProtocolHandler.pongReceived();
                this.handleInterleavedControlFrame(n2);
                return;
            }
            case 8: {
                this.myProtocolHandler.closeReceived();
                this.handleInterleavedControlFrame(n2);
                return;
            }
        }
        int n3 = this.myInputStream.read();
        boolean bl2 = (n3 & 0x80) > 0;
        long l = n3 & 0x7F;
        if (l == 126L) {
            l = (this.myInputStream.read() & 0xFF) << 8;
            l += (long)(this.myInputStream.read() & 0xFF);
        } else if (l == 127L) {
            l = ((long)this.myInputStream.read() & 0xFFL) << 56;
            l += ((long)this.myInputStream.read() & 0xFFL) << 48;
            l += ((long)this.myInputStream.read() & 0xFFL) << 40;
            l += ((long)this.myInputStream.read() & 0xFFL) << 32;
            l += ((long)this.myInputStream.read() & 0xFFL) << 24;
            l += ((long)this.myInputStream.read() & 0xFFL) << 16;
            l += ((long)this.myInputStream.read() & 0xFFL) << 8;
            l += (long)this.myInputStream.read() & 0xFFL;
        }
        this.myAvailable += l;
        if (this.maxBufferSize > 0 && this.myAvailable > (long)this.maxBufferSize) {
            fConstants.logger.error("IO : Input exceeded input buffer size");
            throw new IOException("IO : Input exceeded input buffer size");
        }
        if (l > Integer.MAX_VALUE) {
            throw new IOException("IO : Cannot handle event of size " + l + " bytes.");
        }
        int n4 = (int)l;
        if (bl2) {
            this.myInputStream.read(this.myMaskingKey);
        } else {
            this.myMaskingKey[0] = 0;
            this.myMaskingKey[1] = 0;
            this.myMaskingKey[2] = 0;
            this.myMaskingKey[3] = 0;
        }
        this.myMaskingKeyIdx = 0;
        if (this.isClosed) {
            this.myAvailable = 0L;
        }
        if (bl) {
            if (n2 > 0) {
                if (fConnectionDetails.sEnableConnectionDebug) {
                    fDriver.log("WebSocketInput stream " + this.hashCode() + " received single-frame event, size: " + l);
                }
            } else {
                if (fConnectionDetails.sEnableConnectionDebug) {
                    fDriver.log("WebSocketInput stream " + this.hashCode() + " received final frame index: " + this.frameBuffer.size() + ", size: " + l);
                }
                this.readFrameToBuffer(n4);
            }
        } else {
            if (n2 > 0) {
                this.frameBuffer = new ArrayList<byte[]>();
            }
            if (fConnectionDetails.sEnableConnectionDebug) {
                fDriver.log("WebSocketInput stream " + this.hashCode() + " received fragmented frame index: " + this.frameBuffer.size() + ", size: " + l);
            }
            this.readFrameToBuffer(n4);
            this.readWebSocketHeader();
        }
    }

    public synchronized void readFromUnderlyingStream() throws IOException {
        if (this.myAvailable == 0L && this.myInputStream.available() > 0) {
            this.readWebSocketHeader();
            this.notify();
        }
    }

    @Override
    public synchronized int available() throws IOException {
        this.readFromUnderlyingStream();
        return (int)this.myAvailable;
    }

    private void handleInterleavedControlFrame(int n) throws IOException {
        if (this.frameBuffer != null || this.frameBuffer.size() > 0) {
            if (fConnectionDetails.sEnableConnectionDebug) {
                fDriver.log("WebSocketInput stream " + this.hashCode() + " received a control frame with opcode " + n + " in between a multi-fragment event.");
            }
            this.readWebSocketHeader();
        }
    }

    private void readFrameToBuffer(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readInternalStream(byArray, 0, n);
        this.frameBuffer.add(byArray);
    }

    private int readInternalStream(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 != n2; n3 += n4) {
            n4 = this.myInputStream.read(byArray, n + n3, n2 - n3);
            if (n4 != -1) continue;
            return -1;
        }
        for (n4 = 0; n4 < n2 - 3; n4 += 4) {
            byArray[n + n4] = (byte)(byArray[n + n4] ^ this.myMaskingKey[0]);
            byArray[n + n4 + 1] = (byte)(byArray[n + n4 + 1] ^ this.myMaskingKey[1]);
            byArray[n + n4 + 2] = (byte)(byArray[n + n4 + 2] ^ this.myMaskingKey[2]);
            byArray[n + n4 + 3] = (byte)(byArray[n + n4 + 3] ^ this.myMaskingKey[3]);
            this.myMaskingKeyIdx += 4;
        }
        switch (n2 - n4) {
            case 3: {
                byArray[n + n4 + 2] = (byte)(byArray[n + n4 + 2] ^ this.myMaskingKey[2]);
            }
            case 2: {
                byArray[n + n4 + 1] = (byte)(byArray[n + n4 + 1] ^ this.myMaskingKey[1]);
            }
            case 1: {
                byArray[n + n4] = (byte)(byArray[n + n4] ^ this.myMaskingKey[0]);
            }
        }
        return n3;
    }

    private int readFrameBuffer(byte[] byArray, int n, int n2) throws EOFException {
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.frameBuffer == null || this.frameBuffer.size() == 0) {
            throw new EOFException("End of frame buffer reached.");
        }
        byte[] byArray2 = this.frameBuffer.get(this.readFrameIndex);
        int n3 = byArray2.length - this.readFramePos;
        int n4 = Math.min(n2, n3);
        System.arraycopy(byArray2, this.readFramePos, byArray, n, n4);
        if (n2 < n3) {
            this.readFramePos += n2;
            return n4;
        }
        ++this.readFrameIndex;
        this.readFramePos = 0;
        if (this.readFrameIndex == this.frameBuffer.size()) {
            if (n2 > n3) {
                this.readFrameIndex = 0;
                this.frameBuffer = null;
                throw new EOFException("End of frame buffer reached.");
            }
            this.readFrameIndex = 0;
            this.frameBuffer = null;
            return n4;
        }
        return n4 + this.readFrameBuffer(byArray, n + n4, n2 - n4);
    }

    private int readFrameBuffer() throws EOFException {
        if (this.frameBuffer == null || this.frameBuffer.size() == 0) {
            throw new EOFException("End of frame buffer reached.");
        }
        byte[] byArray = this.frameBuffer.get(this.readFrameIndex);
        byte by = byArray[this.readFramePos];
        if (++this.readFramePos == byArray.length) {
            this.readFramePos = 0;
            if (++this.readFrameIndex == this.frameBuffer.size()) {
                this.readFrameIndex = 0;
                this.frameBuffer = null;
                throw new EOFException("End of frame buffer reached.");
            }
        }
        return by;
    }

    public void setMaxBufferSize(int n) {
        this.maxBufferSize = n;
    }
}

