/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class fWebSocketOutputStream
extends OutputStream {
    protected static final byte sFullFrameOpCodeByte = -127;
    protected final OutputStream myOutputStream;
    protected final byte[] headerBuffer;
    private final ByteArrayOutputStream buffer;
    private boolean isClosed = false;

    public fWebSocketOutputStream(OutputStream outputStream) {
        this.myOutputStream = outputStream;
        this.buffer = new ByteArrayOutputStream(1024);
        this.headerBuffer = new byte[10];
    }

    public OutputStream getBaseStream() {
        return this.myOutputStream;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.myOutputStream.close();
        this.buffer.close();
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.buffer.write(byArray, n, n2);
    }

    protected static int constructHeader(byte[] byArray, long l) {
        int n;
        if (l < 126L) {
            byArray[0] = -127;
            byArray[1] = (byte)l;
            n = 2;
        } else if (l < 65536L) {
            byArray[0] = -127;
            byArray[1] = 126;
            byArray[2] = (byte)(l >>> 8);
            byArray[3] = (byte)l;
            n = 4;
        } else {
            byArray[0] = -127;
            byArray[1] = 127;
            byArray[2] = (byte)(l >>> 56);
            byArray[3] = (byte)(l >>> 48);
            byArray[4] = (byte)(l >>> 40);
            byArray[5] = (byte)(l >>> 32);
            byArray[6] = (byte)(l >>> 24);
            byArray[7] = (byte)(l >>> 16);
            byArray[8] = (byte)(l >>> 8);
            byArray[9] = (byte)l;
            n = 10;
        }
        return n;
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer.size() == 0) {
            return;
        }
        int n = fWebSocketOutputStream.constructHeader(this.headerBuffer, this.buffer.size());
        this.myOutputStream.write(this.headerBuffer, 0, n);
        this.myOutputStream.write(this.buffer.toByteArray());
        this.myOutputStream.flush();
        this.buffer.reset();
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

