/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.URLHandler;

import com.pcbsys.foundation.drivers.jdk.URLHandler.fDefaultURLHandler;
import com.pcbsys.foundation.drivers.jdk.URLHandler.fHTTPResponse;
import com.pcbsys.foundation.vm.VMHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class fDefaultMSURLHandler
extends fDefaultURLHandler {
    public fDefaultMSURLHandler(URL uRL, SSLSocketFactory sSLSocketFactory) throws IOException {
        this.con = uRL.openConnection();
        if (sSLSocketFactory != null) {
            if (this.con instanceof HttpsURLConnection) {
                ((HttpsURLConnection)this.con).setSSLSocketFactory(sSLSocketFactory);
            } else {
                throw new IOException("Unable to honour setting the defined SSL socket factory");
            }
        }
    }

    @Override
    public void startFlush() {
    }

    @Override
    public void endFlush() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.myIs == null) {
            this.myIs = new fURLInputStream(this.con.getInputStream());
        }
        return this.myIs;
    }

    @Override
    public void connect() throws IOException {
        this.con.connect();
    }

    @Override
    public fHTTPResponse isResponseOK() throws IOException {
        fHTTPResponse fHTTPResponse2 = null;
        InputStream inputStream = this.con.getInputStream();
        String string = this.con.getHeaderField(0);
        fHTTPResponse2 = new fHTTPResponse(string);
        inputStream.close();
        return fHTTPResponse2;
    }

    @Override
    public void abort() {
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void setConnectTimeOut(int n) {
        this.con.setConnectTimeout(n);
    }

    public class fURLInputStream
    extends InputStream
    implements Runnable {
        private InputStream myBaseInputStream;
        private PipedOutputStream mySink;
        private PipedInputStream myIs;
        private boolean canRun = true;
        Thread myThread;

        public fURLInputStream(InputStream inputStream) throws IOException {
            this.myBaseInputStream = inputStream;
            this.mySink = new PipedOutputStream();
            this.myIs = new PipedInputStream(this.mySink);
            this.myThread = VMHelper.allocateThread(this);
            this.myThread.setDaemon(true);
            this.myThread.start();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.myIs.read(byArray, n, n2);
        }

        @Override
        public int read() throws IOException {
            return this.myIs.read();
        }

        @Override
        public void close() throws IOException {
            if (this.canRun) {
                this.canRun = false;
                this.mySink.close();
                this.myIs.close();
                if (this.myThread.isAlive() && this.myThread != Thread.currentThread()) {
                    this.myThread.setName("Awaiting close from read");
                    this.myThread.interrupt();
                }
            }
            fDefaultMSURLHandler.this.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] byArray = new byte[1024];
            int n = 0;
            try {
                while (this.canRun) {
                    try {
                        int n2 = 0;
                        n = 0;
                        while (n2 < 4 && n < 2 && this.canRun) {
                            n2 = this.myBaseInputStream.available();
                            if (n2 >= 4) continue;
                            ++n;
                            Thread.sleep(100L);
                        }
                        if (n2 > byArray.length) {
                            n2 = byArray.length;
                        }
                        if (!this.canRun) continue;
                        int n3 = this.myBaseInputStream.read(byArray, 0, n2);
                        if (n3 != -1) {
                            this.mySink.write(byArray, 0, n3);
                            this.mySink.flush();
                            continue;
                        }
                        this.close();
                    }
                    catch (Exception exception) {
                        this.canRun = false;
                        try {
                            this.close();
                            this.myBaseInputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                try {
                    this.close();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

