/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk;

import com.pcbsys.foundation.drivers.jdk.fFileSupport;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class fDefaultFileSupport
implements fFileSupport {
    protected static final boolean sDebug = fEnvironment.isDebugEnabled("FileAccess");

    @Override
    public void renameFile(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File to rename must not be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File to rename must not be a directory");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("File to rename to must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source file to rename does not exist: " + file.getAbsolutePath());
        }
        if (file2.exists()) {
            if (bl) {
                if (sDebug) {
                    fDefaultFileSupport.log("New file " + file2 + " exist, attempting to delete");
                }
                if (!file2.delete()) {
                    throw new IOException("Failed to rename file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + ". New file " + file2.getAbsolutePath() + " exists and could not be deleted");
                }
            } else {
                throw new IOException("Failed to rename file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + ". New file " + file2.getAbsolutePath() + " exists and replaceExisting is false");
            }
        }
        if (!file.renameTo(file2)) {
            throw new IOException("Failed to rename file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
        }
    }

    protected static void log(String string) {
        fConstants.logger.log("FileAccess>" + string);
    }

    protected static void log(String string, Throwable throwable) {
        fConstants.logger.log("FileAccess>" + string, throwable);
    }
}

