/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk;

import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.jdk.fSSLContextFactory;
import com.pcbsys.foundation.fConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class fDefaultSSLContextFactory
implements fSSLContextFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getContext(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        String string = fBaseSSLConfig2.getKeyStore();
        String string2 = fBaseSSLConfig2.getKeyStorePassword();
        String string3 = fBaseSSLConfig2.getAlias();
        String string4 = fBaseSSLConfig2.getPrivateKeyPassword();
        String string5 = fBaseSSLConfig2.getTrustStore();
        String string6 = fBaseSSLConfig2.getTrustStorePassword();
        SecureRandom secureRandom = this.loadSecureRandom(fBaseSSLConfig2.getRandomAlgorithm(), fBaseSSLConfig2.getRandomProvider());
        if (string == null) {
            throw new IOException("No Keystore file supplied, unable to support SSL");
        }
        if (string5 == null) {
            throw new IOException("No Truststore file supplied, unable to support SSL");
        }
        if (string2 == null) {
            throw new IOException("No Keystore password supplied, unable to support SSL");
        }
        String string7 = fBaseSSLConfig2.getProvider();
        SSLContext sSLContext = null;
        try {
            if (string7 != null) {
                try {
                    sSLContext = SSLContext.getInstance("TLS", string7);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    fConstants.logger.fatal("No such provider found " + string7 + " using JVM default provider");
                    fConstants.logger.fatal(noSuchProviderException);
                    sSLContext = SSLContext.getInstance("TLS");
                }
            } else {
                sSLContext = SSLContext.getInstance("TLS");
            }
        }
        catch (RuntimeException runtimeException) {
            fConstants.logger.fatal("No support for TLS found during initial SSL Context load. Unable to support SSL");
            fConstants.logger.fatal(fDefaultSSLContextFactory.getMessage(runtimeException));
            throw new IOException("No support for TLS found during initial SSL Context load: " + fDefaultSSLContextFactory.getMessage(runtimeException));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not found during initial SSL Context load. Unable to support SSL");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found during initial SSL Context load : " + fDefaultSSLContextFactory.getMessage(noSuchAlgorithmException));
        }
        KeyManagerFactory keyManagerFactory = null;
        KeyStore keyStore = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyStore = KeyStore.getInstance("JKS");
            object3 = new FileInputStream(string);
            try {
                keyStore.load((InputStream)object3, string2.toCharArray());
            }
            finally {
                ((FileInputStream)object3).close();
            }
            if (keyStore.size() > 1) {
                object2 = keyStore.aliases();
                if (string3 != null && string3.length() > 0) {
                    while (object2.hasMoreElements()) {
                        object = object2.nextElement();
                        if (((String)object).equalsIgnoreCase(string3)) continue;
                        keyStore.deleteEntry((String)object);
                    }
                }
            } else if (fConstants.logger.isDebugEnabled()) {
                object2 = keyStore.aliases();
                while (object2.hasMoreElements()) {
                    fConstants.logger.debug("KeyStore has only one certificate :" + object2.nextElement().toString());
                }
            }
            if (keyStore.size() == 0) {
                fConstants.logger.debug("No certificates found in keystore : " + string + ", Alias : " + string3);
                throw new IOException("No certificates found in keystore : " + string + ", Alias : " + string3);
            }
            if (string4 != null) {
                keyManagerFactory.init(keyStore, string4.toCharArray());
            } else {
                keyManagerFactory.init(keyStore, string2.toCharArray());
            }
        }
        catch (IOException iOException) {
            fConstants.logger.fatal("IOException raised while loading private keystore <" + string + "> : " + fDefaultSSLContextFactory.getMessage(iOException));
            fConstants.logger.fatal(iOException);
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not raised during private keystore load <" + string + ">");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found : " + fDefaultSSLContextFactory.getMessage(noSuchAlgorithmException));
        }
        catch (CertificateException certificateException) {
            fConstants.logger.fatal("Certificate error raised during private keystore load <" + string + ">");
            fConstants.logger.fatal(certificateException);
            throw new IOException("Certificate Exception : " + fDefaultSSLContextFactory.getMessage(certificateException));
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            fConstants.logger.fatal("Unrecoverable Key Exception raised during private keystore load <" + string + ">");
            fConstants.logger.fatal(unrecoverableKeyException);
            throw new IOException("Unrecoverable Key Exception : " + fDefaultSSLContextFactory.getMessage(unrecoverableKeyException));
        }
        catch (KeyStoreException keyStoreException) {
            fConstants.logger.fatal("KeyStore Exception raised during private keystore load <" + string + ">");
            fConstants.logger.fatal(keyStoreException);
            throw new IOException("Keystore Exception : " + fDefaultSSLContextFactory.getMessage(keyStoreException));
        }
        object3 = null;
        object2 = null;
        object = null;
        try {
            object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            object3 = KeyStore.getInstance("JKS");
            object = new FileInputStream(string5);
            if (string6 != null) {
                ((KeyStore)object3).load((InputStream)object, string6.toCharArray());
            } else {
                ((KeyStore)object3).load((InputStream)object, string2.toCharArray());
            }
            ((FileInputStream)object).close();
            ((TrustManagerFactory)object2).init((KeyStore)object3);
            if (fConstants.logger.isDebugEnabled()) {
                String string8;
                Enumeration<String> enumeration = ((KeyStore)object3).aliases();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    string8 = enumeration.nextElement();
                    fConstants.logger.log("Loaded Trusted CA Certificate " + n + " " + string8);
                    ++n;
                }
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    string8 = enumeration.nextElement();
                    fConstants.logger.log("Loaded Certificate " + string8);
                }
            }
            sSLContext.init(keyManagerFactory.getKeyManagers(), ((TrustManagerFactory)object2).getTrustManagers(), secureRandom);
        }
        catch (IOException iOException) {
            fConstants.logger.fatal("IOException raised loading truststore keystore <" + string5 + ">");
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not raised during truststore keystore load <" + string5 + ">");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found : " + fDefaultSSLContextFactory.getMessage(noSuchAlgorithmException));
        }
        catch (CertificateException certificateException) {
            fConstants.logger.fatal("Certificate error raised during truststore keystore load <" + string5 + ">");
            fConstants.logger.fatal(certificateException);
            throw new IOException("Certificate Exception : " + fDefaultSSLContextFactory.getMessage(certificateException));
        }
        catch (KeyStoreException keyStoreException) {
            fConstants.logger.fatal("KeyStore Exception raised during truststore keystore load <" + string5 + ">");
            fConstants.logger.fatal(keyStoreException);
            throw new IOException("Keystore Exception : " + fDefaultSSLContextFactory.getMessage(keyStoreException));
        }
        catch (KeyManagementException keyManagementException) {
            fConstants.logger.fatal("KeyManagement Exception raised during truststore keystore load <" + string5 + ">");
            fConstants.logger.fatal(keyManagementException);
            throw new IOException("KeyManagement Exception : " + fDefaultSSLContextFactory.getMessage(keyManagementException));
        }
        finally {
            if (object != null) {
                ((FileInputStream)object).close();
                object = null;
            }
        }
        return sSLContext;
    }

    @Override
    public SecureRandom loadSecureRandom(String string, String string2) {
        SecureRandom secureRandom;
        block5: {
            secureRandom = null;
            if (string != null && string.length() > 1) {
                try {
                    if (string2 != null) {
                        secureRandom = SecureRandom.getInstance(string, string2);
                        fConstants.logger.debug("Using secure random generator algoritm : " + string + " provided by " + string2);
                        break block5;
                    }
                    secureRandom = SecureRandom.getInstance(string);
                    fConstants.logger.debug("Using secure random generator algoritm : " + string);
                }
                catch (Exception exception) {
                    fConstants.logger.log("Unable to load secure random generator algoritm : " + string + " using default");
                }
            } else {
                fConstants.logger.debug("Using default SecureRandom generator");
            }
        }
        return secureRandom;
    }

    private static String getMessage(Exception exception) {
        if (exception != null) {
            if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                return exception.getMessage();
            }
            return exception.getClass().toString();
        }
        return "Unknown exception raised, is Null";
    }
}

