/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk;

import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.fDriverConstants;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.jdk.URLHandler.fDefaultHandlerFactory;
import com.pcbsys.foundation.drivers.jdk.URLHandler.fURL;
import com.pcbsys.foundation.drivers.jdk.URLHandler.fURLHandler;
import com.pcbsys.foundation.drivers.jdk.URLHandler.fURLHandlerFactory;
import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import com.pcbsys.foundation.drivers.jdk.fCertGenerator;
import com.pcbsys.foundation.drivers.jdk.fDefaultBufferManager;
import com.pcbsys.foundation.drivers.jdk.fDefaultFileSupport;
import com.pcbsys.foundation.drivers.jdk.fDefaultSSLContextFactory;
import com.pcbsys.foundation.drivers.jdk.fDefaultSocketHelper;
import com.pcbsys.foundation.drivers.jdk.fDefaultThreadWait;
import com.pcbsys.foundation.drivers.jdk.fFileSupport;
import com.pcbsys.foundation.drivers.jdk.fHTTPSettingsFactory;
import com.pcbsys.foundation.drivers.jdk.fInitialSetup;
import com.pcbsys.foundation.drivers.jdk.fJDKHelperBase;
import com.pcbsys.foundation.drivers.jdk.fProxyInfo;
import com.pcbsys.foundation.drivers.jdk.fSSLContextFactory;
import com.pcbsys.foundation.drivers.jdk.fSocketHelperInt;
import com.pcbsys.foundation.drivers.jdk.fThreadWait;
import com.pcbsys.foundation.drivers.proxy.fProxyConnectFactory;
import com.pcbsys.foundation.fConstants;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;

public class fJDKHelper
extends fJDKHelperBase {
    public static long sNanoMultiplier = 1000000L;
    private static fURLHandlerFactory myURLHandlerFactory = new fDefaultHandlerFactory();
    private static fSocketHelperInt mySocketHelper = new fDefaultSocketHelper();
    private static fHTTPSettingsFactory myFactory;
    private static fSSLContextFactory mySSLFactory;
    private static boolean hasDoneInit;
    private static fBufferManagement myBufferManagement;
    private static fThreadWait myThreadWait;
    private static fFileSupport myFileSupport;

    public static fThreadWait getThreadWaiter() {
        return myThreadWait;
    }

    public static void park(long l) {
        myThreadWait.park(l);
    }

    public static fURLHandler getURLHandler(URL uRL, SSLSocketFactory sSLSocketFactory) throws IOException {
        try {
            return myURLHandlerFactory.getHandler(new fURL(uRL), sSLSocketFactory);
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (!(myURLHandlerFactory instanceof fDefaultHandlerFactory)) {
                myURLHandlerFactory = new fDefaultHandlerFactory();
                return myURLHandlerFactory.getHandler(new fURL(uRL), sSLSocketFactory);
            }
            fConstants.logger.fatal(throwable);
            throw new IOException("Unable to create URL handler classes");
        }
    }

    public static fCertGenerator getCertGenerator() {
        String string = fJDKHelper.getVersion();
        if (string == null) {
            string = "v1_5";
        }
        String string2 = null;
        try {
            string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fCertGeneratorImpl";
            Class<?> clazz = Class.forName(string2);
            if (clazz != null) {
                Object obj = clazz.newInstance();
                if (obj instanceof fCertGenerator) {
                    try {
                        fConstants.logger.info("Loading certificate generator helper for " + string);
                        return (fCertGenerator)obj;
                    }
                    catch (Throwable throwable) {
                        fConstants.logger.info("Unable to load certificate helper for JDK " + string + ", Exception follows ");
                        fConstants.logger.info(throwable);
                    }
                }
            } else {
                fConstants.logger.log("Unable to locate Environment Helper for JDK version " + string);
            }
        }
        catch (Exception exception) {
            fConstants.logger.error("Error while loading and instantiating class " + string2);
            fConstants.logger.error(exception);
        }
        return null;
    }

    public static boolean setupEnvironment() {
        return true;
    }

    public static boolean setupEnvironmentInternal() {
        String string = fJDKHelper.getVersion();
        try {
            fJDKHelper.loadURLHelper(string);
        }
        catch (Throwable throwable) {
            fConstants.logger.info("Unable to locate Environment Helper for JDK version " + string + " exception follows");
            fConstants.logger.info(throwable);
        }
        try {
            fJDKHelper.loadURLFactory(string);
        }
        catch (Throwable throwable) {
            fConstants.logger.info("Unable to locate URL Handler for JDK version " + string + " exception follows");
            fConstants.logger.info(throwable);
        }
        try {
            fJDKHelper.loadSSLContextFactory(string);
        }
        catch (Throwable throwable) {
            fConstants.logger.info("Unable to locate SSL Context Handler for JDK version " + string + " exception follows");
            fConstants.logger.info(throwable);
        }
        try {
            fJDKHelper.loadSocketHelper(string);
        }
        catch (Throwable throwable) {
            fConstants.logger.info("Unable to locate Socket Helper for JDK version " + string + " exception follows");
            fConstants.logger.info(throwable);
        }
        try {
            fJDKHelper.loadDelayObject(string);
        }
        catch (Throwable throwable) {
            fConstants.logger.info("Unable to locate Buffer Management Helper for JDK version " + string + " exception follows");
            fConstants.logger.info(throwable);
        }
        return true;
    }

    private static void loadURLHelper(String string) throws Exception {
        if (string == null) {
            return;
        }
        String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fURLHelper";
        Class<?> clazz = Class.forName(string2);
        if (clazz != null) {
            Object obj = clazz.newInstance();
            if (obj instanceof fInitialSetup) {
                try {
                    fConstants.logger.info("Loading and executing JVM specific initialisation code for " + string);
                    ((fInitialSetup)obj).setupEnvironment();
                    fConstants.logger.info("Completed JVM specific initialisation code for " + string);
                }
                catch (Throwable throwable) {
                    fConstants.logger.info("Unable to set JDK Environment parameters for JDK " + string + ", Exception follows ");
                    fConstants.logger.info(throwable);
                }
            }
        } else {
            fConstants.logger.log("Unable to locate Environment Helper for JDK version " + string);
        }
    }

    private static void loadSSLContextFactory(String string) throws Exception {
        Class<?> clazz;
        if (string == null) {
            mySSLFactory = new fDefaultSSLContextFactory();
        }
        String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fSSLContext";
        if (fDriverConstants.sUseNSSFIPS) {
            string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fNSSContext";
        }
        if (fDriverConstants.sUseNSSCrypto) {
            string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fNSSSSLContext";
        }
        if ((clazz = Class.forName(string2)) != null) {
            Object obj = clazz.newInstance();
            mySSLFactory = (fSSLContextFactory)obj;
        } else {
            mySSLFactory = new fDefaultSSLContextFactory();
        }
    }

    private static void loadDelayObject(String string) throws Exception {
        Object obj;
        String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fThreadWaitImpl";
        Class<?> clazz = Class.forName(string2);
        if (clazz != null && (obj = clazz.newInstance()) instanceof fThreadWait) {
            myThreadWait = (fThreadWait)obj;
        }
    }

    private static void loadBufferManager(String string) throws Exception {
        String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fBufferManager";
        Class<?> clazz = Class.forName(string2);
        if (clazz != null) {
            Object obj = clazz.newInstance();
            myBufferManagement = (fBufferManagement)obj;
        }
    }

    private static fBufferManagement loadNewBufferManager(String string) throws Exception {
        String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fBufferManager";
        Class<?> clazz = Class.forName(string2);
        if (clazz != null) {
            Object obj = clazz.newInstance();
            return (fBufferManagement)obj;
        }
        return null;
    }

    private static void loadSocketHelper(String string) throws Exception {
        String string2;
        Class<?> clazz;
        if (string != null && (clazz = Class.forName(string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fSocketHelper")) != null) {
            Object obj = clazz.newInstance();
            mySocketHelper = (fSocketHelperInt)obj;
        }
    }

    private static void loadURLFactory(String string) throws Exception {
        if (string == null) {
            return;
        }
        String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fURLHandlerFactory";
        Class<?> clazz = Class.forName(string2);
        if (clazz != null) {
            Object obj = clazz.newInstance();
            if (obj instanceof fURLHandlerFactory) {
                myURLHandlerFactory = (fURLHandlerFactory)obj;
            }
        } else {
            fConstants.logger.info("Unable to locate URL Handler code for JDK version " + string + " Using generic default");
        }
    }

    private static void loadFileSupport(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fFileSupportImpl";
        Class<?> clazz = Class.forName(string2);
        if (clazz != null) {
            Object obj = clazz.newInstance();
            myFileSupport = (fFileSupport)obj;
        }
    }

    public static fBufferManagement getBufferManagement() {
        if (myBufferManagement instanceof fDefaultBufferManager) {
            String string = fJDKHelper.getVersion();
            try {
                fJDKHelper.loadBufferManager(string);
            }
            catch (Throwable throwable) {
                fConstants.logger.info("Unable to locate Buffer Management Helper for JDK version " + string + " exception follows");
                fConstants.logger.info(throwable);
            }
        }
        return myBufferManagement;
    }

    public static fFileSupport getFileSupport() {
        if (myFileSupport instanceof fDefaultFileSupport) {
            String string = fJDKHelper.getVersion();
            try {
                fJDKHelper.loadFileSupport(string);
            }
            catch (Throwable throwable) {
                fConstants.logger.info("Unable to locate File Support Helper for JDK version " + string + " exception follows");
                fConstants.logger.info(throwable);
            }
        }
        return myFileSupport;
    }

    public static fBufferManagement getNewBufferManagement() {
        String string = fJDKHelper.getVersion();
        try {
            fBufferManagement fBufferManagement2 = fJDKHelper.loadNewBufferManager(string);
            if (fBufferManagement2 != null) {
                return fBufferManagement2;
            }
        }
        catch (Throwable throwable) {
            fConstants.logger.info("Unable to locate Buffer Management Helper for JDK version " + string + " exception follows");
            fConstants.logger.info(throwable);
        }
        return fJDKHelper.getBufferManagement();
    }

    public static void setupSocket(Socket socket) throws IOException {
        mySocketHelper.setupSocket(socket);
    }

    public static void setupSocket(Socket socket, int n, int n2) throws IOException {
        mySocketHelper.setupSocket(socket, n, n2);
    }

    public static fServerDriver getServerDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        return mySocketHelper.getServerDriver(fBaseDriverConfig2, fAcceptHandler2, string);
    }

    public static fServerDriver getSSLServerDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        return mySocketHelper.getSSLServerDriver(fBaseDriverConfig2, fAcceptHandler2, string);
    }

    public static void setupURLTimeouts(HttpURLConnection httpURLConnection, int n) {
        if (myFactory == null && !hasDoneInit) {
            fJDKHelper.loadFactory();
        }
        if (myFactory != null) {
            try {
                myFactory.setParameters(httpURLConnection, n);
            }
            catch (Throwable throwable) {
                fConstants.logger.info("Unable to set URL Parameters, Exception follows ");
                fConstants.logger.info(throwable);
            }
        }
    }

    public static fHTTPSettingsFactory getHTTPFactory() {
        if (myFactory == null && !hasDoneInit) {
            fJDKHelper.loadFactory();
        }
        return myFactory;
    }

    protected static void loadFactory() {
        hasDoneInit = true;
        String string = fJDKHelper.getVersion();
        try {
            if (string != null) {
                String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fURLHelper";
                Class<?> clazz = Class.forName(string2);
                if (clazz != null) {
                    Object obj = clazz.newInstance();
                    if (obj instanceof fHTTPSettingsFactory) {
                        fConstants.logger.info("Loaded JVM specific network helper code for " + string);
                        myFactory = (fHTTPSettingsFactory)obj;
                    }
                } else {
                    fConstants.logger.info("Unable to locate URL Helper for JDK version " + string);
                }
            }
        }
        catch (Throwable throwable) {
            fConstants.logger.info("Unable to locate URL Helper for JDK version " + string + " using generic default");
        }
    }

    public static Socket getProxySocket(fProxyInfo fProxyInfo2, URL uRL) throws IOException {
        return fProxyConnectFactory.getProxySocket(fProxyInfo2, uRL);
    }

    public static fSSLContextFactory getSSLContextFactory() {
        return mySSLFactory;
    }

    public static Socket createSocket(String string, int n) throws IOException {
        return mySocketHelper.createSocket(string, n);
    }

    static {
        hasDoneInit = false;
        myBufferManagement = new fDefaultBufferManager();
        myThreadWait = new fDefaultThreadWait();
        myFileSupport = new fDefaultFileSupport();
        fJDKHelper.setupEnvironmentInternal();
    }
}

