/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk;

import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.jdk.fUnSafe;
import com.pcbsys.foundation.utils.fSystemConfiguration;

public class fJDKHelperBase {
    public static final String sIBMIdentifier = "ibm";
    private static String[] sSupported = new String[]{"1.5", "1.6", "1.7", "1.8", "1.9", "ibm"};
    private static final String sDefaultVersion = "1.7";
    protected static fUnSafe myUnSafe;

    private static void setup() {
        String string = fJDKHelperBase.getVersion();
        try {
            fJDKHelperBase.loadUnSafeSupport(string);
        }
        catch (Exception exception) {
            System.out.println("Failed to load the Unsafe utility due to: " + exception.getMessage());
        }
    }

    public static String getVersion() {
        String string = fSystemConfiguration.getProperty("java.version");
        String string2 = fSystemConfiguration.getProperty("java.vm.vendor");
        if (string2 == null) {
            string2 = fSystemConfiguration.getProperty("java.vendor");
        }
        if (string2.toLowerCase().contains(sIBMIdentifier)) {
            return sIBMIdentifier;
        }
        boolean bl = false;
        for (int i = 0; i < sSupported.length; ++i) {
            if (!string.startsWith(sSupported[i])) continue;
            bl = true;
        }
        if (bl) {
            String string3 = string.substring(0, 3);
            try {
                float f = Float.parseFloat(string3);
                int n = (int)((double)f * 10.0);
                if (n > 19) {
                    string = sDefaultVersion;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (string.startsWith("1.4.1")) {
                string = "v1_4_1";
            } else if (string != null && (string = string.substring(0, 3)).charAt(1) == '.') {
                string = "v" + string.charAt(0) + "_" + string.charAt(2);
            }
        } else {
            string = null;
        }
        return fJDKHelperBase.validateVersion(string);
    }

    public static float getVersionAsFloat() {
        String string = fJDKHelper.getVersion();
        if (string.equals(sIBMIdentifier)) {
            string = fSystemConfiguration.getProperty("java.version");
            for (int i = 0; i < sSupported.length; ++i) {
                if (!string.startsWith(sSupported[i])) continue;
                return Float.parseFloat(sSupported[i]);
            }
        }
        float f = 0.0f;
        try {
            if (string.startsWith("v")) {
                string = string.substring(1);
            }
            if (string.contains("_")) {
                string = string.replace("_", ".");
            }
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f;
    }

    private static String validateVersion(String string) {
        String string2;
        block5: {
            string2 = string;
            if (string == null) {
                string2 = sDefaultVersion;
                if ((string2 = string2.substring(0, 3)).charAt(1) == '.') {
                    string2 = "v" + string2.charAt(0) + "_" + string2.charAt(2);
                }
            } else {
                String string3 = "com.pcbsys.foundation.drivers.jdk." + string + ".fURLHelper";
                try {
                    Class<?> clazz = Class.forName(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    string2 = sDefaultVersion;
                    string2 = string2.substring(0, 3);
                    if (string2.charAt(1) != '.') break block5;
                    string2 = "v" + string2.charAt(0) + "_" + string2.charAt(2);
                }
            }
        }
        return string2;
    }

    private static void loadUnSafeSupport(String string) throws Exception {
        Object obj;
        if (string == null) {
            return;
        }
        String string2 = "com.pcbsys.foundation.drivers.jdk." + string + ".fUnSafeImpl";
        Class<?> clazz = Class.forName(string2);
        if (clazz != null && (obj = clazz.newInstance()) instanceof fUnSafe) {
            myUnSafe = (fUnSafe)obj;
        }
    }

    public static fUnSafe getUnsafe() {
        return myUnSafe;
    }

    static {
        fJDKHelperBase.setup();
    }
}

