/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk;

import com.pcbsys.foundation.fConstants;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.AuthProvider;
import java.security.ProviderException;
import java.security.Security;
import java.util.Properties;

public class fNSSHelper {
    private static void confirmPKCS11Loaded() {
        int n = fNSSHelper.locateProviderPosition("SunJSSE");
        int n2 = fNSSHelper.locateProviderPosition("SunPKCS11");
        if (n == -1 || n2 == -1) {
            throw new ProviderException("PKCS11 providers are not loaded");
        }
    }

    private static void confirmPKCS11Unloaded() {
        int n = fNSSHelper.locateProviderPosition("SunJSSE");
        int n2 = fNSSHelper.locateProviderPosition("SunPKCS11");
        if (n != -1 || n2 != -1) {
            throw new ProviderException("PKCS11 providers are not unloaded");
        }
    }

    private static void verifyPreconditions(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new ProviderException("No PKCS11 NSS config file specified");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new ProviderException("No PKCS11 NSS name specified");
        }
    }

    private static void check(String string, String string2, String string3) throws ProviderException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string4 = properties.getProperty(string2);
            ((InputStream)fileInputStream).close();
            if (!string4.equals(string3)) {
                throw new Exception("confirm settings: for " + string2 + " expected " + string3 + " not " + string4);
            }
        }
        catch (Exception exception) {
            String string5 = exception.getMessage();
            if (exception instanceof FileNotFoundException) {
                string5 = "NSS config file not found";
            } else if (exception instanceof IOException) {
                string5 = "Error parsing NSS Config file";
            }
            if (exception instanceof NullPointerException) {
                string5 = string == null ? "Empty or null NSS config file specified" : "Empty or null nssModule specified";
            }
            ProviderException providerException = new ProviderException(string5);
            providerException.initCause(exception);
            throw providerException;
        }
    }

    private static void confirmCryptoSettings(String string) {
        fNSSHelper.check(string, "nssModule", "crypto");
    }

    private static void confirmFIPSSettings(String string) {
        fNSSHelper.check(string, "nssModule", "fips");
    }

    private static int locateProviderPosition(String string) {
        int n = -1;
        int n2 = 0;
        for (java.security.Provider provider : Security.getProviders()) {
            String string2 = provider.getName();
            if (string.equals(string2) || string2.startsWith(string)) {
                n = n2 + 1;
                break;
            }
            ++n2;
        }
        return n;
    }

    private static void loadPKCS11Provider(boolean bl, String string, String string2) throws ProviderException {
        Object object;
        java.security.Provider provider;
        fConstants.logger.log("Load PKCS11 Provider for NSS " + string2);
        fNSSHelper.verifyPreconditions(string, string2);
        try {
            provider = (AuthProvider)Security.getProvider("SunPKCS11-" + string2);
            provider.logout();
        }
        catch (Exception exception) {
            // empty catch block
        }
        provider = null;
        try {
            object = Class.forName("sun.security.pkcs11.SunPKCS11");
            provider = (java.security.Provider)((Class)object).getConstructor(String.class).newInstance(string);
        }
        catch (ProviderException providerException) {
            if (providerException.getMessage().equals("Secmod module already configured")) {
                return;
            }
            String string3 = String.format("Error while loading PKCS11 provider: %s, cause: %s", providerException.getMessage(), providerException.getCause().getMessage());
            fConstants.logger.log(string3);
            throw providerException;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException().getMessage().equals("Secmod module already configured")) {
                return;
            }
            String string4 = String.format("Error loading PKCS11 provider: %s, cause: %s", invocationTargetException.getTargetException().getMessage(), invocationTargetException.getTargetException().getCause());
            throw new ProviderException(string4);
        }
        catch (Throwable throwable) {
            fConstants.logger.log("Unable to dynamically load sun.security.pkcs11.SunPKCS11 for NSS");
            String string5 = String.format("Cannot load sun.security.pkcs11.SunPKCS11: %s", throwable);
            throw new ProviderException(string5);
        }
        if (bl) {
            Security.insertProviderAt(provider, 1);
            return;
        }
        Security.addProvider(provider);
        object = "SunJSSE";
        int n = fNSSHelper.locateProviderPosition((String)object);
        Security.removeProvider((String)object);
        Provider provider2 = new Provider(provider);
        if (n == -1) {
            Security.addProvider((java.security.Provider)provider2);
        } else {
            Security.insertProviderAt((java.security.Provider)provider2, n);
        }
        fNSSHelper.confirmPKCS11Loaded();
    }

    public static void loadPKCS11NSSCryptoProvider(String string, String string2) throws ProviderException {
        fNSSHelper.confirmCryptoSettings(string);
        fNSSHelper.loadPKCS11Provider(true, string, string2);
    }

    public static void loadPKCS11NSSFIPSProvider(String string, String string2) throws ProviderException {
        fNSSHelper.confirmFIPSSettings(string);
        fNSSHelper.loadPKCS11Provider(false, string, string2);
    }
}

