/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.ibm;

import com.pcbsys.foundation.collections.Queue;
import com.pcbsys.foundation.drivers.fNIOManager;
import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import java.nio.ByteBuffer;

public class fBufferManager
implements fBufferManagement {
    private Queue myQueue;
    private int myBufSize;
    private int myQueueSize;
    private long myBufReused = 0L;
    private long myBufCreated = 0L;

    public fBufferManager() {
        this(fNIOManager.getBufferCount(), fNIOManager.getBufferSize());
    }

    public fBufferManager(int n, int n2) {
        this.myQueue = new Queue(n * 2);
        this.myQueueSize = n;
        this.myBufSize = n2;
        if (fNIOManager.allowBufferReuse()) {
            for (int i = 0; i < this.myQueueSize; ++i) {
                this.myQueue.put(this.allocateBuffer(n2));
                ++this.myBufCreated;
            }
        }
    }

    @Override
    public void close() {
        while (this.myQueue.size() != 0) {
            this.myQueue.pop();
        }
        this.myQueue = null;
    }

    @Override
    public int getBufferSize() {
        return this.myBufSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer allocate() {
        ByteBuffer byteBuffer = null;
        Queue queue = this.myQueue;
        synchronized (queue) {
            byteBuffer = (ByteBuffer)this.myQueue.pop();
        }
        if (byteBuffer == null) {
            byteBuffer = this.allocateBuffer(this.myBufSize);
            ++this.myBufCreated;
        } else {
            ++this.myBufReused;
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ByteBuffer byteBuffer) {
        if (byteBuffer.capacity() != this.myBufSize) {
            return;
        }
        byteBuffer.clear();
        if (this.myQueue.size() < this.myQueueSize && fNIOManager.allowBufferReuse()) {
            Queue queue = this.myQueue;
            synchronized (queue) {
                this.myQueue.put(byteBuffer);
            }
        }
    }

    @Override
    public long buffersCreated() {
        return this.myBufCreated;
    }

    @Override
    public long buffersReused() {
        return this.myBufReused;
    }

    @Override
    public void setBufferCount(int n) {
        if (this.myQueueSize == n) {
            return;
        }
        this.myQueueSize = n;
        while (this.myQueueSize > this.myQueue.size()) {
            this.myQueue.put(this.allocateBuffer(this.myBufSize));
            ++this.myBufCreated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferSize(int n) {
        if (n == this.myBufSize) {
            return;
        }
        Queue queue = this.myQueue;
        synchronized (queue) {
            this.myBufSize = n;
            while (this.myQueue.size() != 0) {
                this.myQueue.pop();
            }
            this.myQueue = new Queue(this.myQueueSize * 2);
            if (fNIOManager.allowBufferReuse()) {
                for (int i = 0; i < this.myQueueSize; ++i) {
                    ByteBuffer byteBuffer = this.allocateBuffer(this.myBufSize);
                    byteBuffer.clear();
                    this.myQueue.put(byteBuffer);
                    ++this.myBufCreated;
                }
            }
        }
    }

    private ByteBuffer allocateBuffer(int n) {
        if (fNIOManager.useDirectByteBuffers()) {
            return ByteBuffer.allocateDirect(n);
        }
        return ByteBuffer.allocate(n);
    }
}

