/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.ibm;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.IssuerAlternativeNameExtension;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import com.pcbsys.foundation.drivers.jdk.fAbstractCertGenerator;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Date;

public class fCertGeneratorImpl
extends fAbstractCertGenerator {
    private CertificateExtensions myCertExtensions = null;

    @Override
    public X509Certificate getSelfCertificate(String string, String string2, String string3, String string4, String string5, String string6, long l) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException, IOException {
        GeneralNames generalNames;
        if (string == null) {
            throw new RuntimeException("Empty CN specified");
        }
        DerOutputStream derOutputStream = string.split(",");
        if (((String[])derOutputStream).length > 1) {
            this.myCertExtensions = new CertificateExtensions();
            generalNames = new GeneralNames();
            for (String string7 : derOutputStream) {
                if (string7.equals(derOutputStream[0])) continue;
                try {
                    generalNames.add((Object)this.createGeneralName(string7));
                }
                catch (Exception exception) {
                    throw new CertificateExpiredException(exception.getMessage());
                }
            }
            try {
                DerOutputStream derOutputStream2 = new DerOutputStream();
                generalNames.encode(derOutputStream2);
                if (this.isSAN) {
                    this.myCertExtensions.set("SubjectAlternativeName", (Object)new SubjectAlternativeNameExtension(Boolean.valueOf(this.isCritical), (Object)derOutputStream2.toByteArray()));
                } else {
                    this.myCertExtensions.set("IssuerAlternativeName", (Object)new IssuerAlternativeNameExtension(Boolean.valueOf(this.isCritical), (Object)derOutputStream2.toByteArray()));
                }
            }
            catch (GeneralNamesException generalNamesException) {
                generalNamesException.printStackTrace();
                throw new CertificateException(generalNamesException);
            }
        }
        generalNames = new X500Name(derOutputStream[0], string2, string3, string4, string5, string6);
        return this.getSelfCertificate((X500Name)generalNames, l);
    }

    private GeneralName createGeneralName(String string) throws Exception {
        boolean bl = this.isIPAddress(string);
        Object object = bl ? new IPAddressName(string) : new DNSName(string);
        return new GeneralName((GeneralNameInterface)object);
    }

    X509Certificate getSelfCertificate(X500Name x500Name, Date date, long l) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            CustomX500Signer customX500Signer = this.getCustomSigner(x500Name);
            Date date2 = new Date();
            date2.setTime(date.getTime() + l * 1000L);
            CertificateValidity certificateValidity = new CertificateValidity(date, date2);
            X509CertInfo x509CertInfo = new X509CertInfo();
            x509CertInfo.set("version", (Object)new CertificateVersion(2));
            x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber((int)(date.getTime() / 1000L)));
            AlgorithmId algorithmId = customX500Signer.getAlgorithmId();
            x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmId));
            x509CertInfo.set("subject", (Object)x500Name);
            x509CertInfo.set("key", (Object)new CertificateX509Key(this.myPublicKey));
            x509CertInfo.set("validity", (Object)certificateValidity);
            x509CertInfo.set("issuer", (Object)customX500Signer.getSigner());
            if (fSystemConfiguration.getProperty("sun.security.internal.keytool.skid") == null) {
                if (this.myCertExtensions != null) {
                    x509CertInfo.set("extensions", (Object)this.myCertExtensions);
                }
            } else {
                if (this.myCertExtensions == null) {
                    this.myCertExtensions = new CertificateExtensions();
                }
                this.myCertExtensions.set("SubjectKeyIdentifier", (Object)new SubjectKeyIdentifierExtension(new KeyIdentifier(this.myPublicKey.getEncoded()).getIdentifier()));
                x509CertInfo.set("extensions", (Object)this.myCertExtensions);
            }
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(this.myPrivateKey, this.mySignatureAlgorithm);
            return x509CertImpl;
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("getSelfCertificate Error: " + iOException.getMessage());
        }
    }

    X509Certificate getSelfCertificate(X500Name x500Name, long l) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(x500Name, new Date(), l);
    }

    private CustomX500Signer getCustomSigner(X500Name x500Name) throws InvalidKeyException, NoSuchAlgorithmException {
        Signature signature = Signature.getInstance(this.mySignatureAlgorithm);
        signature.initSign(this.myPrivateKey);
        return new CustomX500Signer(signature, x500Name);
    }

    private static final class CustomX500Signer {
        private transient Signature mySignature;
        private transient X500Name mySigningAgent;
        private AlgorithmId myAlgorithmID;

        public void update(byte[] byArray, int n, int n2) throws SignatureException {
            this.mySignature.update(byArray, n, n2);
        }

        public byte[] sign() throws SignatureException {
            return this.mySignature.sign();
        }

        public AlgorithmId getAlgorithmId() {
            return this.myAlgorithmID;
        }

        public X500Name getSigner() {
            return this.mySigningAgent;
        }

        CustomX500Signer(Signature signature, X500Name x500Name) {
            if (signature == null || x500Name == null) {
                throw new IllegalArgumentException("NULL parameters are not allowed!");
            }
            this.mySignature = signature;
            this.mySigningAgent = x500Name;
            try {
                this.myAlgorithmID = AlgorithmId.get((String)signature.getAlgorithm());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("An internal signing error occurred: " + noSuchAlgorithmException.getMessage());
            }
        }
    }
}

