/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.ibm;

import com.pcbsys.foundation.drivers.jdk.fDefaultFileSupport;
import com.pcbsys.foundation.drivers.jdk.ibm.FileCopyOption;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class fFileSupportImpl
extends fDefaultFileSupport {
    private static final boolean isNioFilesApiAvailable = fFileSupportImpl.isNioFilesApiAvailable();

    @Override
    public void renameFile(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File to rename must not be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File to rename must not be a directory");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("File to rename to must not be null");
        }
        if (isNioFilesApiAvailable) {
            try {
                this.renameFileJava7(file, file2, bl);
                return;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Throwable throwable;
                if (reflectiveOperationException instanceof InvocationTargetException && (throwable = ((InvocationTargetException)reflectiveOperationException).getTargetException()) instanceof IOException) {
                    throw (IOException)throwable;
                }
                fFileSupportImpl.log("Failed to rename file " + file + " to file " + file2 + " using Java NIO API, falling back to standard rename", reflectiveOperationException);
            }
        }
        super.renameFile(file, file2, bl);
    }

    void renameFileJava7(File file, File file2, boolean bl) throws IOException, ReflectiveOperationException {
        if (file2.exists() && !bl) {
            throw new IOException("Failed to rename file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + ". New file " + file2.getAbsolutePath() + " exists and replaceExisting is false");
        }
        try {
            this.renameFileJava7(file, file2, FileCopyOption.ATOMIC);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            if (reflectiveOperationException instanceof InvocationTargetException && ((InvocationTargetException)reflectiveOperationException).getTargetException() instanceof IOException) {
                fFileSupportImpl.log("Failed to rename file " + file + " to file " + file2 + " using atomic move, falling back to non-atomic", reflectiveOperationException);
                this.renameFileJava7(file, file2, bl ? FileCopyOption.REPLACE_EXISTING : null);
            }
            throw reflectiveOperationException;
        }
    }

    private void renameFileJava7(File file, File file2, FileCopyOption fileCopyOption) throws ReflectiveOperationException {
        Class<?> clazz = Class.forName("java.nio.file.CopyOption");
        Object object = Array.newInstance(clazz, fileCopyOption == null ? 0 : 1);
        if (fileCopyOption != null) {
            Array.set(object, 0, fFileSupportImpl.createCopyOption(fileCopyOption));
        }
        Method method = file.getClass().getMethod("toPath", new Class[0]);
        Object object2 = method.invoke((Object)file, new Object[0]);
        Object object3 = method.invoke((Object)file2, new Object[0]);
        Class<?> clazz2 = Class.forName("java.nio.file.Path");
        Class<?> clazz3 = Class.forName("java.nio.file.Files");
        Method method2 = clazz3.getMethod("move", clazz2, clazz2, object.getClass());
        method2.invoke(null, object2, object3, object);
    }

    private static Object createCopyOption(FileCopyOption fileCopyOption) throws ReflectiveOperationException {
        String string;
        if (fileCopyOption == null) {
            throw new IllegalArgumentException("Copy option must not be null");
        }
        if (fileCopyOption == FileCopyOption.ATOMIC) {
            string = "ATOMIC_MOVE";
        } else if (fileCopyOption == FileCopyOption.REPLACE_EXISTING) {
            string = "REPLACE_EXISTING";
        } else {
            throw new IllegalArgumentException("Unsupported copy option: " + (Object)((Object)fileCopyOption));
        }
        Class<?> clazz = Class.forName("java.lang.Enum");
        Method method = clazz.getMethod("valueOf", Class.class, String.class);
        Class<?> clazz2 = Class.forName("java.nio.file.StandardCopyOption");
        return method.invoke(null, clazz2, string);
    }

    private static boolean isNioFilesApiAvailable() {
        try {
            Class.forName("java.nio.file.Files");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

