/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.ibm;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.jdk.fSSLContextFactory;
import com.pcbsys.foundation.fConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class fSSLContext
implements fSSLContextFactory {
    public Object getSSLEngine(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        SSLContext sSLContext = (SSLContext)this.getContext(fBaseSSLConfig2);
        return sSLContext.createSSLEngine();
    }

    public Object getSSLSocketFactory(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        SSLContext sSLContext = (SSLContext)this.getContext(fBaseSSLConfig2);
        return sSLContext.getServerSocketFactory();
    }

    @Override
    public Object getContext(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        Object object;
        Object object2;
        KeyStore keyStore;
        KeyManagerFactory keyManagerFactory;
        if (fBaseSSLConfig2.getKeyStore() == null) {
            throw new IOException("No Keystore file supplied, unable to support SSL");
        }
        if (fBaseSSLConfig2.getTrustStore() == null) {
            throw new IOException("No Truststore file supplied, unable to support SSL");
        }
        if (fBaseSSLConfig2.getTrustStorePassword() == null) {
            throw new IOException("No Truststore password supplied, unable to support SSL");
        }
        if (fBaseSSLConfig2.getKeyStorePassword() == null) {
            throw new IOException("No Keystore password supplied, unable to support SSL");
        }
        SSLContext sSLContext = com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.instantiateSSLContext(fBaseSSLConfig2);
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyStore = KeyStore.getInstance("JKS");
            object2 = new File(fBaseSSLConfig2.getKeyStore());
            if (!((File)object2).exists()) {
                throw new FileNotFoundException("Keystore file: " + fBaseSSLConfig2.getKeyStore() + " does not exist");
            }
            object = fFile.openFileInputStream((File)object2);
            keyStore.load((InputStream)object, fBaseSSLConfig2.getKeyStorePassword().toCharArray());
            ((FileInputStream)object).close();
            com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.pruneKeyStore(fBaseSSLConfig2, keyStore);
            if (fBaseSSLConfig2.getPrivateKeyPassword() != null) {
                keyManagerFactory.init(keyStore, fBaseSSLConfig2.getPrivateKeyPassword().toCharArray());
            } else {
                keyManagerFactory.init(keyStore, fBaseSSLConfig2.getKeyStorePassword().toCharArray());
            }
        }
        catch (IOException iOException) {
            fConstants.logger.fatal("IOException raised while loading private keystore <" + fBaseSSLConfig2.getKeyStore() + "> : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(iOException));
            fConstants.logger.fatal(iOException);
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(noSuchAlgorithmException));
        }
        catch (CertificateException certificateException) {
            fConstants.logger.fatal("Certificate error raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(certificateException);
            throw new IOException("Certificate Exception : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(certificateException));
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            fConstants.logger.fatal("Unrecoverable Key Exception raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(unrecoverableKeyException);
            throw new IOException("Unrecoverable Key Exception : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(unrecoverableKeyException));
        }
        catch (KeyStoreException keyStoreException) {
            fConstants.logger.fatal("KeyStore Exception raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(keyStoreException);
            throw new IOException("Keystore Exception : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(keyStoreException));
        }
        try {
            Object object3;
            object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            object = KeyStore.getInstance("JKS");
            File file = new File(fBaseSSLConfig2.getTrustStore());
            if (!file.exists()) {
                throw new FileNotFoundException("Truststore file: " + fBaseSSLConfig2.getTrustStore() + " does not exist");
            }
            FileInputStream fileInputStream = fFile.openFileInputStream(file);
            if (fBaseSSLConfig2.getTrustStorePassword() != null) {
                ((KeyStore)object).load(fileInputStream, fBaseSSLConfig2.getTrustStorePassword().toCharArray());
            } else {
                ((KeyStore)object).load(fileInputStream, fBaseSSLConfig2.getKeyStorePassword().toCharArray());
            }
            fileInputStream.close();
            ((TrustManagerFactory)object2).init((KeyStore)object);
            Enumeration<String> enumeration = ((KeyStore)object).aliases();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                object3 = enumeration.nextElement();
                fConstants.logger.debug("Loaded Trusted CA Certificate " + n + " " + (String)object3);
                ++n;
            }
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                object3 = enumeration.nextElement();
                fConstants.logger.debug("Loaded Certificate " + (String)object3);
            }
            object3 = this.loadSecureRandom(fBaseSSLConfig2.getRandomAlgorithm(), fBaseSSLConfig2.getRandomProvider());
            sSLContext.init(keyManagerFactory.getKeyManagers(), ((TrustManagerFactory)object2).getTrustManagers(), (SecureRandom)object3);
            fBaseSSLConfig2.getCertRequired();
        }
        catch (IOException iOException) {
            fConstants.logger.fatal("IOException raised loading truststore keystore <" + fBaseSSLConfig2.getTrustStore() + ">");
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(noSuchAlgorithmException));
        }
        catch (CertificateException certificateException) {
            fConstants.logger.fatal("Certificate error raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(certificateException);
            throw new IOException("Certificate Exception : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(certificateException));
        }
        catch (KeyStoreException keyStoreException) {
            fConstants.logger.fatal("KeyStore Exception raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(keyStoreException);
            throw new IOException("Keystore Exception : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(keyStoreException));
        }
        catch (KeyManagementException keyManagementException) {
            fConstants.logger.fatal("KeyManagement Exception raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(keyManagementException);
            throw new IOException("KeyManagement Exception : " + com.pcbsys.foundation.drivers.jdk.v1_5.fSSLContext.getMessage(keyManagementException));
        }
        return sSLContext;
    }

    @Override
    public SecureRandom loadSecureRandom(String string, String string2) {
        SecureRandom secureRandom;
        block5: {
            secureRandom = null;
            if (string != null && string.length() > 1) {
                try {
                    if (string2 != null) {
                        secureRandom = SecureRandom.getInstance(string, string2);
                        fConstants.logger.debug("Using secure random generator algoritm : " + string + " provided by " + string2);
                        break block5;
                    }
                    secureRandom = SecureRandom.getInstance(string);
                    fConstants.logger.debug("Using secure random generator algoritm : " + string);
                }
                catch (Exception exception) {
                    fConstants.logger.log("Unable to load secure random generator algoritm : " + string + " using default");
                }
            } else {
                fConstants.logger.debug("Using default SecureRandom generator");
            }
        }
        return secureRandom;
    }
}

