/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.ibm;

import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.fNIOManager;
import com.pcbsys.foundation.drivers.fSSLServerSocketDriver;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.fServerSocketDriver;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.jdk.fDefaultSocketHelper;
import com.pcbsys.foundation.drivers.nio.fSSLServerChannelDriver;
import com.pcbsys.foundation.drivers.nio.fServerChannelDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionSettings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class fSocketHelper
extends fDefaultSocketHelper {
    static boolean setTOS = true;

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        Socket socket = new Socket();
        socket.bind(null);
        socket.connect(new InetSocketAddress(string, n), fConnectionSettings.getSocketConnectTimeout());
        return socket;
    }

    @Override
    public void setupSocket(Socket socket) throws IOException {
        super.setupSocket(socket);
        socket.setKeepAlive(true);
        socket.setPerformancePreferences(2, 10, 5);
        if (setTOS) {
            int n = 16;
            n += 8;
            n += 4;
            try {
                socket.setTrafficClass(n);
            }
            catch (Throwable throwable) {
                setTOS = false;
                fConstants.logger.fatal("Unable to set TC=0x" + Integer.toHexString(n) + " on the socket - " + throwable);
            }
        }
    }

    @Override
    public fServerDriver getServerDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        boolean bl;
        boolean bl2 = bl = fBaseDriverConfig2.isAllowNIO() && fNIOManager.available();
        if (bl) {
            fConstants.logger.log("Starting Socket driver with NIO support");
            return new fServerChannelDriver(fBaseDriverConfig2, fAcceptHandler2, string);
        }
        fConstants.logger.log("Starting Socket driver without NIO support");
        return new fServerSocketDriver(fBaseDriverConfig2, fAcceptHandler2, string);
    }

    @Override
    public fServerDriver getSSLServerDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        boolean bl;
        boolean bl2 = bl = fBaseDriverConfig2.isAllowNIO() && fNIOManager.available();
        if (bl) {
            fConstants.logger.log("Starting SSL driver with NIO support");
            return new fSSLServerChannelDriver(fBaseDriverConfig2, fAcceptHandler2, string);
        }
        fConstants.logger.log("Starting SSL driver without NIO support");
        return new fSSLServerSocketDriver(fBaseDriverConfig2, fAcceptHandler2, string);
    }

    @Override
    public void close(Socket socket) throws IOException {
        super.close(socket);
    }
}

