/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.v1_5;

import com.pcbsys.foundation.collections.fLockingCircularQueue;
import com.pcbsys.foundation.drivers.fNIOManager;
import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import com.pcbsys.foundation.fConstants;
import java.nio.ByteBuffer;

public class fBufferManager
implements fBufferManagement {
    private final fLockingCircularQueue<ByteBuffer> myQueue;
    private int myBufSize;
    private int myQueueSize;
    private volatile long myBufReused;
    private volatile long myBufCreated;

    public fBufferManager() {
        this(fNIOManager.getBufferCount(), fNIOManager.getBufferSize());
    }

    public fBufferManager(int n, int n2) {
        this.myQueue = new fLockingCircularQueue(n * 2);
        this.myQueueSize = n;
        this.myBufSize = n2;
        this.myBufReused = 0L;
        this.myBufCreated = 0L;
        if (fNIOManager.allowBufferReuse()) {
            try {
                for (int i = 0; i < this.myQueueSize; ++i) {
                    this.myQueue.put(this.allocateBuffer(n2));
                    ++this.myBufCreated;
                }
            }
            catch (Throwable throwable) {
                System.err.println("*****************************************************************************************************");
                System.err.println("Unable to allocate " + this.myQueueSize + " of network buffers of " + n2 + " bytes");
                System.err.println("Server Unable to start. Please review the MaxDirectMemorySize and the Xmx Xms settings for the server");
                System.err.println("*****************************************************************************************************");
                fConstants.logger.info("*****************************************************************************************************");
                fConstants.logger.info("Unable to allocate " + this.myQueueSize + " of network buffers of " + n2 + " bytes");
                fConstants.logger.info("Server Unable to start. Please review the MaxDirectMemorySize and the Xmx Xms settings for the server");
                fConstants.logger.info("*****************************************************************************************************");
                System.exit(2);
            }
        }
    }

    @Override
    public void close() {
        this.myQueue.reset();
    }

    @Override
    public int getBufferSize() {
        return this.myBufSize;
    }

    @Override
    public ByteBuffer allocate() {
        ByteBuffer byteBuffer = this.myQueue.pop();
        if (byteBuffer == null) {
            byteBuffer = this.allocateBuffer(this.myBufSize);
        } else {
            ++this.myBufReused;
        }
        return byteBuffer;
    }

    @Override
    public void release(ByteBuffer byteBuffer) {
        if (byteBuffer.capacity() != this.myBufSize) {
            return;
        }
        byteBuffer.clear();
        this.myQueue.put(byteBuffer);
    }

    @Override
    public long buffersCreated() {
        return this.myBufCreated;
    }

    @Override
    public long buffersReused() {
        return this.myBufReused;
    }

    @Override
    public void setBufferCount(int n) {
    }

    @Override
    public void setBufferSize(int n) {
        if (n == this.myBufSize) {
            return;
        }
        this.myBufSize = n;
        this.myQueue.reset();
        if (fNIOManager.allowBufferReuse()) {
            for (int i = 0; i < this.myQueueSize; ++i) {
                ByteBuffer byteBuffer = this.allocateBuffer(this.myBufSize);
                byteBuffer.clear();
                this.myQueue.put(byteBuffer);
                ++this.myBufCreated;
            }
        }
    }

    private ByteBuffer allocateBuffer(int n) {
        if (fNIOManager.useDirectByteBuffers()) {
            return ByteBuffer.allocateDirect(n);
        }
        return ByteBuffer.allocate(n);
    }
}

