/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.v1_5;

import com.pcbsys.foundation.drivers.jdk.fAbstractCertGenerator;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class fCertGeneratorImpl
extends fAbstractCertGenerator {
    private GeneralNames generalNames;
    private static BouncyCastleProvider provider = new BouncyCastleProvider();

    @Override
    public X509Certificate getSelfCertificate(String string, String string2, String string3, String string4, String string5, String string6, long l) throws CertificateException {
        if (string == null) {
            throw new RuntimeException("Empty CN specified");
        }
        String[] stringArray = string.split(",");
        this.createGeneralNames(stringArray);
        X500Name x500Name = this.createX500Name(stringArray[0], string2, string3, string4, string5, string6);
        return this.getSelfCertificate(x500Name, l);
    }

    @Override
    public void init(String string, String string2) throws NoSuchAlgorithmException {
        super.init(string, string2);
        Security.addProvider((Provider)provider);
    }

    @Override
    public void init(String string, String string2, boolean bl, boolean bl2) throws NoSuchAlgorithmException {
        super.init(string, string2, bl, bl2);
        Security.addProvider((Provider)provider);
    }

    private X509Certificate getSelfCertificate(X500Name x500Name, long l) throws CertificateException {
        return this.getSelfCertificate(x500Name, new Date(), l);
    }

    private X509Certificate getSelfCertificate(X500Name x500Name, Date date, long l) throws CertificateException {
        try {
            Date date2 = new Date();
            date2.setTime(date.getTime() + l * 1000L);
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)this.myPublicKey.getEncoded());
            X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(x500Name, BigInteger.valueOf(date.getTime() / 1000L), date, date2, x500Name, subjectPublicKeyInfo);
            this.addExtension(x509v3CertificateBuilder);
            ContentSigner contentSigner = new JcaContentSignerBuilder(this.mySignatureAlgorithm).setProvider((Provider)provider).build(this.myPrivateKey);
            X509CertificateHolder x509CertificateHolder = x509v3CertificateBuilder.build(contentSigner);
            return new JcaX509CertificateConverter().setProvider((Provider)provider).getCertificate(x509CertificateHolder);
        }
        catch (IOException | OperatorCreationException throwable) {
            throw new CertificateEncodingException("getSelfCertificate Error: " + throwable.getMessage());
        }
    }

    private void addExtension(X509v3CertificateBuilder x509v3CertificateBuilder) throws IOException {
        if (fSystemConfiguration.getProperty("sun.security.internal.keytool.skid") == null && this.generalNames != null) {
            if (this.isSAN) {
                x509v3CertificateBuilder.addExtension(Extension.subjectAlternativeName, this.isCritical, (ASN1Encodable)this.generalNames.toASN1Primitive());
            } else {
                x509v3CertificateBuilder.addExtension(Extension.issuerAlternativeName, this.isCritical, this.generalNames.getEncoded());
            }
        } else {
            SubjectKeyIdentifier subjectKeyIdentifier = this.createSubjectKeyIdentifier();
            x509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, this.isCritical, (ASN1Encodable)subjectKeyIdentifier);
        }
    }

    private SubjectKeyIdentifier createSubjectKeyIdentifier() throws IOException {
        try (ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.myPublicKey.getEncoded()));){
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)aSN1Sequence);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(subjectPublicKeyInfo);
            return subjectKeyIdentifier;
        }
    }

    private void createGeneralNames(String[] stringArray) throws CertificateExpiredException {
        if (stringArray.length > 1) {
            ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>();
            for (String string : stringArray) {
                if (string.equals(stringArray[0])) continue;
                try {
                    arrayList.add(this.getGeneralName(string));
                }
                catch (Exception exception) {
                    throw new CertificateExpiredException(exception.getMessage());
                }
            }
            this.generalNames = new GeneralNames(arrayList.toArray(new GeneralName[0]));
        }
    }

    private X500Name createX500Name(String string, String string2, String string3, String string4, String string5, String string6) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder();
        x500NameBuilder.addRDN(BCStyle.CN, string).addRDN(BCStyle.OU, string2).addRDN(BCStyle.O, string3).addRDN(BCStyle.L, string4).addRDN(BCStyle.ST, string5).addRDN(BCStyle.C, string6);
        return x500NameBuilder.build();
    }

    private GeneralName getGeneralName(String string) {
        boolean bl = this.isIPAddress(string);
        if (bl) {
            return new GeneralName(7, string);
        }
        return new GeneralName(2, string);
    }
}

