/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.v1_5;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.jdk.fSSLContextFactory;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.fLogLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class fSSLContext
implements fSSLContextFactory {
    public Object getSSLEngine(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        SSLContext sSLContext = (SSLContext)this.getContext(fBaseSSLConfig2);
        return sSLContext.createSSLEngine();
    }

    public Object getSSLSocketFactory(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        SSLContext sSLContext = (SSLContext)this.getContext(fBaseSSLConfig2);
        return sSLContext.getServerSocketFactory();
    }

    @Override
    public Object getContext(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        Object object;
        Object object2;
        KeyStore keyStore;
        KeyManagerFactory keyManagerFactory;
        if (fBaseSSLConfig2.getKeyStore() == null) {
            throw new IOException("No Keystore file supplied, unable to support SSL");
        }
        if (fBaseSSLConfig2.getTrustStore() == null) {
            throw new IOException("No Truststore file supplied, unable to support SSL");
        }
        if (fBaseSSLConfig2.getTrustStorePassword() == null) {
            throw new IOException("No Truststore password supplied, unable to support SSL");
        }
        if (fBaseSSLConfig2.getKeyStorePassword() == null) {
            throw new IOException("No Keystore password supplied, unable to support SSL");
        }
        SSLContext sSLContext = fSSLContext.instantiateSSLContext(fBaseSSLConfig2);
        try {
            keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyStore = KeyStore.getInstance("JKS");
            object2 = new File(fBaseSSLConfig2.getKeyStore());
            if (!((File)object2).exists()) {
                throw new FileNotFoundException("Keystore file: " + fBaseSSLConfig2.getKeyStore() + " does not exist");
            }
            object = fFile.openFileInputStream(fBaseSSLConfig2.getKeyStore());
            keyStore.load((InputStream)object, fBaseSSLConfig2.getKeyStorePassword().toCharArray());
            ((FileInputStream)object).close();
            fSSLContext.pruneKeyStore(fBaseSSLConfig2, keyStore);
            if (fBaseSSLConfig2.getPrivateKeyPassword() != null) {
                keyManagerFactory.init(keyStore, fBaseSSLConfig2.getPrivateKeyPassword().toCharArray());
            } else {
                keyManagerFactory.init(keyStore, fBaseSSLConfig2.getKeyStorePassword().toCharArray());
            }
        }
        catch (IOException iOException) {
            fConstants.logger.fatal("IOException raised while loading private keystore <" + fBaseSSLConfig2.getKeyStore() + "> : " + fSSLContext.getMessage(iOException));
            fConstants.logger.fatal(iOException);
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found : " + fSSLContext.getMessage(noSuchAlgorithmException));
        }
        catch (CertificateException certificateException) {
            fConstants.logger.fatal("Certificate error raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(certificateException);
            throw new IOException("Certificate Exception : " + fSSLContext.getMessage(certificateException));
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            fConstants.logger.fatal("Unrecoverable Key Exception raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(unrecoverableKeyException);
            throw new IOException("Unrecoverable Key Exception : " + fSSLContext.getMessage(unrecoverableKeyException));
        }
        catch (KeyStoreException keyStoreException) {
            fConstants.logger.fatal("KeyStore Exception raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(keyStoreException);
            throw new IOException("Keystore Exception : " + fSSLContext.getMessage(keyStoreException));
        }
        try {
            Object object3;
            object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            object = KeyStore.getInstance("JKS");
            File file = new File(fBaseSSLConfig2.getTrustStore());
            if (!file.exists()) {
                throw new FileNotFoundException("Truststore file: " + fBaseSSLConfig2.getTrustStore() + " does not exist");
            }
            FileInputStream fileInputStream = fFile.openFileInputStream(file);
            if (fBaseSSLConfig2.getTrustStorePassword() != null) {
                ((KeyStore)object).load(fileInputStream, fBaseSSLConfig2.getTrustStorePassword().toCharArray());
            } else {
                ((KeyStore)object).load(fileInputStream, fBaseSSLConfig2.getKeyStorePassword().toCharArray());
            }
            fileInputStream.close();
            ((TrustManagerFactory)object2).init((KeyStore)object);
            Enumeration<String> enumeration = ((KeyStore)object).aliases();
            int n = 0;
            while (enumeration.hasMoreElements() && fConstants.logger.isDebugEnabled()) {
                object3 = enumeration.nextElement();
                fConstants.logger.debug("Loaded Trusted CA Certificate " + n + " " + (String)object3);
                ++n;
            }
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements() && fConstants.logger.isDebugEnabled()) {
                object3 = enumeration.nextElement();
                fConstants.logger.debug("Loaded Certificate " + (String)object3);
            }
            object3 = this.loadSecureRandom(fBaseSSLConfig2.getRandomAlgorithm(), fBaseSSLConfig2.getRandomProvider());
            sSLContext.init(keyManagerFactory.getKeyManagers(), ((TrustManagerFactory)object2).getTrustManagers(), (SecureRandom)object3);
            fBaseSSLConfig2.getCertRequired();
        }
        catch (IOException iOException) {
            fConstants.logger.fatal("IOException raised loading truststore keystore <" + fBaseSSLConfig2.getTrustStore() + ">");
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found : " + fSSLContext.getMessage(noSuchAlgorithmException));
        }
        catch (CertificateException certificateException) {
            fConstants.logger.fatal("Certificate error raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(certificateException);
            throw new IOException("Certificate Exception : " + fSSLContext.getMessage(certificateException));
        }
        catch (KeyStoreException keyStoreException) {
            fConstants.logger.fatal("KeyStore Exception raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(keyStoreException);
            throw new IOException("Keystore Exception : " + fSSLContext.getMessage(keyStoreException));
        }
        catch (KeyManagementException keyManagementException) {
            fConstants.logger.fatal("KeyManagement Exception raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(keyManagementException);
            throw new IOException("KeyManagement Exception : " + fSSLContext.getMessage(keyManagementException));
        }
        return sSLContext;
    }

    public static void pruneKeyStore(fBaseSSLConfig fBaseSSLConfig2, KeyStore keyStore) throws KeyStoreException, IOException {
        if (keyStore.size() > 1) {
            Enumeration<String> enumeration = keyStore.aliases();
            if (fBaseSSLConfig2.getAlias() != null && fBaseSSLConfig2.getAlias().length() > 0) {
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (string.equalsIgnoreCase(fBaseSSLConfig2.getAlias())) continue;
                    keyStore.deleteEntry(string);
                }
            }
        } else {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements() && fConstants.logger.canLog(fLogLevel.TRACE)) {
                fConstants.logger.trace("KeyStore has only one certificate :" + enumeration.nextElement().toString());
            }
        }
        if (keyStore.size() == 0) {
            fConstants.logger.fatal("No certificates found in keystore : " + fBaseSSLConfig2.getKeyStore() + ", Alias : " + fBaseSSLConfig2.getAlias());
            throw new IOException("No certificates found in keystore : " + fBaseSSLConfig2.getKeyStore() + ", Alias : " + fBaseSSLConfig2.getAlias());
        }
    }

    public static SSLContext instantiateSSLContext(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        SSLContext sSLContext;
        String string = fBaseSSLConfig2.getProvider();
        try {
            if (string != null) {
                try {
                    sSLContext = SSLContext.getInstance("TLS", string);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    fConstants.logger.fatal("No such provider found " + string + " using JVM default");
                    fConstants.logger.fatal(noSuchProviderException);
                    sSLContext = SSLContext.getInstance("TLS");
                }
            } else {
                sSLContext = SSLContext.getInstance("TLS");
            }
            if (fConstants.logger.canLog(fLogLevel.TRACE)) {
                fConstants.logger.trace("JSSE provider " + sSLContext.getProvider().toString() + " used");
            }
        }
        catch (RuntimeException runtimeException) {
            fConstants.logger.fatal("No support for TLS found during initial SSL Context load. Unable to support SSL");
            fConstants.logger.fatal(fSSLContext.getMessage(runtimeException));
            throw new IOException("No support for TLS found during initial SSL Context load: " + fSSLContext.getMessage(runtimeException));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not found during initial SSL Context load. Unable to support SSL");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found during initial SSL Context load : " + fSSLContext.getMessage(noSuchAlgorithmException));
        }
        return sSLContext;
    }

    @Override
    public SecureRandom loadSecureRandom(String string, String string2) {
        SecureRandom secureRandom = null;
        if (string != null && string.length() > 1) {
            try {
                if (string2 != null) {
                    secureRandom = SecureRandom.getInstance(string, string2);
                    if (fConstants.logger.isDebugEnabled()) {
                        fConstants.logger.debug("Using secure random generator algoritm : " + string + " provided by " + string2);
                    }
                } else {
                    secureRandom = SecureRandom.getInstance(string);
                    if (fConstants.logger.isDebugEnabled()) {
                        fConstants.logger.debug("Using secure random generator algoritm : " + string);
                    }
                }
            }
            catch (Exception exception) {
                fConstants.logger.log("Unable to load secure random generator algoritm : " + string + " using default");
            }
        } else if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Using default SecureRandom generator");
        }
        return secureRandom;
    }

    public static String getMessage(Exception exception) {
        if (exception != null) {
            if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                return exception.getMessage();
            }
            return exception.getClass().toString();
        }
        return "Unknown exception raised, is Null";
    }
}

