/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.v1_6;

import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.jdk.fNSSHelper;
import com.pcbsys.foundation.drivers.jdk.fSSLContextFactory;
import com.pcbsys.foundation.fConstants;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class fNSSContext
implements fSSLContextFactory {
    public Object getSSLEngine(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        SSLContext sSLContext = (SSLContext)this.getContext(fBaseSSLConfig2);
        return sSLContext.createSSLEngine();
    }

    public Object getSSLSocketFactory(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        SSLContext sSLContext = (SSLContext)this.getContext(fBaseSSLConfig2);
        return sSLContext.getServerSocketFactory();
    }

    @Override
    public Object getContext(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        Object object;
        Object object2;
        if (fBaseSSLConfig2.getKeyStorePassword() == null) {
            throw new IOException("No Keystore password supplied, unable to support SSL");
        }
        fNSSHelper.loadPKCS11NSSFIPSProvider(fBaseSSLConfig2.getPKCS11NSSConfigFile(), fBaseSSLConfig2.getPKCS11NSSName());
        String string = fBaseSSLConfig2.getProvider();
        SSLContext sSLContext = null;
        try {
            object2 = "TLS";
            if (string != null) {
                try {
                    sSLContext = SSLContext.getInstance((String)object2, string);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    fConstants.logger.info("No such provider found " + string + " using JVM default");
                    fConstants.logger.fatal(noSuchProviderException);
                    sSLContext = SSLContext.getInstance((String)object2);
                }
            } else {
                sSLContext = SSLContext.getInstance((String)object2);
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("JSSE provider " + sSLContext.getProvider().toString() + " used");
            }
        }
        catch (RuntimeException runtimeException) {
            fConstants.logger.fatal("No support for TLS found during initial SSL Context load. Unable to support SSL");
            fConstants.logger.fatal(fNSSContext.getMessage(runtimeException));
            throw new IOException("No support for TLS found during initial SSL Context load: " + fNSSContext.getMessage(runtimeException));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not found during initial SSL Context load. Unable to support SSL");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found during initial SSL Context load : " + fNSSContext.getMessage(noSuchAlgorithmException));
        }
        object2 = null;
        KeyStore keyStore = null;
        try {
            object = KeyManagerFactory.getDefaultAlgorithm();
            object2 = KeyManagerFactory.getInstance((String)object);
            keyStore = KeyStore.getInstance("PKCS11");
            keyStore.load(null, fBaseSSLConfig2.getKeyStorePassword().toCharArray());
            if (keyStore.size() == 0) {
                fConstants.logger.fatal("No certificates found in keystore : " + fBaseSSLConfig2.getKeyStore() + ", Alias : " + fBaseSSLConfig2.getAlias());
                throw new IOException("No certificates found in keystore : " + fBaseSSLConfig2.getKeyStore() + ", Alias : " + fBaseSSLConfig2.getAlias());
            }
            ((KeyManagerFactory)object2).init(keyStore, null);
        }
        catch (IOException iOException) {
            fConstants.logger.fatal("IOException raised while loading private keystore <" + fBaseSSLConfig2.getKeyStore() + "> : " + fNSSContext.getMessage(iOException));
            fConstants.logger.fatal(iOException);
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found : " + fNSSContext.getMessage(noSuchAlgorithmException));
        }
        catch (CertificateException certificateException) {
            fConstants.logger.fatal("Certificate error raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(certificateException);
            throw new IOException("Certificate Exception : " + fNSSContext.getMessage(certificateException));
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            fConstants.logger.fatal("Unrecoverable Key Exception raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(unrecoverableKeyException);
            throw new IOException("Unrecoverable Key Exception : " + fNSSContext.getMessage(unrecoverableKeyException));
        }
        catch (KeyStoreException keyStoreException) {
            fConstants.logger.fatal("KeyStore Exception raised during private keystore load <" + fBaseSSLConfig2.getKeyStore() + ">");
            fConstants.logger.fatal(keyStoreException);
            throw new IOException("Keystore Exception : " + fNSSContext.getMessage(keyStoreException));
        }
        object = null;
        try {
            Object object3;
            String string2 = TrustManagerFactory.getDefaultAlgorithm();
            object = TrustManagerFactory.getInstance(string2);
            ((TrustManagerFactory)object).init(keyStore);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements() && fConstants.logger.isDebugEnabled()) {
                object3 = enumeration.nextElement();
                fConstants.logger.debug("Loaded Certificate " + (String)object3);
            }
            object3 = this.loadSecureRandom(fBaseSSLConfig2.getRandomAlgorithm(), fBaseSSLConfig2.getRandomProvider());
            sSLContext.init(((KeyManagerFactory)object2).getKeyManagers(), ((TrustManagerFactory)object).getTrustManagers(), (SecureRandom)object3);
            fBaseSSLConfig2.getCertRequired();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fConstants.logger.fatal("Algorithm not raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(noSuchAlgorithmException);
            throw new IOException("No such algorithm found : " + fNSSContext.getMessage(noSuchAlgorithmException));
        }
        catch (KeyStoreException keyStoreException) {
            fConstants.logger.fatal("KeyStore Exception raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(keyStoreException);
            throw new IOException("Keystore Exception : " + fNSSContext.getMessage(keyStoreException));
        }
        catch (KeyManagementException keyManagementException) {
            fConstants.logger.fatal("KeyManagement Exception raised during truststore keystore load <" + fBaseSSLConfig2.getTrustStore() + ">");
            fConstants.logger.fatal(keyManagementException);
            throw new IOException("KeyManagement Exception : " + fNSSContext.getMessage(keyManagementException));
        }
        return sSLContext;
    }

    @Override
    public SecureRandom loadSecureRandom(String string, String string2) {
        SecureRandom secureRandom = null;
        if (string != null && string.length() > 1) {
            try {
                if (string2 != null) {
                    secureRandom = SecureRandom.getInstance(string, string2);
                    if (fConstants.logger.isDebugEnabled()) {
                        fConstants.logger.debug("Using secure random generator algoritm : " + string + " provided by " + string2);
                    }
                } else {
                    secureRandom = SecureRandom.getInstance(string);
                    if (fConstants.logger.isDebugEnabled()) {
                        fConstants.logger.debug("Using secure random generator algoritm : " + string);
                    }
                }
            }
            catch (Exception exception) {
                fConstants.logger.log("Unable to load secure random generator algoritm : " + string + " using default");
            }
        } else if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Using default SecureRandom generator");
        }
        return secureRandom;
    }

    private static String getMessage(Exception exception) {
        if (exception != null) {
            if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                return exception.getMessage();
            }
            return exception.getClass().toString();
        }
        return "Unknown exception raised, is Null";
    }
}

