/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.jdk.v1_7;

import com.pcbsys.foundation.drivers.jdk.fDefaultFileSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class fFileSupportImpl
extends fDefaultFileSupport {
    @Override
    public void renameFile(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File to rename must not be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File to rename must not be a directory");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("File to rename to must not be null");
        }
        try {
            this.renameFileJava7(file, file2, bl);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            fFileSupportImpl.log("Failed to rename file " + file + " to file " + file2 + " using Java NIO API, falling back to standard rename", exception);
            super.renameFile(file, file2, bl);
            return;
        }
    }

    public void renameFileJava7(File file, File file2, boolean bl) throws IOException {
        if (file2.exists() && !bl) {
            throw new IOException("Failed to rename file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + ". New file " + file2.getAbsolutePath() + " exists and replaceExisting is false");
        }
        try {
            Files.move(file.toPath(), file2.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException iOException) {
            fFileSupportImpl.log("Failed to rename file " + file + " to file " + file2 + " using atomic move, falling back to non-atomic", iOException);
            if (bl) {
                Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.move(file.toPath(), file2.toPath(), new CopyOption[0]);
        }
    }
}

