/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.client;

import com.pcbsys.foundation.drivers.multicast.client.fBufferStreamHandler;
import com.pcbsys.foundation.drivers.multicast.client.fBufferSynchronisation;
import com.pcbsys.foundation.drivers.multicast.fBuffer;
import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import java.util.BitSet;

public class fBufferManager {
    private final fBufferStreamHandler myStream;
    private final fBufferSynchronisation myListener;
    private final int myBacklogSize;
    private long myExpectedId;
    private long myBufferIdx;
    private long myMaxId;
    private long myLatestMulticastedId;
    private int myBufSize;
    private int myMissedBuffers;
    private int myDuplicateBuffers;
    private int myReceivedBuffers;
    private boolean inSync;
    private boolean isClosed;
    private fBuffer[] myArray;

    public fBufferManager(fBufferStreamHandler fBufferStreamHandler2, fBufferSynchronisation fBufferSynchronisation2, int n) {
        this.myStream = fBufferStreamHandler2;
        this.myListener = fBufferSynchronisation2;
        this.inSync = false;
        this.myMaxId = -1L;
        this.myLatestMulticastedId = -1L;
        this.myMissedBuffers = 0;
        this.myDuplicateBuffers = 0;
        this.myExpectedId = -1L;
        this.myArray = null;
        this.myBufSize = 0;
        this.myReceivedBuffers = 0;
        this.myBufferIdx = -1L;
        this.myBacklogSize = n;
        this.isClosed = false;
    }

    protected synchronized void reset() {
        this.inSync = false;
        this.myMaxId = -1L;
        this.myLatestMulticastedId = -1L;
        this.myMissedBuffers = 0;
        this.myDuplicateBuffers = 0;
        this.myExpectedId = -1L;
        this.myArray = null;
        this.myBufSize = 0;
        this.myReceivedBuffers = 0;
        this.myBufferIdx = -1L;
        this.myListener.reset();
    }

    protected synchronized long getExpectedId() {
        return this.myExpectedId;
    }

    protected synchronized long getMissingOffset() {
        if (this.myArray != null && this.myArray[0] == null) {
            fBuffer[] fBufferArray = this.myArray;
            this.myArray = new fBuffer[this.myBacklogSize];
            int n = (int)(this.myExpectedId - this.myBufferIdx);
            System.arraycopy(fBufferArray, n, this.myArray, 0, fBufferArray.length - n);
            this.myBufferIdx = this.myExpectedId;
            this.myBufSize = 0;
            for (fBuffer fBuffer2 : this.myArray) {
                if (fBuffer2 == null) continue;
                ++this.myBufSize;
            }
            if (this.myBufSize == 0) {
                this.myBufferIdx = -1L;
                this.myArray = null;
            }
        }
        if (this.myBufferIdx == -1L && this.myExpectedId <= this.myLatestMulticastedId) {
            return this.myExpectedId;
        }
        return this.myBufferIdx;
    }

    protected synchronized BitSet getMissing() {
        if (this.isClosed) {
            return null;
        }
        if (this.myArray == null) {
            if (this.myExpectedId == this.myLatestMulticastedId) {
                BitSet bitSet = new BitSet(this.myBacklogSize);
                bitSet.set(0);
                return bitSet;
            }
            this.myArray = new fBuffer[this.myBacklogSize];
            this.myBufferIdx = this.myExpectedId;
            this.myBufSize = 0;
            if (this.myExpectedId < this.myLatestMulticastedId) {
                this.myBufSize = (int)(this.myLatestMulticastedId - this.myExpectedId);
            }
        }
        BitSet bitSet = new BitSet(this.myArray.length);
        bitSet.set(0);
        int n = (int)(this.myExpectedId - this.myBufferIdx);
        int n2 = (int)(this.myMaxId - this.myBufferIdx);
        if (n2 == -1) {
            n2 = (int)(this.myLatestMulticastedId - this.myBufferIdx) + 1;
        }
        int n3 = 0;
        while (n3 < this.myBufSize && n < this.myArray.length && n < n2) {
            if (this.myArray[n] == null) {
                bitSet.set(n);
            } else {
                ++n3;
            }
            ++n;
        }
        return bitSet;
    }

    public int getQueueSize() {
        return this.myStream.getBufferSize();
    }

    protected synchronized boolean isMissingPacket() {
        if (this.myLatestMulticastedId == -1L || this.myExpectedId == -1L) {
            return false;
        }
        if (this.myArray != null) {
            if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("Missing Packet because myArray != null");
            }
            return true;
        }
        if (this.myExpectedId < this.myLatestMulticastedId && fMulticastConstants.sDebug) {
            fMulticastConstants.log("Expected : " + this.myExpectedId + " " + this.myLatestMulticastedId);
        }
        return this.myExpectedId <= this.myLatestMulticastedId;
    }

    protected synchronized void pushNoWait(fBuffer fBuffer2) {
        ++this.myReceivedBuffers;
        this.myLatestMulticastedId = fBuffer2.getId();
        if (fBuffer2.getId() > this.myMaxId) {
            this.myMaxId = fBuffer2.getId();
        }
        this.myExpectedId = fBuffer2.getId() + 1L;
        this.myStream.push(fBuffer2);
        if (!this.inSync) {
            this.inSync = true;
            this.myListener.buffersInSync();
        }
    }

    protected synchronized void push(fBuffer fBuffer2) {
        if (this.isClosed) {
            return;
        }
        ++this.myReceivedBuffers;
        if (this.myExpectedId == -1L) {
            this.myExpectedId = fBuffer2.getId();
        }
        this.myLatestMulticastedId = fBuffer2.getId();
        if (fBuffer2.getId() == this.myExpectedId - 1L && !this.inSync) {
            this.inSync = true;
            this.myListener.buffersInSync();
        } else if (fBuffer2.getId() < this.myExpectedId) {
            ++this.myDuplicateBuffers;
        } else if (this.myArray != null) {
            if (fBuffer2.getId() > this.myMaxId) {
                this.myMaxId = fBuffer2.getId();
            }
            if (fBuffer2.getId() == this.myExpectedId) {
                while (fBuffer2 != null) {
                    this.myStream.push(fBuffer2);
                    ++this.myExpectedId;
                    fBuffer2 = this.lookup(this.myExpectedId);
                }
                if (this.myBufSize != 0) {
                    fBuffer[] fBufferArray = this.myArray;
                    this.myArray = new fBuffer[this.myBacklogSize];
                    int n = (int)(this.myExpectedId - this.myBufferIdx);
                    System.arraycopy(fBufferArray, n, this.myArray, 0, fBufferArray.length - n);
                    this.myBufferIdx = this.myExpectedId;
                }
            } else {
                this.store(fBuffer2);
            }
        } else {
            if (fBuffer2.getId() > this.myMaxId) {
                this.myMaxId = fBuffer2.getId();
            }
            if (fBuffer2.getId() == this.myExpectedId) {
                ++this.myExpectedId;
                this.myStream.push(fBuffer2);
                if (!this.inSync) {
                    this.inSync = true;
                    this.myListener.buffersInSync();
                }
            } else if (fBuffer2.getId() > this.myExpectedId) {
                this.store(fBuffer2);
            }
        }
    }

    private void store(fBuffer fBuffer2) {
        int n;
        if (this.myArray == null) {
            this.myArray = new fBuffer[this.myBacklogSize];
            this.myBufferIdx = this.myExpectedId;
            this.myBufSize = 0;
        }
        if ((n = (int)fBuffer2.getId() - (int)this.myBufferIdx) >= this.myArray.length) {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < this.myArray.length; ++n2) {
                if (this.myArray[n2] == null) continue;
                if (this.myArray[n2].getId() < this.myExpectedId) {
                    this.myArray[n2] = null;
                    continue;
                }
                if (this.myArray[n2].getId() == this.myExpectedId) {
                    if (fMulticastConstants.sDebug) {
                        fMulticastConstants.log("Found expected Event at " + n2 + " rebuilding store....");
                    }
                    ++this.myExpectedId;
                    this.myStream.push(this.myArray[n2]);
                    this.myArray[n2] = null;
                    continue;
                }
                bl = true;
            }
            if (!bl) {
                this.myArray = new fBuffer[this.myBacklogSize];
                this.myBufferIdx = this.myExpectedId;
                this.myBufSize = 0;
            }
            n2 = 0;
            for (int i = 0; i < this.myArray.length; ++i) {
                if (this.myArray[i] == null) continue;
                if (fMulticastConstants.sDebug) {
                    fMulticastConstants.log("ID: " + this.myArray[i].getId() + " at " + i);
                }
                n2 = 1;
            }
            if (n2 == 0) {
                if (fMulticastConstants.sDebug) {
                    fMulticastConstants.log("Resetting store...");
                }
                this.myBufferIdx = this.myExpectedId;
                this.myBufSize = 0;
                n = 0;
            } else {
                if (fMulticastConstants.sDebug) {
                    fMulticastConstants.log("Pulling Pin");
                }
                this.myStream.bufferOverRun();
                this.reset();
                return;
            }
        }
        if (n < 0) {
            if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("Index less then 0 " + n);
            }
            return;
        }
        if (this.myArray[n] == null) {
            ++this.myBufSize;
            this.myArray[n] = fBuffer2;
        }
    }

    private fBuffer lookup(long l) {
        if (this.myArray != null) {
            int n = (int)l - (int)this.myBufferIdx;
            if (n >= this.myArray.length) {
                this.myArray = null;
                return null;
            }
            fBuffer fBuffer2 = this.myArray[n];
            if (fBuffer2 != null) {
                this.myArray[n] = null;
                --this.myBufSize;
                if (this.myBufSize == 0) {
                    this.myArray = null;
                    this.myBufferIdx = -1L;
                }
            } else {
                ++this.myMissedBuffers;
            }
            return fBuffer2;
        }
        return null;
    }

    public long getLatestBufferId() {
        return this.myLatestMulticastedId;
    }

    public void setLatestBufferId(long l) {
        this.myLatestMulticastedId = l;
    }

    public int getMissedBuffers() {
        return this.myMissedBuffers;
    }

    public int getDuplicateBuffers() {
        return this.myDuplicateBuffers;
    }

    public int getReceivedBuffers() {
        return this.myReceivedBuffers;
    }

    public void close() {
        this.isClosed = true;
        if (this.myArray != null) {
            this.myArray = null;
        }
    }
}

