/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.client;

import com.pcbsys.foundation.drivers.configuration.fMulticastConfig;
import com.pcbsys.foundation.drivers.multicast.client.fBufferManager;
import com.pcbsys.foundation.drivers.multicast.client.fMissingPacketTask;
import com.pcbsys.foundation.drivers.multicast.client.fMulticastReceiverManager;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;

public class fLastBufferMonitorTask
extends fScheduledTask {
    private final fBufferManager myBuffers;
    private final fMulticastReceiverManager myManager;
    private final fMissingPacketTask myMissingPacketTask;
    private final fMulticastConfig myConfig;
    private final boolean mySendAck;
    private long myAck = 0L;
    private long forceAckCount;
    private long myTimer;
    private boolean isQueued = true;

    public fLastBufferMonitorTask(fMulticastReceiverManager fMulticastReceiverManager2, fBufferManager fBufferManager2, fMissingPacketTask fMissingPacketTask2, fMulticastConfig fMulticastConfig2) {
        this.myConfig = fMulticastConfig2;
        this.myBuffers = fBufferManager2;
        this.myManager = fMulticastReceiverManager2;
        this.myMissingPacketTask = fMissingPacketTask2;
        this.myTimer = this.myConfig.getKeepAliveTime();
        this.forceAckCount = this.myConfig.getAckWindowSize() - this.myConfig.getAckWindowSize() / 3;
        this.mySendAck = this.myConfig.getMode() == 0;
        fThreadScheduler.getInstance().addTask(this, this.myTimer);
    }

    public void close() {
        this.isQueued = false;
        fThreadScheduler.getInstance().delTask(this);
    }

    public boolean sendAck() {
        return this.sendAck(false);
    }

    public synchronized boolean sendAck(boolean bl) {
        if (this.mySendAck && (bl || this.myBuffers.getQueueSize() < this.myConfig.getMaxOutstandingPackets() && this.myAck != this.myBuffers.getExpectedId() && this.isQueued)) {
            this.myAck = this.myBuffers.getExpectedId();
            this.myManager.sendAck(this.myAck);
            return true;
        }
        return false;
    }

    public void checkAck() {
        long l = this.myBuffers.getExpectedId() - this.myAck;
        if (l > this.forceAckCount) {
            this.sendAck(true);
        }
    }

    @Override
    public long reSchedule() {
        if (this.isQueued) {
            return this.myTimer;
        }
        return -1L;
    }

    @Override
    public void execute() {
        try {
            if (!this.isQueued) {
                return;
            }
            if (!this.sendAck()) {
                this.myTimer = this.myConfig.getKeepAliveTime();
                if (this.myBuffers.isMissingPacket()) {
                    this.myMissingPacketTask.queue();
                }
            } else {
                this.myTimer = this.myBuffers.getQueueSize() < this.myConfig.getMaxOutstandingPackets() ? (long)this.myConfig.getKeepAliveTime() : 10L;
            }
            if (this.myBuffers.isMissingPacket()) {
                this.myMissingPacketTask.queue();
            }
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }
}

