/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.client;

import com.pcbsys.foundation.drivers.multicast.client.fBufferManager;
import com.pcbsys.foundation.drivers.multicast.client.fMulticastReceiverManager;
import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import java.util.BitSet;

public class fMissingPacketTask
implements fTask {
    private fMulticastReceiverManager myManager;
    private final fBufferManager myBuffers;
    private boolean isQueued;
    private boolean isClosed;
    private boolean completed;
    private long myMissingOffset;
    private BitSet myMap;

    public fMissingPacketTask(fMulticastReceiverManager fMulticastReceiverManager2, fBufferManager fBufferManager2) {
        this.myManager = fMulticastReceiverManager2;
        this.myBuffers = fBufferManager2;
        this.isQueued = false;
        this.isClosed = false;
        this.completed = true;
        this.myMissingOffset = -1L;
        this.myMap = null;
    }

    public boolean isQueued() {
        return this.isQueued;
    }

    public void close() {
        this.isClosed = true;
    }

    public synchronized void completed() {
        if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("Recovery completed...Queued:" + this.isQueued);
        }
        this.completed = true;
        this.myMap = null;
        this.myMissingOffset = 0L;
    }

    public synchronized boolean queue() {
        if (!this.isQueued && !this.isClosed && this.completed) {
            this.isQueued = true;
            if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("Queueing missing event task");
            }
            fThreadPool.getWritePool().addTask(this);
            return this.isQueued;
        }
        if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("Already running isQueued:" + this.isQueued + " Completed:" + this.completed);
        }
        return false;
    }

    @Override
    public synchronized boolean reQueue() {
        this.isQueued = false;
        if (this.completed) {
            if (this.myBuffers.isMissingPacket() && this.myBuffers.getMissingOffset() >= 0L) {
                this.isQueued = true;
            } else if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("No missing packets detected.. not queuing");
            }
        } else if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("Requeue but not yet completed");
        }
        return this.isQueued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.completed = true;
        if (!this.isClosed && this.myBuffers.isMissingPacket()) {
            try {
                fBufferManager fBufferManager2 = this.myBuffers;
                synchronized (fBufferManager2) {
                    BitSet bitSet;
                    long l = this.myBuffers.getMissingOffset();
                    if (l < 0L) {
                        return;
                    }
                    if (!(l < 0L && this.myBuffers.getExpectedId() > this.myBuffers.getLatestBufferId() || (bitSet = this.myBuffers.getMissing()) == null || bitSet.isEmpty() || this.myMissingOffset == this.myBuffers.getExpectedId() && this.myMap.equals(bitSet))) {
                        if (fMulticastConstants.sDebug) {
                            fMulticastConstants.log("Requesting missing packets from " + this.myBuffers.getExpectedId() + " " + bitSet.toString());
                        }
                        this.completed = false;
                        this.myManager.missingPacket(l, bitSet);
                        this.myMissingOffset = this.myBuffers.getExpectedId();
                        this.myMap = bitSet;
                    }
                }
            }
            catch (Throwable throwable) {
                fConstants.logger.warn(throwable);
            }
        } else if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("No Missing events detected all should be uptodate expected ; " + this.myBuffers.getExpectedId() + " ");
        }
    }
}

