/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.client;

import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.multicast.changeKeyInfo;
import com.pcbsys.foundation.drivers.multicast.client.fBufferStreamHandler;
import com.pcbsys.foundation.drivers.multicast.client.fMulticastReceiverManager;
import com.pcbsys.foundation.drivers.multicast.crypto.fBufferDecoder;
import com.pcbsys.foundation.drivers.multicast.fBuffer;
import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fByteArrayQueueInputStream;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.threads.fTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.crypto.BadPaddingException;

public class fMulticastInputStream
implements fTask,
fBufferStreamHandler {
    protected final LinkedList myProcessQueue;
    private final fMulticastReceiverManager myManager;
    private final fAsyncReadListener myListener;
    private final fByteArrayQueueInputStream myIn = new fByteArrayQueueInputStream();
    private final fBufferDecoder myDecoder;
    private boolean isQueued;
    private boolean isLocked;
    private boolean isClosed;
    private LinkedList<changeKeyInfo> rollingCodes;

    public fMulticastInputStream(fMulticastReceiverManager fMulticastReceiverManager2, fBufferDecoder fBufferDecoder2, fAsyncReadListener fAsyncReadListener2) throws IOException {
        this.myListener = fAsyncReadListener2;
        this.myProcessQueue = new LinkedList();
        this.myManager = fMulticastReceiverManager2;
        this.isQueued = false;
        this.isLocked = false;
        this.isClosed = false;
        this.myDecoder = fBufferDecoder2;
        this.rollingCodes = new LinkedList();
    }

    @Override
    public synchronized void push(fBuffer fBuffer2) {
        byte[] byArray = fBuffer2.getData();
        if (this.myDecoder != null) {
            try {
                if (this.rollingCodes.size() > 0) {
                    long l = this.rollingCodes.getFirst().getMyChangekeyAt();
                    if (fBuffer2.getId() != -1L && l != 0L && fBuffer2.getId() == l) {
                        this.changeEncodingKey();
                    }
                }
                byArray = this.myDecoder.decode(fBuffer2.getId(), byArray, byArray.length);
                fBuffer2.setData(byArray);
            }
            catch (Exception exception) {
                if (exception instanceof BadPaddingException) {
                    fConstants.logger.error("Bad AES Decryption key");
                }
                fConstants.logger.error(exception);
            }
        }
        if (fBuffer2.getData().length != 0) {
            this.handleCompleteMessage(fBuffer2);
        }
    }

    protected void handleCompleteMessage(fBuffer fBuffer2) {
        byte[] byArray = fBuffer2.getData();
        if (!this.isLocked) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 8 || i + 5 > byArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < fMulticastConstants.sMyMarker.length; ++j) {
                    if (byArray[i + j] == fMulticastConstants.sMyMarker[j]) continue;
                    bl = false;
                }
                if (!bl) continue;
                byte[] byArray2 = fMemoryManager.getInstance().allocateBuffer(byArray.length - (i + 5));
                System.arraycopy(byArray, i + 5, byArray2, 0, byArray2.length);
                byArray = byArray2;
                this.isLocked = true;
                break;
            }
            if (!this.isLocked) {
                return;
            }
        }
        this.myIn.push(byArray);
        try {
            this.myListener.dataReady();
        }
        catch (IOException iOException) {
            fConstants.logger.warn(iOException);
        }
    }

    @Override
    public int getBufferSize() {
        return this.myIn.getQueueSize();
    }

    @Override
    public void bufferOverRun() {
        this.reset();
    }

    protected void reset() {
        this.isLocked = false;
        if (this.myListener != null) {
            this.myListener.close();
        }
        this.myManager.receivedReset();
    }

    public InputStream getInputStream() {
        return this.myIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this.myIn.isClosed()) {
            try {
                this.myListener.close();
            }
            catch (Exception exception) {
                fConstants.logger.warn(exception);
            }
        }
        if (this.isClosed) {
            return;
        }
        while (this.myProcessQueue.size() != 0) {
            byte[] byArray;
            Object object = this;
            synchronized (object) {
                if (this.myProcessQueue.size() == 0) {
                    return;
                }
                byArray = (byte[])this.myProcessQueue.removeFirst();
            }
            if (byArray == null) continue;
            try {
                object = this.myIn;
                synchronized (object) {
                    this.myIn.push(byArray);
                }
                this.myListener.dataReady();
                byArray = null;
            }
            catch (Exception exception) {
                fConstants.logger.warn(exception);
            }
        }
    }

    @Override
    public synchronized boolean reQueue() {
        if (this.isClosed) {
            return false;
        }
        this.isQueued = this.myProcessQueue.size() != 0;
        return this.isQueued;
    }

    public void changeEncodingKey(long l, byte[] byArray, byte[] byArray2) {
        this.rollingCodes.addLast(new changeKeyInfo(l, byArray, byArray2));
    }

    private void changeEncodingKey() {
        try {
            changeKeyInfo changeKeyInfo2 = this.rollingCodes.removeFirst();
            this.myDecoder.changeKey(changeKeyInfo2.getMyNewKey(), changeKeyInfo2.getCookie());
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }

    public void close() {
        try {
            this.isClosed = true;
            this.myProcessQueue.clear();
            this.rollingCodes.clear();
            this.rollingCodes = null;
            this.myIn.close();
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }
}

