/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.client;

import com.pcbsys.foundation.drivers.configuration.fMulticastConfig;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.multicast.client.fBufferManager;
import com.pcbsys.foundation.drivers.multicast.client.fBufferSynchronisation;
import com.pcbsys.foundation.drivers.multicast.client.fLastBufferMonitorTask;
import com.pcbsys.foundation.drivers.multicast.client.fMissingPacketTask;
import com.pcbsys.foundation.drivers.multicast.client.fMulticastInputStream;
import com.pcbsys.foundation.drivers.multicast.client.fMulticastReceiverManager;
import com.pcbsys.foundation.drivers.multicast.crypto.fBufferDecoder;
import com.pcbsys.foundation.drivers.multicast.crypto.fCryptoHelper;
import com.pcbsys.foundation.drivers.multicast.crypto.fDigest;
import com.pcbsys.foundation.drivers.multicast.fBuffer;
import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.threads.fThread;
import com.pcbsys.foundation.utils.fResolveLocalInterface;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;

public class fMulticastReceiver
extends fThread {
    private final DatagramSocket myMulticast;
    private final String myName;
    private final short myStreamId;
    private final fMissingPacketTask myMissingPacketTask;
    private final fLastBufferMonitorTask lastBufferIn;
    private final fMulticastReceiverManager myManager;
    private final fMulticastInputStream myIn;
    private final fBufferManager myBuffers;
    private final fMulticastConfig myConfig;
    private final SocketAddress mySource;
    private final boolean sendAck;
    private final boolean broadcastMode;
    private fDigest myDigest;
    private long bytesReceived;
    private boolean isRunning;

    public fMulticastReceiver(short s, fMulticastConfig fMulticastConfig2, fMulticastReceiverManager fMulticastReceiverManager2, byte[] byArray, fAsyncReadListener fAsyncReadListener2, fBufferSynchronisation fBufferSynchronisation2, byte[] byArray2, fDriver fDriver2) throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        Object object;
        this.myConfig = fMulticastConfig2;
        this.myName = this.myConfig.getMulticastAddress() + ":" + this.myConfig.getActivePort() + ":" + s;
        this.myStreamId = s;
        this.myManager = fMulticastReceiverManager2;
        this.setDaemon(true);
        this.setName("PacketReader:" + this.myName);
        this.isRunning = true;
        InetAddress inetAddress = InetAddress.getByName(this.myConfig.getMulticastAddress());
        NetworkInterface networkInterface = null;
        if (this.myConfig.getLocalBindingAdapter() != null) {
            try {
                networkInterface = fResolveLocalInterface.resolveLocalInterface(this.myConfig.getLocalBindingAdapter(), inetAddress instanceof Inet6Address);
            }
            catch (Exception exception) {
                if (fMulticastConstants.sDebug) {
                    fMulticastConstants.log("Could not find Binding adapter: " + this.myConfig.getLocalBindingAdapter());
                }
            }
        } else {
            networkInterface = fResolveLocalInterface.resolveLocalInterface(fDriver2, inetAddress instanceof Inet6Address);
        }
        if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("Binding multicast adapter to " + (networkInterface != null ? networkInterface.toString() : "Null"));
        }
        if (inetAddress.isMulticastAddress()) {
            object = new MulticastSocket(this.myConfig.getActivePort());
            if (networkInterface != null) {
                ((MulticastSocket)object).setNetworkInterface(networkInterface);
            }
            ((MulticastSocket)object).joinGroup(inetAddress);
            this.myMulticast = object;
        } else {
            this.myMulticast = new DatagramSocket(this.myConfig.getActivePort());
        }
        this.myMulticast.setTrafficClass(fMulticastConfig2.getQOS());
        this.myMulticast.setReceiveBufferSize(this.myConfig.getAdapeterBufferSize());
        if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("Set receive buffer size to " + this.myConfig.getAdapeterBufferSize());
        }
        this.mySource = new InetSocketAddress(this.myConfig.getBindingAdapter(), this.myConfig.getActivePort());
        object = fCryptoHelper.getDecoder(fMulticastConfig.sEncryptionType[this.myConfig.getEncryptionLevel()], byArray, byArray2);
        this.myIn = new fMulticastInputStream(fMulticastReceiverManager2, (fBufferDecoder)object, fAsyncReadListener2);
        this.myBuffers = new fBufferManager(this.myIn, fBufferSynchronisation2, this.myConfig.getOutstandingPacketsQueueSize());
        this.myMissingPacketTask = new fMissingPacketTask(this.myManager, this.myBuffers);
        if (this.myConfig.getMode() != 2) {
            this.sendAck = this.myConfig.getMode() == 0;
            this.lastBufferIn = new fLastBufferMonitorTask(this.myManager, this.myBuffers, this.myMissingPacketTask, this.myConfig);
            this.broadcastMode = false;
        } else {
            this.sendAck = false;
            this.lastBufferIn = null;
            this.broadcastMode = true;
        }
        this.start();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isRunning = false;
        this.myMulticast.close();
        fMulticastReceiver fMulticastReceiver2 = this;
        synchronized (fMulticastReceiver2) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                fConstants.logger.warn(interruptedException);
            }
        }
        this.myBuffers.close();
        if (this.lastBufferIn != null) {
            this.lastBufferIn.close();
        }
        this.myMissingPacketTask.close();
        this.myIn.close();
    }

    public InputStream getInputStream() {
        return this.myIn.getInputStream();
    }

    public void changeEncodingKey(long l, byte[] byArray, byte[] byArray2) {
        this.myIn.changeEncodingKey(l, byArray, byArray2);
    }

    public void setCRCSessionCookie(fDigest fDigest2) {
        this.myDigest = fDigest2;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public void recoveryComplete() {
        if (this.lastBufferIn != null) {
            this.lastBufferIn.sendAck();
        }
        this.myMissingPacketTask.completed();
        this.scanForMissingEvents();
    }

    private void scanForMissingEvents() {
        if (this.myBuffers.isMissingPacket()) {
            if (this.myMissingPacketTask.queue()) {
                if (fMulticastConstants.sDebug) {
                    fMulticastConstants.log("Rescan has found missed events has queued task");
                }
            } else if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("Rescan has found missed but task is not queued");
            }
        } else if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("Rescan has found no missed events registered...");
        }
    }

    public void pushToBuffer(fBuffer fBuffer2) {
        this.myBuffers.push(fBuffer2);
    }

    public short getStreamId() {
        return this.myStreamId;
    }

    public void setLastBroadcastMessage(long l) {
        this.myBuffers.setLatestBufferId(l);
    }

    public int getReceivedBuffers() {
        return this.myBuffers.getReceivedBuffers();
    }

    public int getMissedBuffers() {
        return this.myBuffers.getMissedBuffers();
    }

    public int getDuplicateBuffers() {
        return this.myBuffers.getDuplicateBuffers();
    }

    public int getQueueSize() {
        return this.myBuffers.getQueueSize();
    }

    private void processPacket(fBuffer fBuffer2, InetAddress inetAddress) {
        if (!this.isRunning) {
            return;
        }
        if (fBuffer2.getId() == -1L) {
            this.myManager.receivedReset();
            this.myManager.bindingToServer(inetAddress);
            this.myIn.reset();
            this.myBuffers.reset();
            return;
        }
        if (fBuffer2.getId() == -2L) {
            this.setLastBroadcastMessage(fBuffer2.getKeepAliveId());
        } else {
            this.bytesReceived += (long)fBuffer2.getData().length;
            if (this.broadcastMode) {
                this.myBuffers.pushNoWait(fBuffer2);
            } else {
                this.myBuffers.push(fBuffer2);
            }
        }
        if (this.myBuffers.isMissingPacket()) {
            this.myMissingPacketTask.queue();
        } else if (this.sendAck) {
            this.lastBufferIn.checkAck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        this.setPriority(10);
        byte[] byArray = fMemoryManager.getInstance().allocateBuffer(this.myConfig.getPacketSize() + 100);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        while (this.isRunning) {
            try {
                this.myMulticast.receive(datagramPacket);
                if (!datagramPacket.getSocketAddress().equals(this.mySource)) continue;
                object = new fBuffer(datagramPacket.getData(), datagramPacket.getLength(), this.myDigest);
                this.processPacket((fBuffer)object, datagramPacket.getAddress());
            }
            catch (IOException iOException) {
                fConstants.logger.warn(iOException);
            }
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }
}

