/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.crypto;

import com.pcbsys.foundation.drivers.multicast.crypto.fAESDecoder;
import com.pcbsys.foundation.drivers.multicast.crypto.fAESEncoder;
import com.pcbsys.foundation.drivers.multicast.crypto.fBufferDecoder;
import com.pcbsys.foundation.drivers.multicast.crypto.fBufferEncoder;
import com.pcbsys.foundation.drivers.multicast.crypto.fCrc32Digest;
import com.pcbsys.foundation.drivers.multicast.crypto.fDigest;
import com.pcbsys.foundation.drivers.multicast.crypto.fMD5Digest;
import com.pcbsys.foundation.drivers.multicast.crypto.fNullDecoder;
import com.pcbsys.foundation.drivers.multicast.crypto.fNullDigest;
import com.pcbsys.foundation.drivers.multicast.crypto.fSHA1Digest;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.memory.fMemoryManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class fCryptoHelper {
    public static byte[] generateNewAESKey(int n) {
        if (n == 0) {
            return null;
        }
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(n);
            return keyGenerator.generateKey().getEncoded();
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
            return null;
        }
    }

    protected IvParameterSpec createCtrIvForAES(int n, SecureRandom secureRandom) {
        byte[] byArray = fMemoryManager.getInstance().allocateBuffer(16);
        secureRandom.nextBytes(byArray);
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)(n >> 0);
        for (int i = 0; i != 7; ++i) {
            byArray[8 + i] = 0;
        }
        byArray[15] = 1;
        return new IvParameterSpec(byArray);
    }

    protected Key produceKey(byte[] byArray, String string) {
        SecretKeySpec secretKeySpec = null;
        try {
            secretKeySpec = new SecretKeySpec(byArray, string);
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
        return secretKeySpec;
    }

    public static fBufferEncoder getEncoder(String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (string.equalsIgnoreCase("AES")) {
            return new fAESEncoder(byArray, byArray2);
        }
        return null;
    }

    public static fBufferDecoder getDecoder(String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (string.equalsIgnoreCase("AES")) {
            return new fAESDecoder(byArray, byArray2);
        }
        return new fNullDecoder();
    }

    public static fDigest getDigest(String string, byte[] byArray) throws NoSuchAlgorithmException {
        if (string.equals("SHA")) {
            return new fSHA1Digest(byArray);
        }
        if (string.equals("MD5")) {
            return new fMD5Digest(byArray);
        }
        if (string.equals("CRC")) {
            return new fCrc32Digest(byArray);
        }
        if (string.equals("NULL")) {
            return null;
        }
        return new fNullDigest(byArray);
    }
}

