/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.multicast.crypto.fDigest;
import com.pcbsys.foundation.memory.fMemoryManager;
import java.io.IOException;

public class fBuffer {
    public static final int headerSize = 8;
    private static fMemoryManager myManager = fMemoryManager.getInstance();
    private int myDataLen;
    private int myOffset;
    private long myId;
    private byte[] myData;

    public static byte[] getKeepAliveBuffer(long l, fDigest fDigest2) {
        byte[] byArray = myManager.allocateBuffer(8);
        fBuffer.packLong(l, byArray, 0);
        fBuffer fBuffer2 = new fBuffer(-2L, byArray);
        return fBuffer2.packBuffer(fDigest2);
    }

    public static byte[] getResetBuffer(fDigest fDigest2) {
        byte[] byArray = myManager.allocateBuffer(8);
        fBuffer.packLong(fTimer.getTicks(), byArray, 0);
        fBuffer fBuffer2 = new fBuffer(-1L, byArray);
        return fBuffer2.packBuffer(fDigest2);
    }

    public fBuffer() {
    }

    public fBuffer(long l, byte[] byArray) {
        this.myId = l;
        this.myData = byArray;
        this.myDataLen = this.myData.length;
        this.myOffset = 0;
    }

    public fBuffer(long l, byte[] byArray, int n, int n2) {
        this.myId = l;
        this.myData = byArray;
        this.myOffset = n;
        this.myDataLen = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public fBuffer(byte[] byArray, int n, fDigest fDigest2) throws IOException {
        this.myId = fBuffer.unpackLong(byArray, 0);
        if (n <= 7) return;
        if (fDigest2 != null) {
            if (n <= 8 + fDigest2.getLength()) throw new IOException("CRC buffer underrun");
            byte[] byArray2 = myManager.allocateBuffer(fDigest2.getLength());
            System.arraycopy(byArray, n - byArray2.length, byArray2, 0, byArray2.length);
            fDigest2.update(byArray, 0, n - byArray2.length);
            if (!fDigest2.test(byArray2)) {
                throw new IOException("CRC on packet failed");
            }
            fDigest2.reset();
            this.myData = myManager.allocateBuffer(n - (8 + byArray2.length));
            System.arraycopy(byArray, 8, this.myData, 0, this.myData.length);
            return;
        } else {
            this.myData = myManager.allocateBuffer(n - 8);
            System.arraycopy(byArray, 8, this.myData, 0, this.myData.length);
        }
    }

    public fBuffer(byte[] byArray) throws IOException {
        this.myId = fBuffer.unpackLong(byArray, 0);
        if (byArray.length > 7) {
            this.myData = myManager.allocateBuffer(byArray.length - 8);
            System.arraycopy(byArray, 8, this.myData, 0, this.myData.length);
        }
    }

    public byte[] packBuffer(fDigest fDigest2) {
        int n = fDigest2 != null ? 8 + this.myDataLen + fDigest2.getLength() : 8 + this.myDataLen;
        byte[] byArray = myManager.allocateBuffer(n);
        fBuffer.packLong(this.myId, byArray, 0);
        System.arraycopy(this.myData, this.myOffset, byArray, 8, this.myDataLen);
        if (fDigest2 != null) {
            fDigest2.update(byArray, 0, 8 + this.myDataLen);
            System.arraycopy(fDigest2.digest(), 0, byArray, 8 + this.myDataLen, fDigest2.getLength());
            fDigest2.reset();
        }
        return byArray;
    }

    public long getId() {
        return this.myId;
    }

    public byte[] getData() {
        return this.myData;
    }

    public void setData(byte[] byArray) {
        this.myData = byArray;
    }

    public long getKeepAliveId() {
        if (this.myId == -2L) {
            return fBuffer.unpackLong(this.myData, 0);
        }
        return -1L;
    }

    public void reset() {
        myManager.release(this.myData);
        this.myData = null;
        this.myDataLen = 0;
        this.myOffset = 0;
        this.myId = 0L;
    }

    public void reset(long l, byte[] byArray) {
        this.reset(l, byArray, 0, byArray.length);
    }

    public void reset(long l, byte[] byArray, int n, int n2) {
        this.myId = l;
        this.myData = byArray;
        this.myOffset = n;
        this.myDataLen = n2;
    }

    private static long unpackLong(byte[] byArray, int n) {
        long l = 0L;
        l = ((long)byArray[n] & 0xFFL) << 56 | l;
        l = ((long)byArray[n + 1] & 0xFFL) << 48 | l;
        l = ((long)byArray[n + 2] & 0xFFL) << 40 | l;
        l = ((long)byArray[n + 3] & 0xFFL) << 32 | l;
        l = ((long)byArray[n + 4] & 0xFFL) << 24 | l;
        l = ((long)byArray[n + 5] & 0xFFL) << 16 | l;
        l = ((long)byArray[n + 6] & 0xFFL) << 8 | l;
        l = (long)byArray[n + 7] & 0xFFL | l;
        return l;
    }

    private static void packLong(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 56 & 0xFFL);
        byArray[n + 1] = (byte)(l >>> 48 & 0xFFL);
        byArray[n + 2] = (byte)(l >>> 40 & 0xFFL);
        byArray[n + 3] = (byte)(l >>> 32 & 0xFFL);
        byArray[n + 4] = (byte)(l >>> 24 & 0xFFL);
        byArray[n + 5] = (byte)(l >>> 16 & 0xFFL);
        byArray[n + 6] = (byte)(l >>> 8 & 0xFFL);
        byArray[n + 7] = (byte)(l & 0xFFL);
    }
}

