/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast;

import com.pcbsys.foundation.drivers.configuration.fMulticastConfig;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.multicast.client.fBufferSynchronisation;
import com.pcbsys.foundation.drivers.multicast.client.fMulticastReceiver;
import com.pcbsys.foundation.drivers.multicast.client.fMulticastReceiverManager;
import com.pcbsys.foundation.drivers.multicast.crypto.fCryptoHelper;
import com.pcbsys.foundation.drivers.multicast.crypto.fDigest;
import com.pcbsys.foundation.drivers.multicast.fBuffer;
import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.memory.fMemoryManager;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.BitSet;

public class fMulticastClient
implements fMulticastReceiverManager,
fBufferSynchronisation {
    private final fConnection myReliableOutput;
    private final short myStreamId;
    private final fAsyncReadListener myListener;
    private final fMulticastConfig myConfig;
    private byte[] myCRCCookie;
    private fMulticastReceiver myMulticastReceiver;
    private fDigest myDigest;

    public fMulticastClient(short s, fMulticastConfig fMulticastConfig2, fConnection fConnection2, fAsyncReadListener fAsyncReadListener2) {
        this.myStreamId = s;
        this.myConfig = fMulticastConfig2;
        this.myListener = fAsyncReadListener2;
        this.myReliableOutput = fConnection2;
    }

    public String getId() {
        return this.myConfig.getMulticastAddress() + ":" + this.myConfig.getActivePort();
    }

    public int getReceived() {
        if (this.myMulticastReceiver != null) {
            return this.myMulticastReceiver.getReceivedBuffers();
        }
        return 0;
    }

    public int getMissedPackets() {
        if (this.myMulticastReceiver != null) {
            return this.myMulticastReceiver.getMissedBuffers();
        }
        return 0;
    }

    public int getDuplicatePackets() {
        if (this.myMulticastReceiver != null) {
            return this.myMulticastReceiver.getDuplicateBuffers();
        }
        return 0;
    }

    public long getBytesReceived() {
        if (this.myMulticastReceiver != null) {
            return this.myMulticastReceiver.getBytesReceived();
        }
        return 0L;
    }

    public InputStream getInputStream() {
        if (this.myMulticastReceiver != null) {
            return this.myMulticastReceiver.getInputStream();
        }
        return null;
    }

    public int getQueueSize() {
        if (this.myMulticastReceiver != null) {
            return this.myMulticastReceiver.getQueueSize();
        }
        return 0;
    }

    @Override
    public void receivedReset() {
        this.close();
    }

    @Override
    public void sendAck(long l) {
        fMulticastConstants.sendOOBPacket(this.myReliableOutput.eventOut, this.myMulticastReceiver.getStreamId(), (byte)11, l);
    }

    @Override
    public void missingPacket(long l, BitSet bitSet) {
        byte[] byArray;
        int n = 0;
        if (bitSet == null) {
            byArray = new byte[1];
        } else {
            byArray = fMemoryManager.getInstance().allocateBuffer(bitSet.length() / 8 + 1);
            for (int i = 0; i < bitSet.length(); ++i) {
                if (!bitSet.get(i)) continue;
                ++n;
                int n2 = byArray.length - i / 8 - 1;
                byArray[n2] = (byte)(byArray[n2] | 1 << i % 8);
            }
        }
        fMulticastConstants.log("Missing packets from " + l + " No." + n);
        fMulticastConstants.sendOOBPacket(this.myReliableOutput.eventOut, this.myMulticastReceiver.getStreamId(), (byte)2, l, byArray);
    }

    @Override
    public void bindingToServer(InetAddress inetAddress) {
    }

    public void readOOBMessage(fConnection fConnection2, short s) {
        try {
            fEventInputStream fEventInputStream2 = fConnection2.getInputStream();
            byte by = fEventInputStream2.readByte();
            switch (by) {
                case 0: {
                    fConnection2.close();
                    break;
                }
                case 1: {
                    byte[] byArray = fEventInputStream2.readByteArray();
                    fBuffer fBuffer2 = new fBuffer(byArray);
                    this.myMulticastReceiver.pushToBuffer(fBuffer2);
                    break;
                }
                case 2: {
                    fEventInputStream2.readLong();
                    fEventInputStream2.readByteArray();
                    break;
                }
                case 7: {
                    long l = fEventInputStream2.readLong();
                    byte[] byArray = fEventInputStream2.readByteArray();
                    if (this.myMulticastReceiver == null) {
                        this.myMulticastReceiver = new fMulticastReceiver(this.myStreamId, this.myConfig, this, byArray, this.myListener, this, this.myCRCCookie, this.myReliableOutput.getDriver());
                        this.myMulticastReceiver.setCRCSessionCookie(this.myDigest);
                        break;
                    }
                    this.myMulticastReceiver.changeEncodingKey(l, byArray, this.myCRCCookie);
                    break;
                }
                case 8: {
                    this.myCRCCookie = fEventInputStream2.readByteArray();
                    this.myDigest = fCryptoHelper.getDigest(fEventInputStream2.readString(), this.myCRCCookie);
                    if (this.myMulticastReceiver != null) {
                        this.myMulticastReceiver.setCRCSessionCookie(this.myDigest);
                    }
                    break;
                }
                case 9: {
                    this.myMulticastReceiver.setLastBroadcastMessage(fEventInputStream2.readLong());
                    break;
                }
                case 10: {
                    if (fMulticastConstants.sDebug) {
                        fMulticastConstants.log("Missing packet completed received from master,... rescanning");
                    }
                    this.myMulticastReceiver.recoveryComplete();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    this.close();
                    break;
                }
            }
        }
        catch (Exception exception) {
            fConstants.logger.fatal(exception);
            fConnection2.close();
        }
    }

    protected void close() {
        if (this.myMulticastReceiver != null) {
            this.removeOOBHandler();
            this.myMulticastReceiver.close();
            this.myMulticastReceiver = null;
        }
    }

    @Override
    public void buffersInSync() {
        fMulticastConstants.sendOOBPacket(this.myReliableOutput.eventOut, this.myMulticastReceiver.getStreamId(), (byte)3, null);
    }

    @Override
    public void reset() {
        this.close();
    }

    public void removeOOBHandler() {
        fMulticastConstants.sendOOBPacket(this.myReliableOutput.eventOut, this.myMulticastReceiver.getStreamId(), (byte)6, null);
    }

    public void sendReady() {
        fMulticastConstants.sendOOBPacket(this.myReliableOutput.eventOut, this.myStreamId, (byte)5, null);
    }
}

