/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.fast.Long2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.drivers.configuration.fMulticastConfig;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.multicast.fMulticastClient;
import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import com.pcbsys.foundation.drivers.multicast.server.fMulticastServer;
import com.pcbsys.foundation.drivers.multicast.server.fServerManager;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fOutOfBandEventHandler;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import javax.crypto.NoSuchPaddingException;

public class fMulticastManager
extends fScheduledTask
implements fOutOfBandEventHandler {
    private static final fMulticastManager myManager = new fMulticastManager();
    private final Long2ObjectOpenAddressingHashMap<fMulticastServer> myServers = new Long2ObjectOpenAddressingHashMap();
    private final Long2ObjectOpenAddressingHashMap<fMulticastClient> myClients = new Long2ObjectOpenAddressingHashMap();

    private fMulticastManager() {
        fThreadScheduler.getInstance().addTask(this, 60000L);
    }

    public static fMulticastManager getInstance() {
        return myManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public fMulticastServer createStream(short s, fMulticastConfig fMulticastConfig2, String string) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IOException {
        this.deleteStream(s);
        if (this.myClients.containsKey(s)) {
            this.removeReceiver(s);
        }
        fMulticastServer fMulticastServer2 = fServerManager.getInstance().create(s, fMulticastConfig2, string);
        Long2ObjectOpenAddressingHashMap<fMulticastServer> long2ObjectOpenAddressingHashMap = this.myServers;
        synchronized (long2ObjectOpenAddressingHashMap) {
            this.myServers.put(s, fMulticastServer2);
        }
        return fMulticastServer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStream(short s) {
        try {
            fServerManager.getInstance().close(s);
            Long2ObjectOpenAddressingHashMap<fMulticastServer> long2ObjectOpenAddressingHashMap = this.myServers;
            synchronized (long2ObjectOpenAddressingHashMap) {
                this.myServers.remove(s);
            }
        }
        catch (IOException iOException) {
            fConstants.logger.warn(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(fConnection fConnection2) {
        try {
            fEventInputStream fEventInputStream2;
            fEventInputStream fEventInputStream3 = fEventInputStream2 = fConnection2.getInputStream();
            synchronized (fEventInputStream3) {
                short s = fConnection2.getInputStream().readShort();
                fMulticastClient fMulticastClient2 = this.myClients.get(s);
                if (fMulticastClient2 != null) {
                    fMulticastClient2.readOOBMessage(fConnection2, s);
                } else {
                    fMulticastServer fMulticastServer2 = this.myServers.get(s);
                    if (fMulticastServer2 != null) {
                        fMulticastServer2.readOOBMessage(fConnection2);
                    } else {
                        this.clearStream(fEventInputStream2, fConnection2);
                    }
                }
            }
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }

    public fMulticastClient createReceiver(short s, fMulticastConfig fMulticastConfig2, fConnection fConnection2, fAsyncReadListener fAsyncReadListener2) {
        this.removeReceiver(s);
        fMulticastClient fMulticastClient2 = new fMulticastClient(s, fMulticastConfig2, fConnection2, fAsyncReadListener2);
        this.myClients.put(s, fMulticastClient2);
        return fMulticastClient2;
    }

    public void removeReceiver(short s) {
        fMulticastClient fMulticastClient2 = this.myClients.remove(s);
        if (fMulticastClient2 != null) {
            fMulticastClient2.close();
        }
    }

    public Iterator<fMulticastServer> getServers() {
        return this.myServers.values().iterator();
    }

    private void clearStream(fEventInputStream fEventInputStream2, fConnection fConnection2) throws IOException {
        byte by = fEventInputStream2.readByte();
        switch (by) {
            case 0: {
                fConnection2.close();
                break;
            }
            case 1: {
                fEventInputStream2.readByteArray();
                break;
            }
            case 2: {
                fEventInputStream2.readLong();
                fEventInputStream2.readByteArray();
                break;
            }
            case 7: {
                fEventInputStream2.readLong();
                fEventInputStream2.readByteArray();
                break;
            }
            case 8: {
                fEventInputStream2.readByteArray();
                fEventInputStream2.readString();
                break;
            }
            case 9: {
                fEventInputStream2.readLong();
                break;
            }
            case 10: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
    }

    @Override
    public long reSchedule() {
        return 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this.myServers.size() > 0) {
            for (fMulticastServer fMulticastServer2 : this.myServers.values()) {
                fMulticastServer2.checkPostExecutionQueue();
                if (fMulticastServer2.isAllSynced() || fMulticastServer2.getLastWriteTime() + (long)fMulticastServer2.getConfig().getKeepAliveTime() >= fTimer.currentTimeMillis()) continue;
                try {
                    OutputStream outputStream;
                    OutputStream outputStream2 = outputStream = fMulticastServer2.getOutputStream();
                    synchronized (outputStream2) {
                        outputStream.write(fMulticastConstants.sMyMarker);
                        outputStream.flush();
                    }
                }
                catch (Exception exception) {
                    fConstants.logger.warn(exception);
                }
            }
        }
    }

    @Override
    public String getName() {
        return "Multicast Manager";
    }
}

