/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.server;

import com.pcbsys.foundation.collections.fCircularBuffer;
import com.pcbsys.foundation.collections.fCircularQueue;
import com.pcbsys.foundation.drivers.multicast.fBuffer;
import com.pcbsys.foundation.drivers.multicast.server.fBufferCacheManager;

public final class BufferMap {
    private final fCircularQueue<fBuffer> myBufferQueue;
    private long lastId;

    public BufferMap(int n, boolean bl) {
        this.myBufferQueue = new fCircularBuffer<fBuffer>(n, bl, true);
    }

    public void clear() {
        this.myBufferQueue.reset();
    }

    public fBuffer get(long l) {
        fBuffer fBuffer2 = this.getFirst();
        if (fBuffer2 != null) {
            int n = (int)(l - fBuffer2.getId());
            if (n < 0) {
                return null;
            }
            return (fBuffer)this.myBufferQueue.look(n);
        }
        return null;
    }

    public int size() {
        return this.myBufferQueue.size();
    }

    public fBuffer removeFirst() {
        return this.myBufferQueue.get();
    }

    public fBuffer getFirst() {
        return this.myBufferQueue.look();
    }

    public void add(fBuffer fBuffer2) {
        this.lastId = fBuffer2.getId();
        this.myBufferQueue.put(fBuffer2);
    }

    public void removeTo(long l) {
        while (this.myBufferQueue.size() > 0 && this.getFirst().getId() < l) {
            fBufferCacheManager.getInstance().deallocate(this.myBufferQueue.get());
        }
    }

    public long getLastId() {
        return this.lastId;
    }
}

