/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.server;

import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import com.pcbsys.foundation.drivers.multicast.server.fConnectionInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class fConnectionManager {
    private LinkedHashMap<String, fConnectionInfo> connections = new LinkedHashMap();
    private boolean isAllInSync = false;

    public void close() {
        this.connections.clear();
    }

    public boolean isAllSynced() {
        return this.isAllInSync;
    }

    public synchronized void setSyncFlag(String string, boolean bl) {
        fConnectionInfo fConnectionInfo2 = this.connections.get(string);
        if (fConnectionInfo2 != null) {
            fConnectionInfo2.setInSync(bl);
            this.isAllInSync = true;
            Iterator<fConnectionInfo> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isInSync()) continue;
                this.isAllInSync = false;
                break;
            }
        }
    }

    public synchronized void setExpectingId(String string, long l) {
        fConnectionInfo fConnectionInfo2 = this.connections.get(string);
        if (fConnectionInfo2 != null) {
            fConnectionInfo2.setExpectingId(l);
        }
    }

    public synchronized void setAck(String string, long l) {
        fConnectionInfo fConnectionInfo2 = this.connections.get(string);
        if (fConnectionInfo2 != null) {
            fConnectionInfo2.setLastAck(l);
            if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("Connection " + fConnectionInfo2.getConnection().getID() + " Acked to " + l);
            }
        }
    }

    public synchronized fConnectionInfo setOutOfBandReady(String string) {
        fConnectionInfo fConnectionInfo2 = this.connections.get(string);
        if (fConnectionInfo2 != null) {
            fConnectionInfo2.setOOBRegistered(true);
            return fConnectionInfo2;
        }
        return null;
    }

    public synchronized void resetOutOfBandReady(String string) {
        fConnectionInfo fConnectionInfo2 = this.connections.get(string);
        if (fConnectionInfo2 != null) {
            fConnectionInfo2.setOOBRegistered(false);
        }
    }

    public synchronized int add(fConnectionInfo fConnectionInfo2) {
        this.connections.put(fConnectionInfo2.getConnection().getID(), fConnectionInfo2);
        return this.connections.size();
    }

    public synchronized fConnectionInfo get(String string) {
        return this.connections.get(string);
    }

    public synchronized int del(String string) {
        this.connections.remove(string);
        return this.connections.size();
    }

    public synchronized long getLowestAck() {
        long l = Long.MAX_VALUE;
        for (fConnectionInfo fConnectionInfo2 : this.connections.values()) {
            long l2 = fConnectionInfo2.getLastAck();
            if (l2 >= l || l2 == -1L) continue;
            l = l2;
        }
        if (l == Long.MAX_VALUE) {
            l = 0L;
        }
        return l;
    }

    public synchronized void getBlockingConnections(long l, ArrayList<fConnectionInfo> arrayList) {
        for (fConnectionInfo fConnectionInfo2 : this.connections.values()) {
            if (fConnectionInfo2.getLastAck() > l) continue;
            arrayList.add(fConnectionInfo2);
        }
    }

    public Iterator<fConnectionInfo> iterator() {
        return this.connections.values().iterator();
    }

    public int size() {
        return this.connections.size();
    }
}

