/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.server;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.multicast.crypto.fDigest;
import com.pcbsys.foundation.drivers.multicast.fBuffer;
import com.pcbsys.foundation.drivers.multicast.server.fMulticastOutputStream;
import com.pcbsys.foundation.drivers.multicast.server.fMulticastServer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.net.DatagramPacket;

public class fLatestBufferID
extends fScheduledTask {
    private final fMulticastServer myServer;
    private final DatagramPacket myPacket;
    private fDigest myDigest;
    private boolean isRunning = false;

    public fLatestBufferID(fMulticastServer fMulticastServer2) {
        this.myServer = fMulticastServer2;
        byte[] byArray = new byte[]{0};
        this.myPacket = new DatagramPacket(byArray, 1, this.myServer.getGroupAddress(), this.myServer.getConfig().getActivePort());
        if (this.myServer.getDigest() != null) {
            this.myDigest = this.myServer.getDigest().getNewInstance();
        }
    }

    public synchronized void start() {
        if (!this.isRunning) {
            this.isRunning = true;
            fThreadScheduler.getInstance().addTask(this, this.myServer.getConfig().getKeepAliveTime());
        }
    }

    public synchronized void stop() {
        if (this.isRunning) {
            fThreadScheduler.getInstance().delTask(this);
            this.isRunning = false;
        }
    }

    @Override
    public long reSchedule() {
        if (this.isRunning) {
            return this.myServer.getConfig().getKeepAliveTime();
        }
        return -1L;
    }

    @Override
    public void execute() {
        try {
            if (this.myServer.getLastWriteTime() + (long)(this.myServer.getConfig().getKeepAliveTime() / 2) < fTimer.currentTimeMillis()) {
                byte[] byArray = fBuffer.getKeepAliveBuffer(((fMulticastOutputStream)this.myServer.getOutputStream()).getCurrentTXId() - 1L, this.myDigest);
                this.myPacket.setData(byArray);
                this.myPacket.setLength(byArray.length);
                this.myServer.sendPacket(this.myPacket, true);
            }
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }
}

