/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.server;

import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import com.pcbsys.foundation.drivers.multicast.server.MissedEventsStorage;
import com.pcbsys.foundation.drivers.multicast.server.fConnectionInfo;
import com.pcbsys.foundation.drivers.multicast.server.fMulticastServer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class fMissedPacketCheck
implements fTask {
    private final fMulticastServer myServer;
    private final LinkedList<MissedEventsStorage> missedPacketMap = new LinkedList();
    private final ArrayList<fConnection> myClosureList = new ArrayList();
    private boolean isQueued = false;
    private boolean isClosed = false;

    public fMissedPacketCheck(fMulticastServer fMulticastServer2) {
        this.myServer = fMulticastServer2;
    }

    public void stop() {
        this.isClosed = true;
        this.missedPacketMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void queueTask(fConnectionInfo fConnectionInfo2, MissedEventsStorage missedEventsStorage) {
        LinkedList<MissedEventsStorage> linkedList = this.missedPacketMap;
        synchronized (linkedList) {
            this.missedPacketMap.add(missedEventsStorage);
        }
        fConnectionInfo2.incrementMissedPackets(1);
        if (!this.isQueued && !this.isClosed) {
            this.isQueued = true;
            fThreadPool.getWritePool().addTask(this);
        }
    }

    @Override
    public synchronized boolean reQueue() {
        this.isQueued = this.missedPacketMap.size() != 0 && !this.isClosed;
        return this.isQueued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            if (this.missedPacketMap.size() == 0) {
                return;
            }
            fMulticastServer fMulticastServer2 = this.myServer;
            synchronized (fMulticastServer2) {
                long l;
                Object object2;
                if (this.myServer.getQueueSize() == 0) {
                    this.missedPacketMap.clear();
                    return;
                }
                LinkedHashMap<Long, LinkedList<fConnection>> object3 = new LinkedHashMap<Long, LinkedList<fConnection>>();
                ArrayList<MissedEventsStorage> arrayList = new ArrayList<MissedEventsStorage>();
                LinkedList<MissedEventsStorage> linkedList = this.missedPacketMap;
                synchronized (linkedList) {
                    for (MissedEventsStorage missedEventsStorage : this.missedPacketMap) {
                        object2 = missedEventsStorage.getBytes();
                        l = missedEventsStorage.getOffset();
                        arrayList.add(missedEventsStorage);
                        for (int i = 0; i < ((byte[])object2).length * 8; ++i) {
                            if ((object2[((Object)object2).length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
                            long l2 = l + (long)i;
                            LinkedList<fConnection> linkedList2 = (LinkedList<fConnection>)object3.get(l2);
                            if (linkedList2 == null) {
                                linkedList2 = new LinkedList<fConnection>();
                                object3.put(l2, linkedList2);
                            }
                            linkedList2.add(missedEventsStorage.getConnection());
                        }
                    }
                    this.missedPacketMap.clear();
                }
                long l3 = 0L;
                for (Object object2 : object3.entrySet()) {
                    l = (Long)object2.getKey();
                    LinkedList linkedList3 = (LinkedList)object2.getValue();
                    if (l < this.myServer.getFirstId()) {
                        this.myClosureList.addAll(linkedList3);
                        if (fMulticastConstants.sDebug) {
                            fMulticastConstants.log("<<<< Closing connection since recovery is impossible from " + l + " last stored ID = " + this.myServer.getFirstId());
                        }
                    } else {
                        fConnection fConnection2;
                        fEventOutputStream fEventOutputStream2;
                        ++l3;
                        if (linkedList3.size() > 1) {
                            this.myServer.retransmit(l, l);
                        } else if (linkedList3.size() == 1 && (fEventOutputStream2 = (fConnection2 = (fConnection)linkedList3.getFirst()).getOutputStream()) != null) {
                            this.myServer.resend(fEventOutputStream2, l);
                        }
                    }
                    linkedList3.clear();
                }
                while (arrayList.size() != 0) {
                    MissedEventsStorage missedEventsStorage = (MissedEventsStorage)arrayList.remove(0);
                    object2 = missedEventsStorage.getConnection().eventOut;
                    fMulticastConstants.sendOOBPacket((fEventOutputStream)object2, this.myServer.getStreamId(), (byte)10, null);
                    if (fMulticastConstants.sDebug) {
                        fMulticastConstants.log("Recovery completed for " + missedEventsStorage.getConnection().getID() + " retransmitted " + l3 + " events");
                    }
                    this.myServer.incrementReTXCounter(l3);
                }
            }
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
        try {
            for (fConnection fConnection3 : this.myClosureList) {
                try {
                    fConstants.logger.warn("Multicast> Closing connection " + fConnection3.getID() + " since recovery is impossible");
                    fConnection3.close();
                }
                catch (Exception exception) {
                    fConstants.logger.warn(exception);
                }
            }
        }
        finally {
            this.myClosureList.clear();
        }
    }
}

