/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.server;

import com.pcbsys.foundation.collections.maps.LinkedList;
import com.pcbsys.foundation.drivers.configuration.fMulticastConfig;
import com.pcbsys.foundation.drivers.multicast.changeKeyInfo;
import com.pcbsys.foundation.drivers.multicast.crypto.fBufferEncoder;
import com.pcbsys.foundation.drivers.multicast.crypto.fDigest;
import com.pcbsys.foundation.drivers.multicast.fBuffer;
import com.pcbsys.foundation.drivers.multicast.server.fBufferCacheManager;
import com.pcbsys.foundation.drivers.multicast.server.fMulticastServer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class fMulticastOutputStream
extends OutputStream {
    protected boolean allowPartialFlushes;
    private boolean isClosed;
    private int myPacketSize;
    private long myTxId;
    protected OutputStream myOutput;
    protected final fByteArrayOutputStream baos;
    private final fDigest myDigest;
    private final fMulticastServer myServer;
    private final fBufferEncoder myEncoder;
    private LinkedList rollingCodes;

    public fMulticastOutputStream(fMulticastServer fMulticastServer2, fBufferEncoder fBufferEncoder2, fDigest fDigest2, fMulticastConfig fMulticastConfig2) throws IOException {
        this.myServer = fMulticastServer2;
        this.myEncoder = fBufferEncoder2;
        this.myPacketSize = fMulticastConfig2.getPacketSize();
        this.myDigest = fDigest2;
        this.isClosed = false;
        this.rollingCodes = new LinkedList();
        this.allowPartialFlushes = true;
        this.baos = new fByteArrayOutputStream(this.myPacketSize * 10);
        this.myOutput = this.baos;
    }

    @Override
    public void close() {
        this.isClosed = true;
        try {
            this.baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        this.myOutput.write(n);
        if (this.allowPartialFlushes && this.baos.size() >= this.myPacketSize) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        this.myOutput.write(byArray, n, n2);
        if (this.allowPartialFlushes && this.baos.size() >= this.myPacketSize) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        this.myOutput.write(byArray);
        if (this.allowPartialFlushes && this.baos.size() >= this.myPacketSize) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        this.baos.flush();
        byte[] byArray = this.baos.toByteArray();
        int n = byArray.length;
        this.baos.reset();
        int n2 = 0;
        int n3 = this.myPacketSize - 16;
        if (this.myDigest != null) {
            n3 -= this.myDigest.getLength();
        }
        while (n > n3) {
            this.myServer.broadcastPackets(this.createBuffer(byArray, n2, n3));
            n2 += n3;
            n -= n3;
        }
        if (n != 0) {
            this.myServer.broadcastPackets(this.createBuffer(byArray, n2, n));
        }
    }

    private fBuffer createBuffer(byte[] byArray, int n, int n2) throws IOException {
        try {
            long l = this.myTxId++;
            if (this.rollingCodes.size() > 0) {
                long l2 = ((changeKeyInfo)this.rollingCodes.getFirst()).getMyChangekeyAt();
                if (l != -1L && l2 != 0L && l == l2) {
                    this.changeEncodingKey();
                }
            }
            if (this.myEncoder != null) {
                fBuffer fBuffer2 = fBufferCacheManager.getInstance().allocate();
                fBuffer2.reset(l, this.myEncoder.encode(l, byArray, n, n2));
                return fBuffer2;
            }
            fBuffer fBuffer3 = fBufferCacheManager.getInstance().allocate();
            fBuffer3.reset(l, byArray, n, n2);
            return fBuffer3;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    protected long getCurrentTXId() {
        return this.myTxId;
    }

    public void changeEncodingKey(long l, byte[] byArray, byte[] byArray2) {
        this.rollingCodes.addLast(new changeKeyInfo(l, byArray, byArray2));
    }

    private void changeEncodingKey() {
        try {
            changeKeyInfo changeKeyInfo2 = (changeKeyInfo)this.rollingCodes.removeFirst();
            if (this.myEncoder != null) {
                this.myEncoder.changeKey(changeKeyInfo2.getMyNewKey(), changeKeyInfo2.getCookie());
            }
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }

    public boolean hasQueuedKeyEncoding() {
        return this.rollingCodes.size() != 0;
    }
}

