/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.server;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.configuration.fMulticastConfig;
import com.pcbsys.foundation.drivers.http.fCookieGenerator;
import com.pcbsys.foundation.drivers.multicast.crypto.fBufferEncoder;
import com.pcbsys.foundation.drivers.multicast.crypto.fCryptoHelper;
import com.pcbsys.foundation.drivers.multicast.crypto.fDigest;
import com.pcbsys.foundation.drivers.multicast.fBuffer;
import com.pcbsys.foundation.drivers.multicast.fMulticastConstants;
import com.pcbsys.foundation.drivers.multicast.fMulticastManager;
import com.pcbsys.foundation.drivers.multicast.server.BufferMap;
import com.pcbsys.foundation.drivers.multicast.server.MissedEventsStorage;
import com.pcbsys.foundation.drivers.multicast.server.fClientBufferOverrun;
import com.pcbsys.foundation.drivers.multicast.server.fClientInSync;
import com.pcbsys.foundation.drivers.multicast.server.fConnectionInfo;
import com.pcbsys.foundation.drivers.multicast.server.fConnectionManager;
import com.pcbsys.foundation.drivers.multicast.server.fLatestBufferID;
import com.pcbsys.foundation.drivers.multicast.server.fMissedPacketCheck;
import com.pcbsys.foundation.drivers.multicast.server.fMulticastOutputStream;
import com.pcbsys.foundation.drivers.multicast.server.fPostExecutionQueue;
import com.pcbsys.foundation.drivers.multicast.server.fRollEncryptionKey;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.crypto.NoSuchPaddingException;

public final class fMulticastServer {
    private final BufferMap myBufferQueue;
    private final fConnectionManager connections;
    private final fPostExecutionQueue myPostExecutionQueue;
    private fClientBufferOverrun myOverrunHandler;
    private final DatagramSocket myMulticast;
    private final DatagramPacket myPacket;
    private final DatagramPacket myResetPacket;
    private final fMulticastConfig myConfig;
    private final fMulticastOutputStream myOutputStream;
    private final InetAddress myGroup;
    private final String myName;
    private final String myResourceName;
    private final boolean isAckMode;
    private final short myStreamId;
    private byte[] myCRCCookie;
    private fDigest myDigest;
    private boolean isStarted;
    private long applyNewEncryptionKeyAt;
    private byte[] currentEncryptionKey;
    private byte[] newEncryptionKey;
    private long E0;
    private long e1;
    private long e2;
    private long e3;
    private long e4;
    private long e5;
    private long e6;
    private long myLastWriteTime;
    private long A0;
    private long A1;
    private long A2;
    private long A3;
    private long A4;
    private long A5;
    private long A6;
    private long myResetsSent;
    private long B0;
    private long B1;
    private long B2;
    private long B3;
    private long B4;
    private long B5;
    private long B6;
    private long myTotalDatagramsSent;
    private long D0;
    private long D1;
    private long D2;
    private long D3;
    private long D4;
    private long D5;
    private long D6;
    private long myBytesSent;
    private long C0;
    private long C1;
    private long C2;
    private long C3;
    private long C4;
    private long C5;
    private long C6;
    private long myRetransmittedPackets;
    private long F0;
    private long F1;
    private long F2;
    private long F3;
    private long F4;
    private long f5;
    private long F6;
    private long myLowestAck;
    private fMissedPacketCheck myMissedPacketTask;
    private fLatestBufferID myLatestBufferID;
    private fRollEncryptionKey myRollEncryptionKeyTask;

    protected fMulticastServer(short s, fMulticastConfig fMulticastConfig2, String string) throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        Object object;
        this.myName = fMulticastConfig2.getMulticastAddress() + ":" + fMulticastConfig2.getActivePort() + ":" + s;
        this.myStreamId = s;
        this.myConfig = fMulticastConfig2;
        this.myResourceName = string;
        this.connections = new fConnectionManager();
        this.myPostExecutionQueue = new fPostExecutionQueue(this.myConfig);
        this.myRetransmittedPackets = 0L;
        this.myResetsSent = 0L;
        this.myTotalDatagramsSent = 0L;
        this.myGroup = InetAddress.getByName(fMulticastConfig2.getMulticastAddress());
        NetworkInterface networkInterface = NetworkInterface.getNetworkInterfaces().nextElement();
        if (fMulticastConfig2.getBindingAdapter() != null) {
            networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(fMulticastConfig2.getBindingAdapter()));
        }
        if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("IO> Binding to physical address " + networkInterface.getDisplayName());
        }
        if (this.myGroup.isMulticastAddress()) {
            if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("IO> Binding to multicast address " + this.myName);
            }
            object = new MulticastSocket(this.myConfig.getActivePort());
            ((MulticastSocket)object).setNetworkInterface(networkInterface);
            ((MulticastSocket)object).setTimeToLive(this.myConfig.getTTL());
            ((MulticastSocket)object).setLoopbackMode(this.myConfig.isAllowLoopback());
            if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("IO> Setting loopback mode to " + this.myConfig.isAllowLoopback());
            }
            this.myMulticast = object;
        } else {
            if (fMulticastConstants.sDebug) {
                fMulticastConstants.log("IO> Binding to UDP address " + this.myName);
            }
            this.myMulticast = new DatagramSocket(this.myConfig.getActivePort());
            this.myMulticast.setBroadcast(true);
        }
        if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("Setting send buffer size to " + this.myConfig.getAdapeterBufferSize());
        }
        this.myMulticast.setSendBufferSize(this.myConfig.getAdapeterBufferSize());
        this.myMulticast.setTrafficClass(this.myConfig.getQOS());
        object = new byte[]{0};
        this.myPacket = new DatagramPacket((byte[])object, 1, this.myGroup, this.myConfig.getActivePort());
        this.myResetPacket = new DatagramPacket((byte[])object, 1, this.myGroup, this.myConfig.getActivePort());
        this.myCRCCookie = fStringByteConverter.convert(fCookieGenerator.generateHardenedSessionId("", this.myGroup.getHostAddress(), this.myName, fMulticastConfig2.getUniqueSessionIdSize()));
        if (fMulticastConstants.sDebug) {
            fMulticastConstants.log("Setting CRC Cookie to " + fStringByteConverter.convert(this.myCRCCookie));
        }
        this.myDigest = fCryptoHelper.getDigest(fMulticastConfig.sDigestNames[fMulticastConfig2.getSignatureType()], this.myCRCCookie);
        if (this.myConfig.getMode() == 2) {
            this.myBufferQueue = new BufferMap(1, true);
            this.isAckMode = false;
        } else {
            this.isAckMode = this.myConfig.getMode() == 0;
            this.myBufferQueue = new BufferMap(this.myConfig.getUnAckedWindowSize(), !this.isAckMode);
        }
        this.applyNewEncryptionKeyAt = 0L;
        this.currentEncryptionKey = (byte[])(fMulticastConfig2.enableEncryption() && fMulticastConfig2.getEncryptionLevel() > 0 ? fCryptoHelper.generateNewAESKey(fMulticastConfig.sEncryptionLevel[fMulticastConfig2.getEncryptionLevel()]) : null);
        fBufferEncoder fBufferEncoder2 = fCryptoHelper.getEncoder(fMulticastConfig.sEncryptionType[fMulticastConfig2.getEncryptionLevel()], this.currentEncryptionKey, this.myCRCCookie);
        this.myOutputStream = new fMulticastOutputStream(this, fBufferEncoder2, this.myDigest, fMulticastConfig2);
        this.isStarted = false;
        this.myRollEncryptionKeyTask = new fRollEncryptionKey(this);
        this.myRollEncryptionKeyTask.start();
        this.myMissedPacketTask = new fMissedPacketCheck(this);
        this.myLatestBufferID = new fLatestBufferID(this);
        this.myLatestBufferID.start();
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    public fMulticastConfig getConfig() {
        return this.myConfig;
    }

    public synchronized void start() throws IOException {
        if (!this.isStarted) {
            this.isStarted = true;
            this.sendReset();
        }
    }

    public void setOverrunHandler(fClientBufferOverrun fClientBufferOverrun2) {
        this.myOverrunHandler = fClientBufferOverrun2;
    }

    public fClientBufferOverrun getOverRunHandler() {
        return this.myOverrunHandler;
    }

    public synchronized void stop() {
        fMulticastManager.getInstance().deleteStream(this.myStreamId);
    }

    protected void close() {
        this.myLatestBufferID.stop();
        this.myRollEncryptionKeyTask.stop();
        this.myMissedPacketTask.stop();
        this.myOutputStream.close();
        this.myMulticast.close();
        this.myBufferQueue.clear();
        this.connections.close();
    }

    public OutputStream getOutputStream() throws IOException {
        this.start();
        return this.myOutputStream;
    }

    public String getName() {
        return this.myName;
    }

    public synchronized void registerConnectionForLater(String string, fClientInSync fClientInSync2) {
        if (this.myBufferQueue.size() != 0) {
            fClientInSync2.setBufferId(this.myBufferQueue.getFirst().getId());
        } else {
            fClientInSync2.setBufferId(this.myOutputStream.getCurrentTXId());
        }
        this.myPostExecutionQueue.add(string, fClientInSync2);
    }

    public void addConnection(fConnection fConnection2) {
        this.removeConnection(fConnection2.getID());
        this.connections.add(new fConnectionInfo(fConnection2));
    }

    public synchronized void removeConnection(String string) {
        if (this.connections.del(string) == 0) {
            this.myLatestBufferID.stop();
            this.myBufferQueue.clear();
        } else {
            this.ack();
        }
    }

    public Iterator<fConnectionInfo> getConnections() {
        return this.connections.iterator();
    }

    public boolean isAllSynced() {
        return this.connections.isAllSynced() && this.myPostExecutionQueue.size() == 0;
    }

    public synchronized long getLastAck(String string) {
        fConnectionInfo fConnectionInfo2 = this.connections.get(string);
        if (fConnectionInfo2 != null) {
            return fConnectionInfo2.getLastAck();
        }
        return 0L;
    }

    public int getUnAckedEventSize() {
        return this.myBufferQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack() {
        this.myLowestAck = this.connections.getLowestAck() - 1L;
        if (this.myLowestAck == Long.MAX_VALUE || this.myLowestAck == 0L) {
            return;
        }
        long l = this.myPostExecutionQueue.getLowestBufferId();
        if (l != 0L && this.myLowestAck > l) {
            this.myLowestAck = this.myPostExecutionQueue.getLowestBufferId();
        }
        fMulticastServer fMulticastServer2 = this;
        synchronized (fMulticastServer2) {
            boolean bl = this.myBufferQueue.size() > this.myConfig.getUnAckedWindowSize();
            this.myBufferQueue.removeTo(this.myLowestAck);
            if (bl) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resend(fEventOutputStream fEventOutputStream2, long l) {
        fBuffer fBuffer2;
        fMulticastServer fMulticastServer2 = this;
        synchronized (fMulticastServer2) {
            fBuffer2 = this.myBufferQueue.get(l);
        }
        if (fBuffer2 != null) {
            fMulticastConstants.sendOOBPacketNoFlush(fEventOutputStream2, this.myStreamId, (byte)1, fBuffer2.packBuffer(null));
        }
    }

    public synchronized boolean retransmit(long l, long l2) throws IOException {
        for (long i = l; i <= l2; ++i) {
            fBuffer fBuffer2 = this.myBufferQueue.get(i);
            if (fBuffer2 == null) {
                return false;
            }
            byte[] byArray = fBuffer2.packBuffer(this.myDigest);
            this.myPacket.setData(byArray);
            this.myPacket.setLength(byArray.length);
            this.sendPacket(this.myPacket);
        }
        return true;
    }

    private synchronized void sendReset() throws IOException {
        byte[] byArray = fBuffer.getResetBuffer(this.myDigest);
        this.myResetPacket.setData(byArray);
        this.myResetPacket.setLength(byArray.length);
        this.sendPacket(this.myResetPacket);
        ++this.myResetsSent;
    }

    private void sendPacket(DatagramPacket datagramPacket) throws IOException {
        this.sendPacket(datagramPacket, false);
    }

    protected synchronized void broadcastPackets(fBuffer fBuffer2) throws IOException {
        if (this.getSize() == 0) {
            return;
        }
        byte[] byArray = fBuffer2.packBuffer(this.myDigest);
        this.myPacket.setData(byArray);
        this.myPacket.setLength(byArray.length);
        this.sendPacket(this.myPacket);
        if (this.newEncryptionKey != null && fBuffer2.getId() == this.applyNewEncryptionKeyAt) {
            this.currentEncryptionKey = this.newEncryptionKey;
            this.newEncryptionKey = null;
            this.applyNewEncryptionKeyAt = -10000L;
        }
        this.myBufferQueue.add(fBuffer2);
        if (this.isAckMode) {
            int n = 0;
            while (this.myBufferQueue.size() > this.myConfig.getUnAckedWindowSize() && n < 100) {
                try {
                    ++n;
                    if (this.myOverrunHandler != null) {
                        ArrayList<fConnectionInfo> arrayList = new ArrayList<fConnectionInfo>();
                        this.connections.getBlockingConnections(this.myLowestAck, arrayList);
                        if (arrayList.size() == 0) continue;
                        this.myOverrunHandler.bufferExceeded(arrayList);
                        continue;
                    }
                    this.wait(1L);
                }
                catch (InterruptedException interruptedException) {
                    fConstants.logger.debug(interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket(DatagramPacket datagramPacket, boolean bl) throws IOException {
        this.myMulticast.send(datagramPacket);
        this.myLastWriteTime = fTimer.currentTimeMillis();
        ++this.myTotalDatagramsSent;
        if (!bl) {
            fConnectionManager fConnectionManager2 = this.connections;
            synchronized (fConnectionManager2) {
                if (!this.connections.isAllSynced()) {
                    Iterator<fConnectionInfo> iterator = this.connections.iterator();
                    while (iterator.hasNext()) {
                        fConnectionInfo fConnectionInfo2 = iterator.next();
                        if (!fConnectionInfo2.isOOBRegistered() || fConnectionInfo2.isInSync() || !fConnectionInfo2.getConnection().isAlive()) continue;
                        fEventOutputStream fEventOutputStream2 = fConnectionInfo2.getConnection().getOutputStream();
                        fMulticastConstants.sendOOBPacket(fEventOutputStream2, this.myStreamId, (byte)1, datagramPacket.getData());
                    }
                }
            }
        }
        this.myBytesSent += (long)datagramPacket.getLength();
    }

    protected void changeEncodingKey() {
        if (!this.myOutputStream.hasQueuedKeyEncoding()) {
            try {
                this.newEncryptionKey = fCryptoHelper.generateNewAESKey(fMulticastConfig.sEncryptionLevel[this.myConfig.getEncryptionLevel()]);
                if (this.myOutputStream.getCurrentTXId() > 0L) {
                    this.applyNewEncryptionKeyAt = this.myOutputStream.getCurrentTXId() + (long)this.myConfig.getRotateEncryptionKeyCount();
                    Iterator<fConnectionInfo> iterator = this.connections.iterator();
                    while (iterator.hasNext()) {
                        fConnectionInfo fConnectionInfo2 = iterator.next();
                        if (!fConnectionInfo2.isOOBRegistered() || !fConnectionInfo2.getConnection().isAlive()) continue;
                        this.sendEncryptionKey(fConnectionInfo2, this.applyNewEncryptionKeyAt, this.newEncryptionKey);
                    }
                    this.myOutputStream.changeEncodingKey(this.applyNewEncryptionKeyAt, this.newEncryptionKey, this.myCRCCookie);
                }
            }
            catch (Exception exception) {
                fConstants.logger.warn(exception);
            }
        }
    }

    private void sendEncryptionKey(fConnectionInfo fConnectionInfo2, long l, byte[] byArray) {
        fMulticastConstants.sendOOBPacket(fConnectionInfo2.getConnection().getOutputStream(), this.myStreamId, (byte)7, l, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClient(fConnectionInfo fConnectionInfo2) {
        fMulticastConstants.sendOOBPacket(fConnectionInfo2.getConnection().getOutputStream(), this.myStreamId, (byte)8, this.myCRCCookie, fMulticastConfig.sDigestNames[this.myConfig.getSignatureType()]);
        fMulticastServer fMulticastServer2 = this;
        synchronized (fMulticastServer2) {
            this.sendEncryptionKey(fConnectionInfo2, 0L, this.currentEncryptionKey);
        }
        if (this.newEncryptionKey != null) {
            this.sendEncryptionKey(fConnectionInfo2, this.applyNewEncryptionKeyAt, this.newEncryptionKey);
        }
        this.myLatestBufferID.start();
    }

    public void readOOBMessage(fConnection fConnection2) {
        try {
            fEventInputStream fEventInputStream2 = fConnection2.getInputStream();
            byte by = fEventInputStream2.readByte();
            switch (by) {
                case 0: {
                    fConnection2.close();
                    break;
                }
                case 1: {
                    fEventInputStream2.readByteArray();
                    break;
                }
                case 2: {
                    long l = fEventInputStream2.readLong();
                    byte[] byArray = fEventInputStream2.readByteArray();
                    fConnectionInfo fConnectionInfo2 = this.connections.setOutOfBandReady(fConnection2.getID());
                    this.connections.setAck(fConnection2.getID(), l - 1L);
                    this.myMissedPacketTask.queueTask(fConnectionInfo2, new MissedEventsStorage(l, byArray, fConnection2));
                    break;
                }
                case 3: {
                    this.connections.setSyncFlag(fConnection2.getID(), true);
                    if (this.connections.get(fConnection2.getID()) == null) {
                        fConnectionInfo fConnectionInfo3 = new fConnectionInfo(fConnection2);
                        this.connections.add(fConnectionInfo3);
                        this.connections.setSyncFlag(fConnection2.getID(), true);
                        fClientInSync fClientInSync2 = this.myPostExecutionQueue.remove(fConnection2.getID());
                        if (fClientInSync2 != null) {
                            fClientInSync2.inSync(fConnection2);
                        }
                    }
                    break;
                }
                case 4: {
                    this.connections.setSyncFlag(fConnection2.getID(), false);
                    break;
                }
                case 5: {
                    fConnectionInfo fConnectionInfo4 = this.connections.setOutOfBandReady(fConnection2.getID());
                    if (fConnectionInfo4 == null) {
                        fConnectionInfo4 = new fConnectionInfo(fConnection2);
                    }
                    this.updateClient(fConnectionInfo4);
                    break;
                }
                case 6: {
                    this.connections.resetOutOfBandReady(fConnection2.getID());
                    break;
                }
                case 7: {
                    fEventInputStream2.readLong();
                    fEventInputStream2.readByteArray();
                    break;
                }
                case 8: {
                    fEventInputStream2.readByteArray();
                    fEventInputStream2.readString();
                    break;
                }
                case 9: {
                    this.connections.setExpectingId(fConnection2.getID(), fEventInputStream2.readLong());
                    break;
                }
                case 11: {
                    this.connections.setAck(fConnection2.getID(), fEventInputStream2.readLong());
                    this.ack();
                    break;
                }
                default: {
                    this.close();
                }
            }
        }
        catch (Exception exception) {
            fConstants.logger.fatal(exception);
            fConnection2.close();
        }
    }

    public short getStreamId() {
        return this.myStreamId;
    }

    public long getRetransmittedPackets() {
        return this.myRetransmittedPackets;
    }

    public long getResetsSent() {
        return this.myResetsSent;
    }

    public long getTotalDatagramsSent() {
        return this.myTotalDatagramsSent;
    }

    public long getBytesSent() {
        return this.myBytesSent;
    }

    public void checkPostExecutionQueue() {
        this.myPostExecutionQueue.validate();
    }

    public int getSize() {
        return this.connections.size() + this.myPostExecutionQueue.size();
    }

    public int getQueueSize() {
        return this.myBufferQueue.size();
    }

    public fDigest getDigest() {
        return this.myDigest;
    }

    public void incrementReTXCounter(long l) {
        this.myRetransmittedPackets += l;
    }

    public InetAddress getGroupAddress() {
        return this.myGroup;
    }

    public long getLastWriteTime() {
        return this.myLastWriteTime;
    }

    public synchronized long getFirstId() {
        if (this.myBufferQueue.size() > 0) {
            return this.myBufferQueue.getFirst().getId();
        }
        return this.myBufferQueue.getLastId();
    }
}

