/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.multicast.server;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.configuration.fMulticastConfig;
import com.pcbsys.foundation.drivers.multicast.server.fClientInSync;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class fPostExecutionQueue {
    private final LinkedHashMap<String, fClientInSync> myPostExecutionQueue = new LinkedHashMap();
    private fMulticastConfig myConfig;
    private long myLowestBufferId;

    public fPostExecutionQueue(fMulticastConfig fMulticastConfig2) {
        this.myConfig = fMulticastConfig2;
    }

    public long getLowestBufferId() {
        return this.myLowestBufferId;
    }

    public synchronized void add(String string, fClientInSync fClientInSync2) {
        this.myPostExecutionQueue.put(string, fClientInSync2);
        if (this.myPostExecutionQueue.size() == 1) {
            this.myLowestBufferId = fClientInSync2.getBufferId();
        } else if (this.myLowestBufferId > fClientInSync2.getBufferId()) {
            this.myLowestBufferId = fClientInSync2.getBufferId();
        }
    }

    public synchronized fClientInSync remove(String string) {
        fClientInSync fClientInSync2 = (fClientInSync)this.myPostExecutionQueue.remove(string);
        this.recalculateBufferId();
        return fClientInSync2;
    }

    public int size() {
        return this.myPostExecutionQueue.size();
    }

    public synchronized void validate() {
        if (this.myPostExecutionQueue.size() > 0) {
            long l = fTimer.currentTimeMillis();
            Iterator<fClientInSync> iterator = this.myPostExecutionQueue.values().iterator();
            while (iterator.hasNext()) {
                fClientInSync fClientInSync2 = iterator.next();
                if (fClientInSync2.getInitialTime() + this.myConfig.getClientEstablishmentTimeout() >= l) continue;
                iterator.remove();
                fClientInSync2.timedOut();
            }
            this.recalculateBufferId();
        }
    }

    private void recalculateBufferId() {
        if (this.myPostExecutionQueue.size() != 0) {
            Iterator<fClientInSync> iterator = this.myPostExecutionQueue.values().iterator();
            this.myLowestBufferId = Long.MAX_VALUE;
            while (iterator.hasNext()) {
                fClientInSync fClientInSync2 = iterator.next();
                if (fClientInSync2.getBufferId() >= this.myLowestBufferId) continue;
                this.myLowestBufferId = fClientInSync2.getBufferId();
            }
        } else {
            this.myLowestBufferId = Long.MAX_VALUE;
        }
    }
}

