/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.nio.fBufferDriver;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class fBufferInputStream
extends InputStream {
    private ByteBuffer myWorkingBuffer = null;
    private boolean isClosed = false;
    private fBufferManagement myBufferManager;
    private long myTimeOut = -1L;
    private fBufferDriver myChannel;

    public fBufferInputStream(fBufferManagement fBufferManagement2, fBufferDriver fBufferDriver2) {
        this.myBufferManager = fBufferManagement2;
        this.myChannel = fBufferDriver2;
    }

    public long getTimeOut() {
        return this.myTimeOut;
    }

    public void setTimeOut(long l) {
        this.myTimeOut = l;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosed) {
            return -1;
        }
        this.myChannel.setLastRead();
        this.allocateWorkingBuffer(false);
        int n = 0;
        if (this.myWorkingBuffer != null && this.myWorkingBuffer.remaining() != 0) {
            n = this.myWorkingBuffer.remaining();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.myChannel.setLastRead();
        this.isClosed = true;
        fBufferInputStream fBufferInputStream2 = this;
        synchronized (fBufferInputStream2) {
            if (this.myWorkingBuffer != null) {
                if (this.myBufferManager != null) {
                    this.myBufferManager.release(this.myWorkingBuffer);
                }
                this.myWorkingBuffer = null;
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.myChannel.setLastRead();
        this.allocateWorkingBuffer(true);
        if (this.isClosed && this.myWorkingBuffer == null) {
            return -1;
        }
        this.myChannel.updateReceived(1);
        return this.myWorkingBuffer.get();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.myChannel.setLastRead();
        this.allocateWorkingBuffer(true);
        if (this.isClosed && this.myWorkingBuffer == null) {
            return -1;
        }
        if (this.myWorkingBuffer == null) {
            return 0;
        }
        int n3 = n2;
        if (n2 > this.myWorkingBuffer.remaining()) {
            n3 = this.myWorkingBuffer.remaining();
        }
        this.myWorkingBuffer.get(byArray, n, n3);
        this.myChannel.updateReceived(n3);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateWorkingBuffer(boolean bl) throws IOException {
        fBufferInputStream fBufferInputStream2 = this;
        synchronized (fBufferInputStream2) {
            if (this.myWorkingBuffer != null) {
                if (this.myWorkingBuffer.remaining() == 0) {
                    if (this.myBufferManager != null) {
                        this.myBufferManager.release(this.myWorkingBuffer);
                    }
                    this.myWorkingBuffer = null;
                } else {
                    return;
                }
            }
        }
        long l = fTimer.getTicks();
        l = this.myTimeOut <= 0L ? Long.MAX_VALUE : (l += this.myTimeOut);
        if (this.isClosed) {
            throw new EOFException("Connection has been closed");
        }
        ByteBuffer byteBuffer = this.myBufferManager.allocate();
        int n = this.myChannel.read(byteBuffer);
        while (n == 0) {
            if (bl) {
                fJDKHelper.getThreadWaiter().park(1L);
                if (this.isClosed) {
                    throw new EOFException("Connection has been closed");
                }
            } else {
                this.myBufferManager.release(byteBuffer);
                return;
            }
            n = this.myChannel.read(byteBuffer);
            if (l >= fTimer.getTicks()) continue;
            throw new EOFException("Connection has timed out");
        }
        if (n == -1) {
            throw new EOFException("Connection closed");
        }
        byteBuffer.flip();
        this.myWorkingBuffer = byteBuffer;
    }
}

