/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.collections.fCircularQueue;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fNIOManager;
import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.nio.fBufferDriver;
import com.pcbsys.foundation.drivers.nio.fBufferInputStream;
import com.pcbsys.foundation.drivers.nio.fPipedOutputStream;
import com.pcbsys.foundation.drivers.nio.handlers.Channel;
import com.pcbsys.foundation.drivers.nio.handlers.ChannelFactory;
import com.pcbsys.foundation.drivers.nio.handlers.PacketChannel;
import com.pcbsys.foundation.drivers.nio.handlers.PacketChannelListener;
import com.pcbsys.foundation.drivers.nio.io.SelectorThread;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fLoginContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class fChannelDriver
extends fDriver
implements PacketChannelListener,
fBufferDriver {
    private static SelectorThread sClientMonitor;
    protected final SocketChannel myChannel;
    private final fBufferInputStream myInputProcessor;
    private final fPipedOutputStream myOutputProcessor;
    protected final SelectorThread myMonitor;
    private final fBufferManagement myBufferManager;
    final PacketChannel myPacketChannel;
    private boolean isAborted;
    private volatile boolean inClose;

    fChannelDriver(String string, int n, fLoginContext fLoginContext2, ChannelFactory channelFactory) throws Exception {
        super(fLoginContext2);
        this.isAborted = false;
        this.inClose = false;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        this.myChannel = SocketChannel.open(inetSocketAddress);
        if (sClientMonitor == null) {
            sClientMonitor = new SelectorThread("Client NIO Selector thread");
        }
        this.myMonitor = sClientMonitor;
        this.myBufferManager = fNIOManager.getBufferManager()[0];
        this.myType = fConnectionDetails.getProtocolString(0);
        fJDKHelper.setupSocket(this.myChannel.socket());
        this.socketSetup();
        this.myInputProcessor = new fBufferInputStream(this.myBufferManager, this);
        this.myOutputProcessor = new fPipedOutputStream(this, this.myBufferManager);
        this.myPacketChannel = new PacketChannel(this.myChannel, this.myMonitor, this.myBufferManager, this, channelFactory);
        this.setLastRead();
        this.setLastWrite();
    }

    fChannelDriver(SocketChannel socketChannel, fLoginContext fLoginContext2, SelectorThread selectorThread, fBufferManagement fBufferManagement2, ChannelFactory channelFactory) throws Exception {
        super(fLoginContext2);
        this.inClose = false;
        this.isAborted = false;
        this.myChannel = socketChannel;
        this.myMonitor = selectorThread;
        this.myBufferManager = fBufferManagement2;
        this.myType = fConnectionDetails.getProtocolString(0);
        this.socketSetup();
        this.myInputProcessor = new fBufferInputStream(this.myBufferManager, this);
        this.myOutputProcessor = new fPipedOutputStream(this, this.myBufferManager);
        this.myPacketChannel = new PacketChannel(this.myChannel, this.myMonitor, this.myBufferManager, this, channelFactory);
        this.setLastRead();
        this.setLastWrite();
    }

    public Channel getChannel() {
        return this.myPacketChannel.getChannel();
    }

    private void socketSetup() throws Exception {
        this.myChannel.finishConnect();
        this.myChannel.configureBlocking(false);
    }

    @Override
    public void open() throws IOException, fException {
        super.open();
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Protocol: NSP (NIO) : " + this.getId() + " connected.");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.myInputProcessor;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.myOutputProcessor;
    }

    @Override
    public synchronized void write(fCircularQueue fCircularQueue2, boolean bl) throws IOException {
        this.myPacketChannel.sendVector(fCircularQueue2, bl);
        this.setLastWrite();
    }

    @Override
    public synchronized void write(ByteBuffer byteBuffer, boolean bl) throws IOException {
        this.myPacketChannel.sendBuffer(byteBuffer, bl);
        this.setLastWrite();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.myPacketChannel.getChannel().read(byteBuffer);
    }

    @Override
    public void setTimeout(int n) {
        try {
            if (this.myChannel.socket() != null) {
                this.myChannel.socket().setSoTimeout(n);
            }
            this.myInputProcessor.setTimeOut(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getTimeout() {
        try {
            return this.myChannel.socket().getSoTimeout();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public String getId() {
        if (this.myID == null) {
            this.myID = "NIO:Socket closed";
            if (this.myChannel != null) {
                Socket socket = this.myChannel.socket();
                if (socket != null && this.myChannel.socket().getInetAddress() != null) {
                    this.myID = this.myChannel.socket().getInetAddress().getHostAddress() + ":" + this.myChannel.socket().getPort();
                }
            } else {
                this.myID = "NIO:Channel Closed";
            }
        }
        return this.myID;
    }

    private boolean notifyListener() throws IOException {
        if (this.myListener != null && !this.inClose) {
            this.myListener.dataReady();
            return true;
        }
        return false;
    }

    @Override
    public void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        this.registerListener(fAsyncReadListener2, true);
    }

    @Override
    public void registerListener(fAsyncReadListener fAsyncReadListener2, boolean bl) throws Exception {
        if (super.isClosed()) {
            return;
        }
        super.registerListener(fAsyncReadListener2);
        if (fAsyncReadListener2 != null) {
            if (bl && this.myInputProcessor.available() != 0) {
                this.notifyListener();
            }
            this.myPacketChannel.reactivateReading();
        }
    }

    @Override
    public String getLocalId() {
        if (this.myLocalID == null) {
            this.myLocalID = this.myChannel.socket().getLocalAddress().getHostAddress() + ":" + this.myChannel.socket().getLocalPort();
        }
        return this.myLocalID;
    }

    @Override
    public int getLocalPort() {
        return this.myChannel.socket().getPort();
    }

    @Override
    public boolean supportAsyncReading() {
        return true;
    }

    @Override
    public boolean supportAsyncWriting() {
        return true;
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        String string;
        int n = 0;
        int n2 = 0;
        if (fConnectionDetails.sEnableReverseDNSLookups) {
            try {
                string = this.myChannel.socket().getInetAddress().getHostName();
            }
            catch (Exception exception) {
                string = this.myChannel.socket().getInetAddress().getHostAddress();
            }
        } else {
            string = this.myChannel.socket().getInetAddress().getHostAddress();
        }
        try {
            n = this.myChannel.socket().getLocalPort();
            n2 = fConnectionDetails.getProtocolType(this.myProtocolId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new fConnectionDetails(n2, string, n, "");
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isRequireClientAuth() {
        return false;
    }

    @Override
    public boolean packetArrived(PacketChannel packetChannel, ByteBuffer byteBuffer) {
        try {
            return this.notifyListener();
        }
        catch (Exception exception) {
            try {
                this.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    public void resumeReading() {
        if (super.isClosed()) {
            return;
        }
        try {
            if (this.myPacketChannel != null) {
                this.myPacketChannel.reactivateReading();
            }
        }
        catch (IOException iOException) {
            fConstants.logger.warn(iOException);
        }
    }

    @Override
    public void packetSent(PacketChannel packetChannel, ByteBuffer byteBuffer) {
        this.myOutputProcessor.sendComplete(byteBuffer);
    }

    @Override
    public boolean isClosed() {
        return this.myChannel != null && this.myChannel.socket() != null && (this.myChannel.socket().isClosed() || !this.myChannel.socket().isConnected()) || super.isClosed();
    }

    @Override
    public void abortAllIO() {
        this.isAborted = true;
    }

    @Override
    public void close() throws IOException, fException {
        try {
            this.actualClose(false);
        }
        catch (Exception exception) {
        }
        finally {
            super.close();
        }
    }

    private void forceClose() throws IOException, fException {
        try {
            this.actualClose(true);
        }
        catch (Exception exception) {
        }
        finally {
            super.close();
        }
    }

    private void actualClose(boolean bl) throws Exception {
        if (this.inClose || super.isClosed()) {
            return;
        }
        this.inClose = true;
        if (!this.isAborted && this.myChannel.isOpen()) {
            this.myOutputProcessor.clearForClose();
            if (!bl) {
                this.myOutputProcessor.flush();
            }
        }
        this.myOutputProcessor.close();
        this.myPacketChannel.close();
        try {
            try {
                this.myChannel.socket().shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.myChannel.socket().shutdownInput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.myPacketChannel.disableReading();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.myInputProcessor.close();
            this.myChannel.socket().close();
            this.myChannel.close();
            if (this.myListener != null) {
                this.myListener.close();
            }
            this.myListener = null;
        }
        catch (IOException iOException) {
            fConstants.logger.warn(iOException);
        }
        this.setClosed(true);
    }

    @Override
    public void socketException(PacketChannel packetChannel, Exception exception) {
        try {
            this.forceClose();
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    @Override
    public void channelClosed() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        return this.getId();
    }
}

