/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.fCircularQueue;
import com.pcbsys.foundation.drivers.fNIOOutputStream;
import com.pcbsys.foundation.drivers.fWriteReadyCallback;
import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.nio.fBufferDriver;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class fPipedOutputStream
extends OutputStream
implements fNIOOutputStream {
    private fBufferDriver myPC;
    private fBufferManagement myBufferManager;
    private ByteBuffer myLastUsed;
    private ByteBuffer myActiveBuffer;
    private fCircularQueue<ByteBuffer> myList;
    private fWriteReadyCallback myCallback;
    private boolean closed = false;
    private boolean isClosing = false;
    private final byte[] tmp = new byte[1];
    private int pktCount;
    private final Object internalLock = new Object();

    fPipedOutputStream(fBufferDriver fBufferDriver2, fBufferManagement fBufferManagement2) {
        this.myPC = fBufferDriver2;
        this.myBufferManager = fBufferManagement2;
        this.myCallback = null;
        this.myLastUsed = null;
    }

    @Override
    public void registerCallback(fWriteReadyCallback fWriteReadyCallback2) {
        this.myCallback = fWriteReadyCallback2;
    }

    @Override
    public void write(int n) throws IOException {
        this.tmp[0] = (byte)n;
        this.write(this.tmp, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        this.myPC.setLastWrite();
        boolean bl = false;
        Object object = this.internalLock;
        synchronized (object) {
            if (this.myActiveBuffer == null) {
                if (this.myLastUsed != null) {
                    this.myActiveBuffer = this.myLastUsed;
                    this.myLastUsed = null;
                } else {
                    this.myActiveBuffer = this.myBufferManager.allocate();
                }
            }
            int n3 = this.myActiveBuffer.remaining();
            int n4 = n2;
            int n5 = n;
            while (n4 > n3) {
                this.myActiveBuffer.put(byArray, n5, n3);
                this.myActiveBuffer.flip();
                if (this.myList == null) {
                    this.myList = new fCircularQueue(12, false, true);
                }
                this.myList.put(this.myActiveBuffer);
                n5 += n3;
                if ((n4 -= n3) > 0) {
                    this.myActiveBuffer = this.myBufferManager.allocate();
                    n3 = this.myActiveBuffer.limit();
                    continue;
                }
                this.myActiveBuffer = null;
                n4 = n3;
            }
            if (this.myActiveBuffer != null) {
                try {
                    this.myActiveBuffer.put(byArray, n5, n4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.myList != null && this.myList.size() > 10) {
                bl = true;
            }
        }
        if (bl) {
            this.flush();
            this.waitForFlush(10000L);
        }
        this.myPC.updateSent(n2);
    }

    @Override
    public void updateUsage() {
        this.myPC.setLastRead();
        this.myPC.setLastWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        fCircularQueue<ByteBuffer> fCircularQueue2 = null;
        ByteBuffer byteBuffer = null;
        Object object = this.internalLock;
        synchronized (object) {
            if (this.isWriting()) {
                return;
            }
            if (this.myActiveBuffer == null && this.myList == null) {
                return;
            }
            if (this.myActiveBuffer != null) {
                this.myActiveBuffer.flip();
                if (this.myList != null) {
                    this.myList.put(this.myActiveBuffer);
                    this.myActiveBuffer = null;
                } else {
                    this.pktCount = 1;
                    byteBuffer = this.myActiveBuffer;
                    this.myActiveBuffer = null;
                }
            }
            if (this.myList != null) {
                this.pktCount = this.myList.size();
                fCircularQueue2 = this.myList;
                this.myList = null;
            }
        }
        if (fCircularQueue2 != null) {
            this.myPC.write(fCircularQueue2, this.myCallback == null);
        }
        if (byteBuffer != null) {
            this.myPC.write(byteBuffer, this.myCallback == null);
        }
    }

    @Override
    public void waitForFlush(long l) {
        long l2 = fTimer.getTicks() + l;
        if (this.myCallback != null) {
            while (!this.closed && l2 < fTimer.getTicks()) {
                fJDKHelper.park(1L);
                if (this.myActiveBuffer != null || this.myList != null) {
                    try {
                        this.flush();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                break;
            }
        } else {
            while (this.myCallback == null && l2 < fTimer.getTicks()) {
                fJDKHelper.park(1L);
                if (this.myActiveBuffer != null || this.myList != null) {
                    try {
                        this.flush();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                break;
            }
        }
        while (this.isWriting() && !this.closed) {
            fJDKHelper.park(1L);
            if (l2 >= fTimer.getTicks()) continue;
            break;
        }
    }

    @Override
    public boolean isClosed() {
        return this.myPC.isClosed();
    }

    @Override
    public boolean isWriting() {
        if (this.pktCount < 0) {
            this.pktCount = 0;
        }
        return this.pktCount != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferSize() {
        Object object = this.internalLock;
        synchronized (object) {
            if (this.pktCount < 0) {
                this.pktCount = 0;
            }
            if (this.myList != null) {
                return this.pktCount + this.myList.size();
            }
            return this.pktCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendComplete(ByteBuffer byteBuffer) {
        boolean bl = false;
        Object object = this.internalLock;
        synchronized (object) {
            if (this.myLastUsed == null) {
                byteBuffer.clear();
                this.myLastUsed = byteBuffer;
            } else {
                this.myBufferManager.release(byteBuffer);
            }
            --this.pktCount;
            if (this.pktCount == 0 && !this.isClosing) {
                bl = true;
            }
        }
        if (bl) {
            boolean bl2 = true;
            if (this.myCallback != null) {
                bl2 = false;
                Object object2 = this.internalLock;
                synchronized (object2) {
                    if (this.myList != null) {
                        bl2 = this.myList.size() != 0;
                    }
                }
                if (!bl2 && this.myActiveBuffer != null) {
                    bl2 = true;
                }
            }
            if (bl2 && !this.isWriting()) {
                try {
                    this.flush();
                }
                catch (IOException iOException) {}
            } else {
                this.myCallback.writeReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.closed = true;
        this.myPC.setLastWrite();
        try {
            Object object;
            if (this.myList != null || this.myActiveBuffer != null) {
                this.flush();
                this.waitForFlush(10000L);
                object = this.internalLock;
                synchronized (object) {
                    while (this.myList != null && this.myList.size() != 0) {
                        ByteBuffer byteBuffer = this.myList.get();
                        this.myBufferManager.release(byteBuffer);
                    }
                }
                if (this.myLastUsed != null) {
                    this.myBufferManager.release(this.myLastUsed);
                }
            }
            this.myPC.close();
            object = this.internalLock;
            synchronized (object) {
                this.myList = null;
                this.pktCount = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearForClose() throws IOException {
        this.isClosing = true;
        this.flush();
    }
}

