/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio;

import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fNIOManager;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.nio.fSSLChannelDriver;
import com.pcbsys.foundation.drivers.nio.fServerChannelDriver;
import com.pcbsys.foundation.drivers.nio.io.SelectorThread;
import com.pcbsys.foundation.drivers.nio.ssl.SSLChannelFactory;
import com.pcbsys.foundation.drivers.nio.ssl.SSLSelectorThread;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fDriverMonitorEntry;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.security.cert.X509Certificate;

public class fSSLServerChannelDriver
extends fServerChannelDriver {
    boolean clientRequired = false;

    public fSSLServerChannelDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        super(fBaseDriverConfig2, fAcceptHandler2, string);
        this.clientRequired = ((fBaseSSLConfig)((Object)fBaseDriverConfig2)).getCertRequired();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    protected void setupSelectors(fBaseDriverConfig fBaseDriverConfig2) throws IOException {
        this.myMonitor = new SelectorThread[fBaseDriverConfig2.getSelectorPoolSize()];
        for (int i = 0; i < this.myMonitor.length; ++i) {
            this.myMonitor[i] = new SSLSelectorThread(fBaseDriverConfig2.getName() + " NIO Selector thread:" + i);
        }
        this.myFactory = new SSLChannelFactory((fBaseSSLConfig)((Object)fBaseDriverConfig2));
        this.myBufferManager = fNIOManager.getBufferManager();
    }

    @Override
    protected fDriver createDriver(SocketChannel socketChannel) throws Exception {
        fSSLChannelDriver fSSLChannelDriver2 = new fSSLChannelDriver(socketChannel, this.myContext, this.myMonitor[this.mySelectorIdx], this.myBufferManager[this.myBufferIdx], this.myFactory);
        fSSLChannelDriver2.setRequireClientAuth(this.clientRequired);
        ++this.mySelectorIdx;
        if (this.mySelectorIdx == this.myMonitor.length) {
            this.mySelectorIdx = 0;
        }
        ++this.myBufferIdx;
        if (this.myBufferIdx == this.myBufferManager.length) {
            this.myBufferIdx = 0;
        }
        fSSLChannelDriver2.setProtocolId(this.myProtocolId);
        return fSSLChannelDriver2;
    }

    @Override
    public boolean validate(fDriver fDriver2) throws IOException {
        new HandshakeComplete((fSSLChannelDriver)fDriver2);
        return false;
    }

    private class HandshakeComplete
    extends fDriverMonitorEntry
    implements HandshakeCompletedListener,
    fTask {
        fSSLChannelDriver myChannel;
        boolean handShakeEnded;

        public HandshakeComplete(fSSLChannelDriver fSSLChannelDriver2) throws IOException {
            super(fSSLChannelDriver2);
            this.handShakeEnded = false;
            this.myChannel = fSSLChannelDriver2;
            fSSLServerChannelDriver.this.myConnectionMonitor.add(this);
            this.validate();
        }

        private void validate() throws IOException {
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("SSL handshake starting with remote host : " + this.myChannel.myChannel.socket().getInetAddress().getHostAddress());
            }
            this.myChannel.addHandshakeCompletedListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
            Object object = this;
            synchronized (object) {
                this.handShakeEnded = true;
            }
            fSSLServerChannelDriver.this.myConnectionMonitor.remove(this);
            this.myChannel.removeHandshakeCompletedListener(this);
            try {
                if (!this.handShakeEnded) {
                    fConstants.logger.error("SSL handshake time out failure with remote host : " + this.myChannel.myChannel.socket().getInetAddress().getHostAddress());
                    try {
                        this.myChannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new IOException("Unable to complete SSL handshake within time frame");
                }
                if (fSSLServerChannelDriver.this.clientRequired) {
                    try {
                        object = this.myChannel.getSSLSession();
                        X509Certificate[] x509CertificateArray = object.getPeerCertificateChain();
                        for (int i = 0; i < x509CertificateArray.length; ++i) {
                            X509Certificate x509Certificate = x509CertificateArray[i];
                            x509Certificate.checkValidity();
                        }
                    }
                    catch (Exception exception) {
                        fConstants.logger.log("SSL Peer unverified. Reason: " + exception.getMessage());
                        throw new IOException("SSL Peer unverified", exception);
                    }
                }
                fThreadPool.getCommonThreadPool().addTask(this);
            }
            catch (Exception exception) {
                fConstants.logger.fatal(exception);
            }
        }

        @Override
        public void execute() {
            try {
                this.myChannel.setTimeout(fSSLServerChannelDriver.this.myTimeout);
                fSSLServerChannelDriver.this.completeDriverConnection(this.myChannel);
                this.myChannel.setTimeout(300000);
            }
            catch (Exception exception) {
                fConstants.logger.fatal("SSL Unable to complete client driver setup for connection from " + this.myChannel.getId() + " with subject=" + this.myChannel.getSubject() + " - " + exception, exception);
                if (exception instanceof RuntimeException) {
                    fConstants.logger.fatal(exception);
                }
                try {
                    this.myChannel.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean reQueue() {
            return false;
        }
    }
}

