/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fNIOManager;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.fSubjectHelper;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.nio.fChannelDriver;
import com.pcbsys.foundation.drivers.nio.handlers.ChannelFactory;
import com.pcbsys.foundation.drivers.nio.handlers.PlainChannelFactory;
import com.pcbsys.foundation.drivers.nio.io.SelectorThread;
import com.pcbsys.foundation.security.fServerLoginContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class fServerChannelDriver
extends fServerDriver {
    protected ServerSocketChannel myServerSocket;
    protected int myTimeout;
    protected final fServerLoginContext myContext;
    protected final String myProtocolId;
    protected SelectorThread[] myMonitor;
    protected fBufferManagement[] myBufferManager;
    protected int mySelectorIdx = 0;
    protected int myBufferIdx = 0;
    protected ChannelFactory myFactory;
    protected final int myRecvBufferSize;
    protected final int mySendBufferSize;

    public fServerChannelDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        super(fAcceptHandler2, fBaseDriverConfig2);
        this.myContext = fServerLoginContext.getInstance(string);
        this.myContext.setConfig(fBaseDriverConfig2);
        this.myContext.setConnectionValidator(fSubjectHelper.loadValidator(fBaseDriverConfig2));
        this.myProtocolId = string;
        this.myRecvBufferSize = fBaseDriverConfig2.getReadBufferSize();
        this.mySendBufferSize = fBaseDriverConfig2.getWriteBufferSize();
        this.setupSelectors(fBaseDriverConfig2);
        this.createServerSocket(fBaseDriverConfig2);
        this.myTimeout = fBaseDriverConfig2.getAuthTimeOut();
        this.start();
    }

    protected void createServerSocket(fBaseDriverConfig fBaseDriverConfig2) throws IOException {
        try {
            this.myServerSocket = ServerSocketChannel.open();
            this.myServerSocket.socket().setReceiveBufferSize(this.myRecvBufferSize);
        }
        catch (IOException iOException) {
            fFile.checkException(iOException);
        }
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = fBaseDriverConfig2.getAdapter().equalsIgnoreCase("0.0.0.0") ? new InetSocketAddress(fBaseDriverConfig2.getPort()) : new InetSocketAddress(fBaseDriverConfig2.getAdapter(), fBaseDriverConfig2.getPort());
        this.myServerSocket.socket().bind(inetSocketAddress, fBaseDriverConfig2.getBacklog());
    }

    protected void setupSelectors(fBaseDriverConfig fBaseDriverConfig2) throws IOException {
        this.myMonitor = new SelectorThread[fBaseDriverConfig2.getSelectorPoolSize()];
        for (int i = 0; i < this.myMonitor.length; ++i) {
            this.myMonitor[i] = new SelectorThread(fBaseDriverConfig2.getName() + " NIO Selector thread:" + i);
        }
        this.myFactory = new PlainChannelFactory();
        this.myBufferManager = fNIOManager.getBufferManager();
    }

    @Override
    public boolean validate(fDriver fDriver2) throws IOException {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.stop();
        super.close();
        for (int i = 0; i < this.myMonitor.length; ++i) {
            this.myMonitor[i].signalClose();
        }
        this.myServerSocket.close();
        super.close();
    }

    @Override
    public void setAuthenticationTimeout(long l) {
        this.myTimeout = (int)l;
    }

    @Override
    public fDriver performAccept() throws IOException {
        SocketChannel socketChannel = this.myServerSocket.accept();
        fJDKHelper.setupSocket(socketChannel.socket(), this.myRecvBufferSize, this.mySendBufferSize);
        String string = "";
        try {
            if (socketChannel.isOpen()) {
                string = socketChannel.socket().getInetAddress().getHostAddress();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            socketChannel.socket().setSoTimeout(this.myTimeout);
            return this.createDriver(socketChannel);
        }
        catch (Exception exception) {
            if (this.isActive) {
                try {
                    socketChannel.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                IOException iOException = new IOException(exception.toString() + "< " + string + " >");
                iOException.setStackTrace(exception.getStackTrace());
                throw iOException;
            }
            return null;
        }
    }

    @Override
    public String getName() throws IOException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    protected fDriver createDriver(SocketChannel socketChannel) throws Exception {
        fChannelDriver fChannelDriver2 = new fChannelDriver(socketChannel, this.myContext, this.myMonitor[this.mySelectorIdx], this.myBufferManager[this.myBufferIdx], this.myFactory);
        fChannelDriver2.setTimeout(this.myTimeout);
        ++this.mySelectorIdx;
        if (this.mySelectorIdx == this.myMonitor.length) {
            this.mySelectorIdx = 0;
        }
        ++this.myBufferIdx;
        if (this.myBufferIdx == this.myBufferManager.length) {
            this.myBufferIdx = 0;
        }
        fChannelDriver2.setProtocolId(this.myProtocolId);
        return fChannelDriver2;
    }
}

