/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio.handlers;

import com.pcbsys.foundation.drivers.nio.fModChannel;
import com.pcbsys.foundation.drivers.nio.handlers.ChannelListener;
import com.pcbsys.foundation.drivers.nio.io.SelectorThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public abstract class Channel {
    protected final SelectorThread mySelectorThread;
    protected final SocketChannel mySocketChannel;
    protected final ChannelListener myListener;
    protected fModChannel myReadMod;
    protected fModChannel myWriteMod;

    public Channel(SelectorThread selectorThread, SocketChannel socketChannel, ChannelListener channelListener) {
        this.mySelectorThread = selectorThread;
        this.mySocketChannel = socketChannel;
        this.myListener = channelListener;
        this.myReadMod = new fModChannel(socketChannel, 1, selectorThread);
        this.myWriteMod = new fModChannel(socketChannel, 4, selectorThread);
    }

    public SocketChannel getSocketChannel() {
        return this.mySocketChannel;
    }

    public abstract int read(ByteBuffer var1) throws IOException;

    public abstract int write(ByteBuffer var1) throws IOException;

    public abstract void registerForRead() throws IOException;

    public abstract void unregisterForRead() throws IOException;

    public abstract void registerForWrite() throws IOException;

    public abstract void unregisterForWrite() throws IOException;

    public abstract void close() throws IOException;

    public abstract void complete() throws IOException;

    public abstract void handleRead();

    public abstract void handleWrite();

    public SelectorThread getSelector() {
        return this.mySelectorThread;
    }
}

