/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio.handlers;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.fCircularQueue;
import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import com.pcbsys.foundation.drivers.nio.handlers.Channel;
import com.pcbsys.foundation.drivers.nio.handlers.ChannelFactory;
import com.pcbsys.foundation.drivers.nio.handlers.ChannelListener;
import com.pcbsys.foundation.drivers.nio.handlers.PacketChannelListener;
import com.pcbsys.foundation.drivers.nio.io.SelectorThread;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class PacketChannel
implements ChannelListener {
    protected final PacketChannelListener myListener;
    protected final Channel myChannel;
    protected final fBufferManagement myBufMgr;
    protected ByteBuffer outBuffer;
    protected fCircularQueue outBuffers;
    protected boolean isWriteWaiting;
    protected boolean closeRequested;

    public PacketChannel(SocketChannel socketChannel, SelectorThread selectorThread, fBufferManagement fBufferManagement2, PacketChannelListener packetChannelListener, ChannelFactory channelFactory) throws Exception {
        this.myListener = packetChannelListener;
        this.isWriteWaiting = false;
        this.closeRequested = false;
        this.myBufMgr = fBufferManagement2;
        this.myChannel = channelFactory.createChannel(socketChannel, selectorThread, this);
        try {
            this.myChannel.complete();
        }
        catch (Exception exception) {
            try {
                this.myChannel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw exception;
        }
    }

    public Channel getChannel() {
        return this.myChannel;
    }

    public void close() {
        try {
            if (this.outBuffers != null && this.outBuffer != null) {
                this.closeRequested = true;
            } else {
                this.myChannel.close();
            }
        }
        catch (IOException iOException) {
            fConstants.logger.warn(iOException);
        }
    }

    @Override
    public void handleRead() {
        try {
            this.processInBuffer(null);
        }
        catch (IOException iOException) {
            this.myListener.socketException(this, iOException);
            this.close();
        }
        catch (Throwable throwable) {
            this.myListener.socketException(this, new IOException(throwable.getMessage()));
            this.close();
        }
    }

    @Override
    public void handleClose() {
        this.myListener.channelClosed();
    }

    public void disableReading() throws IOException {
        this.myChannel.unregisterForRead();
    }

    public void reactivateReading() throws IOException {
        this.myChannel.registerForRead();
    }

    private boolean processInBuffer(ByteBuffer byteBuffer) throws IOException {
        return this.myListener.packetArrived(this, byteBuffer);
    }

    public synchronized void sendVector(fCircularQueue fCircularQueue2, boolean bl) throws IOException {
        if (this.outBuffers != null) {
            while (fCircularQueue2.size() != 0) {
                this.outBuffers.put(fCircularQueue2.get());
            }
        } else {
            this.outBuffers = fCircularQueue2;
        }
        this.outBuffer = null;
        this.handleWrite(bl);
    }

    public synchronized void sendBuffer(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (this.outBuffers != null) {
            this.outBuffers.put(byteBuffer);
            this.outBuffer = null;
        } else {
            this.outBuffer = byteBuffer;
        }
        this.handleWrite(bl);
    }

    private void requestWrite() throws IOException {
        this.myChannel.registerForWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleWrite(boolean bl) {
        PacketChannel packetChannel = this;
        synchronized (packetChannel) {
            if (this.isWriteWaiting) {
                this.isWriteWaiting = false;
                this.notify();
                return;
            }
        }
        if (bl) {
            if (this.myChannel.getSelector().isThread(Thread.currentThread())) {
                packetChannel = this;
                synchronized (packetChannel) {
                    this.isWriteWaiting = false;
                    this.notify();
                    fThreadPool.getWritePool().addTask(new fSelectorWorker());
                    return;
                }
            }
            this.handleSyncWrite();
        } else {
            this.handleAsyncWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSyncWrite() {
        boolean bl = true;
        long l = -1L;
        while (bl && this.myChannel.mySocketChannel.isOpen()) {
            bl = false;
            ByteBuffer byteBuffer = null;
            boolean bl2 = false;
            int n = 0;
            PacketChannel packetChannel = this;
            synchronized (packetChannel) {
                try {
                    if (this.outBuffers != null && this.outBuffer == null) {
                        this.outBuffer = (ByteBuffer)this.outBuffers.get();
                        if (this.outBuffers.size() == 0) {
                            this.outBuffers = null;
                        }
                    }
                    if (this.outBuffer == null) {
                        return;
                    }
                    n = this.doWrite();
                    if (!this.outBuffer.hasRemaining()) {
                        bl2 = true;
                        byteBuffer = this.outBuffer;
                        this.outBuffer = null;
                        if (this.outBuffers != null && this.outBuffers.size() != 0) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    this.close();
                    IOException iOException = new IOException(throwable.getMessage());
                    this.myListener.socketException(this, iOException);
                    return;
                }
            }
            if (bl2) {
                this.myListener.packetSent(this, byteBuffer);
                if (this.closeRequested) {
                    this.close();
                }
            }
            if (n == 0) {
                if (l == -1L) {
                    l = fTimer.getTicks();
                } else if (fTimer.getTicks() - l > 120000L) {
                    fConstants.logger.warn("Synchronous write stalled, releasing thread ");
                    try {
                        throw new Exception("Synchronous write stalled, releasing thread " + Thread.currentThread().getName());
                    }
                    catch (Exception exception) {
                        fConstants.logger.warn(exception);
                        return;
                    }
                }
            } else {
                l = -1L;
            }
            if (!bl) continue;
            try {
                packetChannel = this;
                synchronized (packetChannel) {
                    this.isWriteWaiting = true;
                    this.requestWrite();
                    long l2 = fTimer.currentTimeMillis() + 10000L;
                    while (this.isWriteWaiting && this.myChannel.mySocketChannel.isOpen() && l2 > fTimer.currentTimeMillis()) {
                        this.wait(1000L);
                    }
                    if (l2 < fTimer.currentTimeMillis()) {
                        this.close();
                        IOException iOException = new IOException("NIO synchronous write exceeded timeout");
                        this.myListener.socketException(this, iOException);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                fConstants.logger.warn(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncWrite() {
        ByteBuffer byteBuffer = null;
        boolean bl = false;
        PacketChannel packetChannel = this;
        synchronized (packetChannel) {
            try {
                boolean bl2 = true;
                boolean bl3 = true;
                while (bl3) {
                    if (this.outBuffers != null && this.outBuffer == null) {
                        Object t = this.outBuffers.get();
                        if (this.outBuffers.size() == 0) {
                            this.outBuffers = null;
                        }
                        this.outBuffer = (ByteBuffer)t;
                    }
                    if (this.outBuffer == null) {
                        return;
                    }
                    this.doWrite();
                    bl3 = false;
                    bl2 = false;
                    if (!this.outBuffer.hasRemaining()) {
                        if (this.outBuffers == null) continue;
                        byteBuffer = this.outBuffer;
                        this.outBuffer = null;
                        this.myListener.packetSent(this, byteBuffer);
                        if (this.outBuffers == null || this.outBuffers.size() == 0) continue;
                        bl2 = true;
                        bl3 = true;
                        continue;
                    }
                    bl2 = true;
                }
                if (bl2) {
                    this.requestWrite();
                } else if (this.outBuffers == null) {
                    byteBuffer = this.outBuffer;
                    this.outBuffer = null;
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.close();
                IOException iOException = new IOException(throwable.getMessage());
                this.myListener.socketException(this, iOException);
            }
        }
        if (bl) {
            this.myListener.packetSent(this, byteBuffer);
            if (this.closeRequested) {
                this.close();
            }
        }
    }

    public Channel getSocketChannel() {
        return this.myChannel;
    }

    public int doWrite() throws IOException {
        try {
            return this.myChannel.write(this.outBuffer);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().indexOf("An operation on a socket could not be performed because the system lacked sufficient buffer space or because a queue was full") != -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.retryWrite(50);
            }
            throw iOException;
        }
    }

    private int retryWrite(int n) throws IOException {
        try {
            return this.myChannel.write(this.outBuffer);
        }
        catch (IOException iOException) {
            if (n > 0 && iOException.getMessage() != null && iOException.getMessage().indexOf("An operation on a socket could not be performed because the system lacked sufficient buffer space or because a queue was full") != -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.retryWrite(n - 1);
            }
            throw iOException;
        }
    }

    public class fSelectorWorker
    implements fTask {
        @Override
        public void execute() {
            PacketChannel.this.handleSyncWrite();
        }

        @Override
        public boolean reQueue() {
            return false;
        }
    }
}

