/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio.io;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fStatsManager;
import com.pcbsys.foundation.drivers.nio.fModChannel;
import com.pcbsys.foundation.drivers.nio.handlers.Channel;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.threads.fThread;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SelectorThread
extends fThread {
    public static long SelectorMaxWait = SelectorThread.getSelectorWait();
    protected Selector mySelector;
    protected boolean isClosingFlag = false;
    private final List<Runnable> myDelayedSelectList = new ArrayList<Runnable>(100);

    protected static long getSelectorWait() {
        String string = fSystemConfiguration.getProperty("SelectorWait");
        long l = 60000L;
        if (string != null) {
            try {
                l = Long.parseLong(string);
                if (l < 10L) {
                    l = 10L;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return l;
    }

    public SelectorThread(String string) throws IOException {
        this(string, true);
    }

    protected SelectorThread(String string, boolean bl) throws IOException {
        this.mySelector = Selector.open();
        this.setName(string);
        this.setDaemon(true);
        this.setPriority(10);
        if (bl) {
            this.start();
        }
    }

    public void signalClose() {
        this.isClosingFlag = true;
        this.mySelector.wakeup();
    }

    public void RegisterDelayedChannelInterest(fModChannel fModChannel2) {
        this.addToDelayedList(fModChannel2);
    }

    public void RegisterDelayedChannelInterest(SelectableChannel selectableChannel, int n, Channel channel) {
        this.addToDelayedList(new fRegisterChannel(selectableChannel, n, channel));
    }

    public void UnRegisterDelayedChannelInterest(fModChannel fModChannel2) {
        this.addToDelayedList(fModChannel2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDelayedList(Runnable runnable) {
        if (this.isClosingFlag) {
            this.myDelayedSelectList.clear();
            return;
        }
        List<Runnable> list = this.myDelayedSelectList;
        synchronized (list) {
            this.myDelayedSelectList.add(runnable);
            this.mySelector.wakeup();
        }
    }

    public void RegisterImmediateChannelInterest(SelectableChannel selectableChannel, int n) throws IOException {
        if (!selectableChannel.isOpen()) {
            return;
        }
        SelectionKey selectionKey = selectableChannel.keyFor(this.mySelector);
        if (selectionKey != null && n != selectionKey.interestOps()) {
            this.changeKeyInterest(selectionKey, selectionKey.interestOps() | n);
        }
    }

    private void RegisterImmediateChannelInterest(SelectableChannel selectableChannel, int n, Channel channel) throws IOException {
        if (!selectableChannel.isOpen()) {
            return;
        }
        try {
            if (selectableChannel.isRegistered()) {
                SelectionKey selectionKey = selectableChannel.keyFor(this.mySelector);
                selectionKey.interestOps(n);
                selectionKey.attach(channel);
            } else {
                selectableChannel.configureBlocking(false);
                selectableChannel.register(this.mySelector, n, channel);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error registering channel.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public void UnRegisterImmediateChannelInterest(SelectableChannel selectableChannel, int n) throws IOException {
        SelectionKey selectionKey = selectableChannel.keyFor(this.mySelector);
        if (selectionKey != null) {
            try {
                this.changeKeyInterest(selectionKey, selectionKey.interestOps() & ~n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            long l = SelectorMaxWait * 1000000L;
            while (true) {
                if (this.isClosingFlag) {
                    this.closeAndCleanupChannels();
                    return;
                }
                try {
                    this.processDelayedSelections();
                    if (!this.hasTasks()) {
                        long l2 = System.nanoTime();
                        n2 = this.mySelector.select(SelectorMaxWait);
                        l2 = System.nanoTime() - l2;
                        bl = l2 >= l - 10000000L;
                    } else {
                        n2 = this.mySelector.selectNow();
                    }
                    if (n2 != 0) {
                        this.processSelectKeysIterator(this.mySelector.selectedKeys());
                        continue;
                    }
                    if (!this.hasTasks() && !bl) {
                        if (++n <= 10) continue;
                        try {
                            this.recreateSelector();
                        }
                        catch (Throwable throwable) {
                            fConstants.logger.log(throwable);
                        }
                        continue;
                    }
                    n = 0;
                }
                catch (IOException iOException) {
                    fConstants.logger.error(iOException);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    fConstants.logger.info(cancelledKeyException);
                }
                catch (Throwable throwable) {
                    fConstants.logger.error(throwable);
                }
                continue;
                break;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            fConstants.logger.error(outOfMemoryError);
            fBaseApplication.getApplication().memoryError("NIO Selector detected out of memory condition");
            return;
        }
        catch (Throwable throwable) {
            fConstants.logger.error(throwable);
            return;
        }
        finally {
            if (!this.isClosingFlag) {
                fConstants.logger.log("IO : NIO Selector thread <" + Thread.currentThread().getName() + "> exiting our side of a close");
            }
        }
    }

    protected boolean hasTasks() {
        return this.myDelayedSelectList.size() != 0;
    }

    private void recreateSelector() throws IOException {
        Selector selector = Selector.open();
        Set<SelectionKey> set = this.mySelector.keys();
        for (SelectionKey object2 : set) {
            if (object2.isValid()) {
                try {
                    SelectableChannel closedChannelException = object2.channel();
                    if (closedChannelException.isOpen()) {
                        Channel channel = (Channel)object2.attachment();
                        int n = object2.interestOps();
                        ((SocketChannel)closedChannelException).register(selector, n, channel);
                    }
                }
                catch (ClosedChannelException throwable) {
                    // empty catch block
                }
            }
            try {
                object2.cancel();
            }
            catch (Throwable iOException) {}
        }
        Selector selector2 = this.mySelector;
        this.mySelector = selector;
        try {
            selector2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDelayedSelections() {
        List<Runnable> list = this.myDelayedSelectList;
        synchronized (list) {
            for (int i = 0; i < this.myDelayedSelectList.size(); ++i) {
                try {
                    this.myDelayedSelectList.get(i).run();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.myDelayedSelectList.clear();
        }
    }

    private void processSelectKeysIterator(Set<SelectionKey> set) {
        long l = 0L;
        if (fStatsManager.useStats) {
            l = System.nanoTime();
        }
        for (SelectionKey selectionKey : set) {
            this.processKey(selectionKey);
        }
        set.clear();
        if (fStatsManager.useStats) {
            fStatsManager.update(0, System.nanoTime() - l);
        }
    }

    private void processKey(SelectionKey selectionKey) {
        if (selectionKey.isValid()) {
            try {
                int n = selectionKey.readyOps();
                selectionKey.interestOps(selectionKey.interestOps() & ~n);
                Channel channel = (Channel)selectionKey.attachment();
                if (selectionKey.isReadable() && selectionKey.isValid()) {
                    channel.handleRead();
                }
                if (selectionKey.isValid() && selectionKey.isWritable()) {
                    channel.handleWrite();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                fConstants.logger.info("NIO SelectorThread: channel has been closed");
            }
            catch (Throwable throwable) {
                fConstants.logger.info(throwable);
            }
        }
    }

    private void changeKeyInterest(SelectionKey selectionKey, int n) throws IOException {
        try {
            selectionKey.interestOps(n);
        }
        catch (CancelledKeyException cancelledKeyException) {
            IOException iOException = new IOException("Failed to change channel interest.");
            iOException.initCause(cancelledKeyException);
            throw iOException;
        }
    }

    private void closeAndCleanupChannels() {
        Set<SelectionKey> set = this.mySelector.keys();
        for (SelectionKey selectionKey : set) {
            try {
                this.UnRegisterImmediateChannelInterest(selectionKey.channel(), selectionKey.interestOps());
                selectionKey.channel().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            selectionKey.cancel();
        }
        try {
            this.mySelector.selectedKeys();
            this.mySelector.keys();
            this.mySelector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myDelayedSelectList.clear();
    }

    private class fRegisterChannel
    implements Runnable {
        private final SelectableChannel channel;
        private final int selectionKeys;
        private final Channel handlerInfo;

        public fRegisterChannel(SelectableChannel selectableChannel, int n, Channel channel) {
            this.channel = selectableChannel;
            this.selectionKeys = n;
            this.handlerInfo = channel;
        }

        @Override
        public void run() {
            try {
                SelectorThread.this.RegisterImmediateChannelInterest(this.channel, this.selectionKeys, this.handlerInfo);
            }
            catch (IOException iOException) {
                fConstants.logger.warn(iOException);
            }
        }
    }
}

