/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio.ssl;

import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.nio.handlers.Channel;
import com.pcbsys.foundation.drivers.nio.handlers.ChannelListener;
import com.pcbsys.foundation.drivers.nio.io.SelectorThread;
import com.pcbsys.foundation.drivers.nio.ssl.SSLSelectorThread;
import com.pcbsys.foundation.fConstants;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLChannel
extends Channel {
    private SSLEngine mySSlEngine;
    private SSLSelectorThread mySelector;
    private ByteBuffer decryptedData;
    private ByteBuffer receivedData;
    private ByteBuffer sendData;
    private byte[] myWorkingBuffer;
    private byte[] myZeroBuffer;
    private boolean hasReadInterest = false;
    private boolean hasWriteInterest = false;
    private boolean executingInitialHandshake = false;
    private SSLEngineResult.HandshakeStatus currentHandshakeStatus;
    private ByteBuffer unused;
    private boolean hasShutdown = false;
    private boolean hasClosed = false;
    private SSLEngineResult.Status myStatus = null;
    private IOException hasGeneratedException = null;
    private HandshakeCompletedListener myHandshakeListener = null;

    public SSLChannel(SelectorThread selectorThread, SocketChannel socketChannel, ChannelListener channelListener, SSLEngine sSLEngine) throws Exception {
        super(selectorThread, socketChannel, channelListener);
        this.mySSlEngine = sSLEngine;
        this.mySelector = (SSLSelectorThread)selectorThread;
        this.receivedData = ByteBuffer.allocate(this.mySSlEngine.getSession().getPacketBufferSize());
        this.decryptedData = ByteBuffer.allocate(this.mySSlEngine.getSession().getApplicationBufferSize());
        this.sendData = ByteBuffer.allocate(this.mySSlEngine.getSession().getPacketBufferSize());
        this.myWorkingBuffer = new byte[this.mySSlEngine.getSession().getPacketBufferSize()];
        this.myZeroBuffer = new byte[this.mySSlEngine.getSession().getPacketBufferSize()];
        for (int i = 0; i < this.myZeroBuffer.length; ++i) {
            this.myZeroBuffer[i] = 0;
        }
        this.decryptedData.position(this.decryptedData.limit());
        this.sendData.position(this.sendData.limit());
        this.unused = ByteBuffer.allocate(0);
    }

    @Override
    public void complete() throws IOException {
        this.mySelectorThread.RegisterDelayedChannelInterest(this.mySocketChannel, 0, this);
        long l = 0L;
        if (fConnectionDetails.sEnableConnectionDebug) {
            l = System.currentTimeMillis();
        }
        this.mySSlEngine.beginHandshake();
        this.currentHandshakeStatus = this.mySSlEngine.getHandshakeStatus();
        this.executingInitialHandshake = true;
        this.registerForRead();
        this.executeHandshake();
        if (fConnectionDetails.sEnableConnectionDebug) {
            long l2 = System.currentTimeMillis();
            fConstants.logger.log("SSL : Handshake completed in " + (l2 - l) + "ms");
        }
    }

    public SSLSession getSession() {
        return this.mySSlEngine.getSession();
    }

    public boolean isClosed() {
        return this.hasClosed;
    }

    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.myHandshakeListener = handshakeCompletedListener;
        if (!this.executingInitialHandshake) {
            this.myHandshakeListener.handshakeCompleted(null);
        }
    }

    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.myHandshakeListener = null;
    }

    private void checkSSLChannelIsOK() throws IOException {
        if (this.hasClosed) {
            throw new ClosedChannelException();
        }
        if (this.hasGeneratedException != null) {
            IOException iOException = new IOException("SSL Channel generated exception : " + this.hasGeneratedException.getMessage());
            iOException.initCause(this.hasGeneratedException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.checkSSLChannelIsOK();
        if (this.executingInitialHandshake) {
            return 0;
        }
        if (this.mySSlEngine.isInboundDone()) {
            return -1;
        }
        ByteBuffer byteBuffer2 = this.decryptedData;
        synchronized (byteBuffer2) {
            int n;
            if (!(this.decryptedData.hasRemaining() || (n = this.readAndDecrypt()) != -1 && n != 0)) {
                if (this.decryptedData.remaining() == 0) {
                    this.registerSelectorThreadRead();
                } else {
                    this.fireReadEvent();
                }
                return n;
            }
            n = Math.min(this.decryptedData.remaining(), byteBuffer.remaining());
            n = Math.min(n, this.myWorkingBuffer.length);
            this.decryptedData.get(this.myWorkingBuffer, 0, n);
            byteBuffer.put(this.myWorkingBuffer, 0, n);
            if (this.decryptedData.remaining() == 0) {
                this.registerSelectorThreadRead();
            }
            System.arraycopy(this.myZeroBuffer, 0, this.myWorkingBuffer, 0, n);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readAndDecrypt() throws IOException {
        ByteBuffer byteBuffer = this.decryptedData;
        synchronized (byteBuffer) {
            if (this.decryptedData.remaining() != 0) {
                return this.decryptedData.remaining();
            }
        }
        int n = this.mySocketChannel.read(this.receivedData);
        if (n == -1) {
            this.mySSlEngine.closeInbound();
            if (this.receivedData.position() == 0 || this.myStatus == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                return -1;
            }
        }
        ByteBuffer byteBuffer2 = this.decryptedData;
        synchronized (byteBuffer2) {
            SSLEngineResult sSLEngineResult;
            this.decryptedData.clear();
            this.receivedData.flip();
            while ((sSLEngineResult = this.mySSlEngine.unwrap(this.receivedData, this.decryptedData)).getStatus() == SSLEngineResult.Status.OK && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && sSLEngineResult.bytesProduced() == 0) {
            }
            if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.completeInitialHandshake();
            }
            if (this.decryptedData.position() == 0 && sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && this.receivedData.hasRemaining()) {
                sSLEngineResult = this.mySSlEngine.unwrap(this.receivedData, this.decryptedData);
            }
            this.myStatus = sSLEngineResult.getStatus();
            this.currentHandshakeStatus = sSLEngineResult.getHandshakeStatus();
            this.receivedData.compact();
            this.decryptedData.flip();
        }
        if (this.myStatus == SSLEngineResult.Status.CLOSED) {
            this.hasShutdown = true;
            this.executeShutdown();
            return -1;
        }
        if (this.currentHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || this.currentHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP || this.currentHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.executeHandshake();
        }
        return this.decryptedData.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        SSLEngineResult sSLEngineResult;
        this.checkSSLChannelIsOK();
        if (this.executingInitialHandshake) {
            return 0;
        }
        if (this.sendData.hasRemaining()) {
            return 0;
        }
        this.sendData.clear();
        SSLEngine sSLEngine = this.mySSlEngine;
        synchronized (sSLEngine) {
            sSLEngineResult = this.mySSlEngine.wrap(byteBuffer, this.sendData);
        }
        this.sendData.flip();
        this.flushOutgoingData();
        return sSLEngineResult.bytesConsumed();
    }

    @Override
    public void registerForRead() throws IOException {
        this.checkSSLChannelIsOK();
        if (!this.hasReadInterest) {
            this.hasReadInterest = true;
            if (this.executingInitialHandshake) {
                return;
            }
            if (this.decryptedData.hasRemaining()) {
                this.mySelector.registerForRead(this);
            } else if (this.receivedData.position() == 0 || this.myStatus == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.registerSelectorThreadRead();
            } else {
                this.fireReadEvent();
            }
        }
    }

    @Override
    public void unregisterForRead() throws IOException {
        this.checkSSLChannelIsOK();
        this.hasReadInterest = false;
        this.mySelector.unregisterForRead(this);
    }

    @Override
    public void registerForWrite() throws IOException {
        this.checkSSLChannelIsOK();
        if (!this.hasWriteInterest) {
            this.hasWriteInterest = true;
            if (this.executingInitialHandshake) {
                return;
            }
            if (!this.sendData.hasRemaining()) {
                this.mySelector.registerForWrite(this);
            }
        }
    }

    @Override
    public void unregisterForWrite() throws IOException {
        this.checkSSLChannelIsOK();
        this.hasWriteInterest = false;
        this.mySelector.unregisterForWrite(this);
    }

    void fireReadEvent() {
        this.hasReadInterest = false;
        try {
            if (this.mySocketChannel.isOpen()) {
                this.myListener.handleRead();
            } else {
                this.myListener.handleClose();
            }
        }
        catch (Throwable throwable) {
            fConstants.logger.debug(throwable);
        }
    }

    void fireWriteEvent() {
        this.hasWriteInterest = false;
        try {
            this.myListener.handleWrite(false);
        }
        catch (Exception exception) {
            fConstants.logger.debug(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeShutdown() throws IOException {
        if (this.hasGeneratedException != null || this.mySSlEngine.isOutboundDone()) {
            try {
                this.mySocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this.unregisterForWrite();
        this.unregisterForRead();
        try {
            SSLEngine sSLEngine = this.mySSlEngine;
            synchronized (sSLEngine) {
                this.mySSlEngine.wrap(this.unused, this.sendData);
            }
        }
        catch (SSLException sSLException) {
            try {
                this.mySocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public void close() {
        if (this.hasShutdown) {
            return;
        }
        try {
            boolean bl = false;
            for (int i = 0; this.mySocketChannel.isOpen() && this.sendData.remaining() != 0 && i < 3000 && Thread.currentThread() != this.mySelector.getNative(); ++i) {
                if (!bl) {
                    this.registerSelectorThreadWrite();
                    bl = true;
                }
                fJDKHelper.park(10L);
            }
        }
        catch (Throwable throwable) {
            fConstants.logger.info("An error occurred during SSL Channel close: " + throwable.getMessage());
            fConstants.logger.info(throwable);
        }
        this.hasClosed = true;
        this.hasGeneratedException = null;
        this.mySSlEngine.closeOutbound();
        try {
            this.executeShutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.mySocketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeInitialHandshake() throws IOException {
        if (fConnectionDetails.sEnableConnectionDebug) {
            fConstants.logger.log("Session Established using : Protocol:" + this.mySSlEngine.getSession().getProtocol() + " Cipher:" + this.mySSlEngine.getSession().getCipherSuite());
        }
        this.executingInitialHandshake = false;
        if (this.hasReadInterest) {
            this.registerSelectorThreadRead();
        }
        if (this.hasWriteInterest) {
            this.mySelector.registerForWrite(this);
        }
        SSLChannel sSLChannel = this;
        synchronized (sSLChannel) {
            if (this.myHandshakeListener != null) {
                this.myHandshakeListener.handshakeCompleted(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHandshake() throws IOException {
        while (true) {
            if (this.currentHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                if (this.executingInitialHandshake) {
                    this.completeInitialHandshake();
                }
                return;
            }
            if (this.currentHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.executeTasks();
                continue;
            }
            if (this.currentHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                int n = 0;
                ByteBuffer byteBuffer = this.receivedData;
                synchronized (byteBuffer) {
                    n = this.readAndDecrypt();
                }
                if (this.myStatus == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    this.registerSelectorThreadRead();
                }
                if (n != 0) {
                    this.mySelector.registerForRead(this);
                }
                return;
            }
            if (this.currentHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                SSLEngineResult sSLEngineResult;
                if (this.sendData.hasRemaining()) {
                    return;
                }
                this.sendData.clear();
                SSLEngine sSLEngine = this.mySSlEngine;
                synchronized (sSLEngine) {
                    sSLEngineResult = this.mySSlEngine.wrap(this.unused, this.sendData);
                }
                this.currentHandshakeStatus = sSLEngineResult.getHandshakeStatus();
                this.sendData.flip();
                if (this.flushOutgoingData()) continue;
                return;
            }
            if (this.currentHandshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
        }
    }

    @Override
    public void handleRead() {
        try {
            if (this.executingInitialHandshake) {
                this.executeHandshake();
            } else if (this.hasShutdown) {
                this.executeShutdown();
            } else {
                this.fireReadEvent();
            }
        }
        catch (IOException iOException) {
            this.handleAsynchException(iOException);
        }
    }

    private boolean flushOutgoingData() throws IOException {
        try {
            this.mySocketChannel.write(this.sendData);
        }
        catch (IOException iOException) {
            this.sendData.position(this.sendData.limit());
            throw iOException;
        }
        if (this.sendData.hasRemaining()) {
            this.registerSelectorThreadWrite();
            return false;
        }
        return true;
    }

    @Override
    public void handleWrite() {
        try {
            if (this.flushOutgoingData()) {
                if (this.executingInitialHandshake) {
                    this.executeHandshake();
                } else if (this.hasShutdown) {
                    this.executeShutdown();
                } else if (this.hasWriteInterest) {
                    this.mySelector.registerForWrite(this);
                }
            }
        }
        catch (IOException iOException) {
            this.handleAsynchException(iOException);
        }
    }

    private void handleAsynchException(IOException iOException) {
        if (!(iOException instanceof ClosedChannelException)) {
            String string = null;
            try {
                string = this.mySocketChannel.socket().getRemoteSocketAddress().toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (string != null) {
                fConstants.logger.info("nio.SSLChannel raised an exception : " + iOException.getMessage() + " Remote IP:" + string);
            } else {
                fConstants.logger.info("nio.SSLChannel raised an exception : " + iOException.getMessage());
            }
            fConstants.logger.info(iOException);
        }
        this.hasGeneratedException = iOException;
        if (this.hasWriteInterest) {
            this.mySelector.registerForWrite(this);
        }
        if (this.hasReadInterest) {
            this.mySelector.registerForRead(this);
        }
        this.mySSlEngine.closeOutbound();
    }

    private void registerSelectorThreadRead() throws IOException {
        if (this.mySelectorThread.isThread(Thread.currentThread())) {
            this.mySelectorThread.RegisterImmediateChannelInterest(this.mySocketChannel, 1);
        } else {
            this.mySelectorThread.RegisterDelayedChannelInterest(this.myReadMod);
        }
    }

    private void registerSelectorThreadWrite() throws IOException {
        if (this.mySelectorThread.isThread(Thread.currentThread())) {
            this.mySelectorThread.RegisterImmediateChannelInterest(this.mySocketChannel, 4);
        } else {
            this.mySelectorThread.RegisterDelayedChannelInterest(this.myWriteMod);
        }
    }

    private void executeTasks() {
        Runnable runnable;
        while ((runnable = this.mySSlEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        this.currentHandshakeStatus = this.mySSlEngine.getHandshakeStatus();
    }
}

