/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio.ssl;

import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.configuration.fDriverConfig;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.nio.handlers.Channel;
import com.pcbsys.foundation.drivers.nio.handlers.ChannelFactory;
import com.pcbsys.foundation.drivers.nio.handlers.ChannelListener;
import com.pcbsys.foundation.drivers.nio.io.SelectorThread;
import com.pcbsys.foundation.drivers.nio.ssl.SSLChannel;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLChannelFactory
implements ChannelFactory {
    private fBaseSSLConfig myConfig;
    private SSLContext context;

    public SSLChannelFactory(fBaseSSLConfig fBaseSSLConfig2) throws IOException {
        this.myConfig = fBaseSSLConfig2;
        this.context = (SSLContext)fJDKHelper.getSSLContextFactory().getContext(this.myConfig);
        SSLEngine sSLEngine = this.createEngine();
        this.myConfig.setConfigredCiphers(sSLEngine.getSupportedCipherSuites());
        if (this.myConfig.getEnabledCiphers() != null) {
            this.logCipherList((fDriverConfig)((Object)this.myConfig), this.myConfig.getEnabledCiphers());
        } else {
            this.myConfig.setEnabledCiphers(sSLEngine.getEnabledCipherSuites());
            this.logCipherList((fDriverConfig)((Object)this.myConfig), this.myConfig.getEnabledCiphers());
        }
    }

    protected SSLEngine createEngine() throws IOException {
        String[] stringArray;
        SSLEngine sSLEngine = this.context.createSSLEngine();
        if (this.myConfig.getEnabledCiphers() != null) {
            sSLEngine.setEnabledCipherSuites(this.myConfig.getEnabledCiphers());
        } else {
            this.myConfig.setEnabledCiphers(sSLEngine.getEnabledCipherSuites());
        }
        sSLEngine.setUseClientMode(false);
        sSLEngine.setNeedClientAuth(this.myConfig.getCertRequired());
        sSLEngine.setEnableSessionCreation(true);
        String string = fSystemConfiguration.getProperty("SSLProtocols", "TLSv1,TLSv1.1,TLSv1.2");
        if (string != null) {
            stringArray = string.split(",");
            String[] stringArray2 = sSLEngine.getSupportedProtocols();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : stringArray) {
                boolean bl = false;
                for (String string3 : stringArray2) {
                    if (!string2.endsWith(string3)) continue;
                    arrayList.add(string2);
                    bl = true;
                    break;
                }
                if (bl) continue;
                fConstants.logger.log("Requested SSL protocol " + string2 + " not available, dropping from list");
            }
            String[] stringArray3 = new String[arrayList.size()];
            arrayList.toArray(stringArray3);
            sSLEngine.setEnabledProtocols(stringArray3);
        }
        for (String string4 : stringArray = sSLEngine.getEnabledProtocols()) {
            fConstants.logger.debug("Protocols Enabled : " + string4);
        }
        return sSLEngine;
    }

    private void logCipherList(fDriverConfig fDriverConfig2, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            fConstants.logger.log("SSL CipherList for " + fDriverConfig2.getURL() + " " + stringArray[i]);
        }
    }

    @Override
    public Channel createChannel(SocketChannel socketChannel, SelectorThread selectorThread, ChannelListener channelListener) throws Exception {
        return new SSLChannel(selectorThread, socketChannel, channelListener, this.createEngine());
    }
}

