/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.nio.ssl;

import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.drivers.nio.io.SelectorThread;
import com.pcbsys.foundation.drivers.nio.ssl.SSLChannel;
import java.io.IOException;

public class SSLSelectorThread
extends SelectorThread {
    private final Vector readListeners = new Vector();
    private final Vector writeListeners = new Vector();

    public SSLSelectorThread(String string) throws IOException {
        super(string, false);
        this.start();
    }

    @Override
    public void signalClose() {
        super.signalClose();
        this.readListeners.removeAllElements();
        this.writeListeners.removeAllElements();
    }

    @Override
    protected boolean hasTasks() {
        return super.hasTasks() || this.readListeners.size() != 0 || this.writeListeners.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processDelayedSelections() {
        while (this.readListeners.size() != 0 || this.writeListeners.size() != 0) {
            SSLChannel sSLChannel;
            Vector vector = null;
            Vector vector2 = null;
            SSLSelectorThread sSLSelectorThread = this;
            synchronized (sSLSelectorThread) {
                if (this.readListeners.size() != 0) {
                    vector = new Vector(this.readListeners);
                    this.readListeners.removeAllElements();
                }
                if (this.writeListeners.size() != 0) {
                    vector2 = new Vector(this.writeListeners);
                    this.writeListeners.removeAllElements();
                }
            }
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    sSLChannel = (SSLChannel)vector.elementAt(i);
                    sSLChannel.fireReadEvent();
                }
            }
            if (vector2 == null) continue;
            for (int i = 0; i < vector2.size(); ++i) {
                sSLChannel = (SSLChannel)vector2.elementAt(i);
                sSLChannel.fireWriteEvent();
            }
        }
        super.processDelayedSelections();
    }

    public synchronized void registerForRead(SSLChannel sSLChannel) {
        if (!this.isClosingFlag && this.readListeners.add(sSLChannel)) {
            this.mySelector.wakeup();
        }
    }

    public synchronized void unregisterForRead(SSLChannel sSLChannel) {
        if (!this.isClosingFlag && this.readListeners.remove(sSLChannel)) {
            this.mySelector.wakeup();
        }
    }

    public synchronized void registerForWrite(SSLChannel sSLChannel) {
        if (!this.isClosingFlag && this.writeListeners.add(sSLChannel)) {
            this.mySelector.wakeup();
        }
    }

    public synchronized void unregisterForWrite(SSLChannel sSLChannel) {
        if (!this.isClosingFlag && this.writeListeners.remove(sSLChannel)) {
            this.mySelector.wakeup();
        }
    }
}

