/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.proxy;

import com.pcbsys.foundation.collections.Hashtable;
import com.pcbsys.foundation.drivers.jdk.fProxyInfo;
import com.pcbsys.foundation.drivers.proxy.fAuthHelper;
import com.pcbsys.foundation.drivers.proxy.fBasicAuthHelper;
import com.pcbsys.foundation.drivers.proxy.fUserAuthenticationRequest;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class fAuthFactory {
    private static fAuthFactory myInstance;
    private static fUserAuthenticationRequest sMyUserCallback;
    private final Hashtable<String, fBasicAuthHelper> myAuthHelpers = new Hashtable();

    public static void setUserAuthenticationCallback(fUserAuthenticationRequest fUserAuthenticationRequest2) {
        sMyUserCallback = fUserAuthenticationRequest2;
    }

    public static fUserAuthenticationRequest getUserAuthenticationCallback() {
        return sMyUserCallback;
    }

    public static fAuthFactory getInstance() {
        if (myInstance == null) {
            myInstance = new fAuthFactory();
        }
        return myInstance;
    }

    private fAuthFactory() {
        this.myAuthHelpers.put("basic", new fBasicAuthHelper());
    }

    public fAuthHelper getAuthHelper(String string, fProxyInfo fProxyInfo2) throws IOException {
        String string2 = string.trim();
        int n = string2.indexOf(" ");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        String string3 = fAuthFactory.getAuthString(fProxyInfo2, string2);
        fAuthHelper fAuthHelper2 = (fAuthHelper)this.myAuthHelpers.get(string2.toLowerCase());
        if (fAuthHelper2 != null) {
            return fAuthHelper2.getInstance(string, string3);
        }
        throw new IOException("Unsupported authentication protocol : " + string2);
    }

    private static String getAuthString(fProxyInfo fProxyInfo2, String string) throws IOException {
        String string2 = fSystemConfiguration.getProperty("HAUTH");
        if (string2 != null && string2.contains(":")) {
            return string2;
        }
        if (sMyUserCallback != null) {
            return sMyUserCallback.getUsernameCredentials(string);
        }
        AuthenticatorRequest authenticatorRequest = new AuthenticatorRequest(fProxyInfo2.getHost(), fProxyInfo2.getPort(), string);
        Object object = AccessController.doPrivileged(authenticatorRequest);
        if (object instanceof Exception) {
            Exception exception = (Exception)object;
            throw new IOException("Failed to run PasswordAuthentication : " + exception.getMessage());
        }
        if (object instanceof PasswordAuthentication) {
            PasswordAuthentication passwordAuthentication = (PasswordAuthentication)object;
            return passwordAuthentication.getUserName() + ":" + new String(passwordAuthentication.getPassword());
        }
        return null;
    }

    public static class AuthenticatorRequest
    implements PrivilegedAction<Object> {
        private final String myHost;
        private final int myPort;
        private final String myType;

        public AuthenticatorRequest(String string, int n, String string2) {
            this.myHost = string;
            this.myPort = n;
            this.myType = string2;
        }

        @Override
        public Object run() {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.myHost);
                return Authenticator.requestPasswordAuthentication(inetAddress, this.myPort, "HTTPS", "Please enter the user credentials for the proxy server", this.myType);
            }
            catch (Exception exception) {
                return exception;
            }
        }
    }
}

