/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.rdma;

import com.pcbsys.foundation.drivers.rdma.RDMACommon;
import java.io.IOException;
import java.util.ArrayList;

public final class RDMACallback {
    private final ArrayList<Long> myAcceptQueue = new ArrayList();
    private boolean isClosed = false;

    public void close() {
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long accept() throws IOException {
        ArrayList<Long> arrayList = this.myAcceptQueue;
        synchronized (arrayList) {
            while (this.myAcceptQueue.size() == 0 && !this.isClosed) {
                try {
                    this.myAcceptQueue.wait(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.isClosed) continue;
                throw new IOException("RDMA Connection closed");
            }
            long l = this.myAcceptQueue.remove(0);
            if (RDMACommon.sDEBUG) {
                RDMACommon.log("We have a new client " + Long.toHexString(l));
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rdma_accept_callback(long l) {
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Native C callback to java, remote connection received, passing off to Java for processing");
        }
        ArrayList<Long> arrayList = this.myAcceptQueue;
        synchronized (arrayList) {
            this.myAcceptQueue.add(l);
            this.myAcceptQueue.notify();
        }
    }
}

